/*
 * Decompiled with CFR 0.152.
 */
package com.inet.dbupdater.model;

import com.inet.dbupdater.databases.DatabaseInfoFactory;
import com.inet.dbupdater.model.Constructor;
import com.inet.dbupdater.model.Node;
import com.inet.dbupdater.model.NodeFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ConstructorSAX
extends DefaultHandler {
    private Constructor constructor;
    private String skipUntil = null;
    private final int dbConstant;

    public ConstructorSAX(NodeFactory factory, int dbConstant) {
        this.dbConstant = dbConstant;
        this.constructor = new Constructor(factory);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.skipUntil != null) {
            return;
        }
        if (this.dbConstant != -1 && NodeFactory.TAG.database.toString().equalsIgnoreCase(name)) {
            if (attributes == null) {
                this.skipUntil = name;
                return;
            }
            String productName = attributes.getValue("productname");
            if (DatabaseInfoFactory.getDatabaseType(productName) != this.dbConstant) {
                this.skipUntil = name;
                return;
            }
        }
        this.constructor.startElement(name);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                String value = attributes.getValue(i);
                this.constructor.setParameterToCurrentElement(attName, value);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.skipUntil != null) {
            return;
        }
        this.constructor.addText(new String(ch, start, length));
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.skipUntil != null) {
            if (this.skipUntil.equalsIgnoreCase(name)) {
                this.skipUntil = null;
            }
            return;
        }
        this.constructor.endCurrentElement(name);
    }

    public Node getRoot() {
        return this.constructor.getRoot();
    }
}

