/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.group;

import com.inet.field.FieldUtils;
import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.HelpDeskUserGroupManager;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.ui.fields.group.SelectGroupFieldDefinition;
import java.util.HashMap;
import java.util.Set;

public class EscalationGroupFieldDefinition
extends SelectGroupFieldDefinition<Integer> {
    private UserGroupField<Integer> groupField;

    public EscalationGroupFieldDefinition(String groupKey, UserGroupField<Integer> groupField, int prio) {
        super(groupKey, groupField.getKey(), prio);
        this.groupField = groupField;
    }

    public SelectOption getValue(UserGroupInfo groupInfo) {
        UserGroupInfo userGroupInfo;
        Integer val;
        String value = "";
        Object displayName = "";
        if (groupInfo != null && (val = (Integer)groupInfo.getValue(this.groupField)) != null && (userGroupInfo = ((HelpDeskUserGroupManager)UserGroupManager.getRecoveryEnabledInstance()).getUserGroupInfoForResourceId(val)) != null) {
            value = val.toString();
            displayName = userGroupInfo.getDisplayName();
            if (!userGroupInfo.isActive()) {
                displayName = (String)displayName + " (" + HelpDeskUserManager.MSG.getMsg("deleted", new Object[0]) + ")";
            }
        }
        return new SelectOption(value, (String)displayName);
    }

    public SelectOptionResult getOptions(UserGroupInfo groupInfo, String searchTerm, int currentSize, int chunkSize) {
        GUID id = groupInfo == null ? null : groupInfo.getID();
        HashMap<String, String> valuesToDisplayNames = new HashMap<String, String>();
        valuesToDisplayNames.put("", "");
        UserGroupManager manager = UserGroupManager.getRecoveryEnabledInstance();
        Set allGroups = manager.getAllGroups();
        for (UserGroupInfo userGroupInfo : allGroups) {
            if (userGroupInfo.getType() != HDUsersAndGroups.RESOURCE || userGroupInfo.getID().equals((Object)id)) continue;
            String key = String.valueOf(userGroupInfo.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID));
            valuesToDisplayNames.put(key, manager.getFullDisplayName(userGroupInfo));
        }
        return FieldUtils.getOptions((String)searchTerm, (int)currentSize, (int)chunkSize, valuesToDisplayNames);
    }

    public Integer convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            try {
                return Integer.valueOf(option.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.MSG.getMsg("field." + this.groupField.getKey(), new Object[0]);
    }
}

