/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.ticketmanager.fields.priority.PriorityManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class PrioritySubViewGrouping
extends SimpleSubViewGrouping {
    public static final PrioritySubViewGrouping INSTANCE = new PrioritySubViewGrouping();

    private PrioritySubViewGrouping() {
        super("priorityid");
    }

    @Override
    public String getDisplayName() {
        return Tickets.FIELD_PRIORITY_ID.getLabel();
    }

    @Override
    public List<SubView<?>> getSubViews(@Nonnull TicketViewFactory parent, @Nonnull GUID accountID, Locale locale, @Nonnull Set<Integer> ticketIDs) {
        ArrayList result = new ArrayList();
        Map<Integer, String> names = PriorityManager.getInstance().getAllAttributeDisplayNames(false);
        try (UserAccountScope scope = UserAccountScope.create((GUID)accountID);){
            for (Map.Entry<Integer, String> entry : names.entrySet()) {
                result.add(new SubView<Integer>(parent, this, entry.getKey(), entry.getValue(), null, entry.getKey().toString()));
            }
        }
        Comparator comp = (a, b) -> -((Integer)a.getChildID()).compareTo((Integer)b.getChildID());
        result.sort(comp);
        return result;
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        if (StringFunctions.isEmpty((String)iconKey)) {
            return HelpDeskServer.class.getResource("images/column_prio_16.gif");
        }
        try {
            int prioID = Integer.parseInt(iconKey);
            return PriorityManager.getInstance().getIcon(prioID, size);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

