/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketReader;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldSortedIteratorDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.SortGroupInformation;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.core.ticketview.TicketListState;
import com.inet.helpdesk.core.ticketview.TicketListUpdateEvent;
import com.inet.helpdesk.core.ticketview.TicketListUpdateListener;
import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.core.ticketview.TicketViewSearchCommandFactory;
import com.inet.helpdesk.ticketview.BaseTicketListChangeMonitor;
import com.inet.helpdesk.ticketview.EntrySetSortedIterator;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.http.websocket.WebSocketEventData;
import com.inet.http.websocket.WebSocketEventHandler;
import com.inet.id.GUID;
import com.inet.lib.util.Scope;
import com.inet.lib.util.StringFunctions;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.DynamicExtension;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.thread.EventDispatcher;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class TicketListChangeMonitor
extends BaseTicketListChangeMonitor {
    private static final int EXTRA_FETCH_SIZE = 100;
    private static final ForkJoinPool POOL = new ForkJoinPool(4);
    private static final AtomicInteger POOL_COUNT = new AtomicInteger();
    private static final DynamicExtension<TicketFieldDefinition> FIELD_DEF = new DynamicExtension(TicketFieldDefinition.class);
    private final TicketListUpdateListener updateListener;
    private final IndexSearchEngine<Integer> engine;
    private final IndexSearchEngine<SlaveInfo> slaveInfoEngine;
    private final GUID accountID;
    @Nonnull
    private final Locale locale;
    private final TimeZone timezone;
    private SearchCommand searchCommand;
    private List<Integer> oldTicketIds = Collections.emptyList();
    private String oldSortedColumn;
    private long startTime;
    private boolean stopped;
    private String clientID;
    private final EventDispatcher<?> eventDispatcher = new EventDispatcher(false, false, POOL);
    private final HashSet<Integer> collectedChangedIds = new HashSet();

    TicketListChangeMonitor(@Nonnull String clientID, TicketListUpdateListener updateListener, TicketListState state, TicketViewSearchCommandFactory factory, IndexSearchEngine<Integer> engine, @Nullable IndexSearchEngine<SlaveInfo> slaveInfoEngine) {
        super(state, factory);
        this.startTime = System.currentTimeMillis();
        this.clientID = clientID;
        this.updateListener = updateListener;
        this.engine = engine;
        this.slaveInfoEngine = slaveInfoEngine;
        this.accountID = UserManager.getInstance().getCurrentUserAccountID();
        this.locale = ClientLocale.getThreadLocale();
        this.timezone = ClientTimezone.getTimeZone();
        this.searchCommand = factory.createSearchCommand(this.accountID, this.locale, engine);
        if (this.searchCommand == null) {
            HDLogger.debug("User " + String.valueOf(this.accountID) + " has no access rights to current ticket view: " + this.getFactory().getID());
            return;
        }
        this.checkForVisibleChanges(null);
    }

    @Override
    void updateFactory(@Nonnull TicketViewSearchCommandFactory factory) {
        super.updateFactory(factory);
        SearchCommand newCommand = factory.createSearchCommand(this.accountID, this.locale, this.engine);
        if (newCommand == null) {
            HDLogger.debug("User " + String.valueOf(this.accountID) + " has lost access rights to current ticket view: " + this.getFactory().getID());
            return;
        }
        if (newCommand.getSearchExpression().equals((Object)this.searchCommand.getSearchExpression())) {
            return;
        }
        this.searchCommand = newCommand;
        this.checkForVisibleChanges(null);
    }

    void ticketChanged(@Nonnull Collection<Integer> changedIds) {
        this.searchCommand = this.getFactory().createSearchCommand(this.accountID, this.locale, this.engine);
        if (!Collections.disjoint(changedIds, this.oldTicketIds)) {
            this.checkForVisibleChanges(changedIds);
        } else {
            SearchCommand command = new SearchCommand(this.locale, new SearchExpression[]{new PrefilteredSearchExpression(changedIds)});
            command.getSearchExpression().addAll((Collection)this.searchCommand.getSearchExpression());
            if (this.engine.simpleSearch(command).size() > 0) {
                this.checkForVisibleChanges(changedIds);
            }
        }
    }

    @Override
    void setTicketListState(@Nonnull TicketListState state) {
        if (!Objects.equals(this.getTicketListState().getSearchPhrase(), state.getSearchPhrase())) {
            this.engine.cancel(this.createSearchID());
            this.startTime = System.currentTimeMillis();
        }
        super.setTicketListState(state);
        this.checkForVisibleChanges(null);
    }

    void stop() {
        this.stopped = true;
        this.engine.cancel(this.createSearchID());
    }

    SearchCommand getSearchCommand() {
        return this.searchCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForVisibleChanges(@Nullable Collection<Integer> changedIds) {
        if (changedIds != null) {
            HashSet<Integer> hashSet = this.collectedChangedIds;
            synchronized (hashSet) {
                this.collectedChangedIds.addAll(changedIds);
            }
        }
        this.eventDispatcher.dispatchEvent(() -> {
            HashSet<Integer> currentChangedIds;
            HashSet<Integer> hashSet = this.collectedChangedIds;
            synchronized (hashSet) {
                if (changedIds != null && this.collectedChangedIds.size() == 0) {
                    return;
                }
                currentChangedIds = new HashSet<Integer>(this.collectedChangedIds);
                this.collectedChangedIds.clear();
            }
            POOL_COUNT.incrementAndGet();
            try {
                this.checkForVisibleChangesImpl(currentChangedIds);
            }
            catch (Throwable th) {
                WebSocketEventHandler.getInstance().sendEvent(this.clientID, () -> new WebSocketEventData("error", (Object)StringFunctions.getUserFriendlyErrorMessage((Throwable)th)));
                HDLogger.error(th);
            }
            finally {
                POOL_COUNT.decrementAndGet();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForVisibleChangesImpl(@Nonnull Collection<Integer> changedIds) throws Exception {
        TimeZone origTimezone = ClientTimezone.getTimeZone();
        try (UserAccountScope scope = UserAccountScope.create((GUID)this.accountID);
             Scope localeScope = ClientLocale.scope((Locale)this.locale);){
            ArrayList<TokenMatcher> tokenMatcher;
            ClientTimezone.setTimeZone((TimeZone)this.timezone);
            ArrayList<Integer> newTicketIds = new ArrayList<Integer>();
            SearchCommand command = this.searchCommand;
            TicketListState state = this.getTicketListState();
            String searchPhrase = state.getSearchPhrase();
            if (StringFunctions.isEmpty((String)searchPhrase)) {
                command = this.searchCommand;
            } else {
                HashSet<SearchTag> tags = new HashSet<SearchTag>(this.engine.getTags());
                tokenMatcher = this.engine.getTokenMatcher();
                if (!HDUsersAndGroups.isSupporter(this.accountID)) {
                    tokenMatcher = null;
                }
                if (tokenMatcher != null) {
                    tokenMatcher = new ArrayList<TokenMatcher>(tokenMatcher);
                    tokenMatcher.removeIf(m -> !m.isTextSearchEnabled());
                }
                tags.removeIf(tag -> !tag.isTextSearchEnabled());
                command = new TextSearchCommandBuilder(tags, tokenMatcher, searchPhrase).build();
                AndSearchExpression expressions = command.getSearchExpression();
                expressions.addAll(0, (Collection)this.searchCommand.getSearchExpression());
                if (expressions.size() == 0 && "*".equals(searchPhrase)) {
                    expressions.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
                }
            }
            command.setID(this.createSearchID());
            Set result = this.engine.simpleSearch(command);
            if (result == IndexSearchEngine.CANCEL_RESULT) {
                tokenMatcher = this.collectedChangedIds;
                synchronized (tokenMatcher) {
                    this.collectedChangedIds.addAll(changedIds);
                }
                return;
            }
            boolean limitExceeded = command.getResultLimit() <= result.size();
            TicketViewManager.getInstance().convertToBunIdsIfNeeded(this.slaveInfoEngine, result, this.accountID);
            int totalSearchCount = result.size();
            int windowSize = state.getWindowSize();
            String column = state.getSortedColumn();
            TicketFieldDefinition fieldDef = TicketListChangeMonitor.getFieldDefinition(column);
            List<TicketVO> ticketList = this.getLimitTickets(result, fieldDef);
            Comparator<TicketVO> comp = fieldDef.getComparator();
            comp = comp.thenComparing((a, b) -> Integer.compare(a.getID(), b.getID()));
            if (!state.isSortedAscending()) {
                comp = Collections.reverseOrder(comp);
            }
            ticketList.sort(comp);
            windowSize = this.getTicketListState().getWindowSize();
            Iterator<TicketVO> it = ticketList.iterator();
            while (it.hasNext()) {
                Integer id = it.next().getID();
                if (!result.contains(id) || newTicketIds.contains(id)) continue;
                newTicketIds.add(id);
                if (newTicketIds.size() < windowSize) continue;
                break;
            }
            this.compareTicketList(newTicketIds, changedIds, column, totalSearchCount, limitExceeded);
        }
        finally {
            ClientTimezone.setTimeZone((TimeZone)origTimezone);
        }
    }

    @Nonnull
    private static TicketFieldDefinition getFieldDefinition(String column) throws IllegalArgumentException {
        for (TicketFieldDefinition def : FIELD_DEF.get()) {
            if (!Objects.equals(column, def.getKey())) continue;
            return def;
        }
        if ("ticketid".equals(column)) {
            throw new IllegalArgumentException("Unknown Column: " + column);
        }
        return TicketListChangeMonitor.getFieldDefinition("ticketid");
    }

    private static Map<Integer, String> getGroupMapping(String column, Collection<Integer> ticketIds) {
        TicketFieldDefinition def = TicketListChangeMonitor.getFieldDefinition(column);
        SortGroupInformation info = def.getSortGroupInformation();
        if (!info.supportsSortGroups()) {
            return null;
        }
        TicketReader reader = TicketManager.getReader();
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (Integer id : ticketIds) {
            TicketVO ticket = reader.getTicket(id);
            if (ticket == null) continue;
            String key = info.getSortGroupKey(ticket);
            result.put(id, key);
        }
        return result;
    }

    private void compareTicketList(ArrayList<Integer> newTicketIds, @Nonnull Collection<Integer> changedIds, String column, int totalSearchCount, boolean limitExceeded) {
        Integer newId;
        Integer oldId;
        int newEnd;
        Integer newId2;
        Integer oldId2;
        int removeOffset;
        int oldEnd = Math.min(this.oldTicketIds.size(), newTicketIds.size());
        for (removeOffset = 0; removeOffset < oldEnd && (oldId2 = this.oldTicketIds.get(removeOffset)).equals(newId2 = newTicketIds.get(removeOffset)); ++removeOffset) {
        }
        oldEnd = this.oldTicketIds.size();
        for (newEnd = newTicketIds.size(); oldEnd > removeOffset && newEnd > removeOffset && (oldId = this.oldTicketIds.get(oldEnd - 1)).equals(newId = newTicketIds.get(newEnd - 1)); --oldEnd, --newEnd) {
        }
        HashSet<Integer> changedTicketIds = new HashSet<Integer>();
        for (int i = removeOffset; i < newEnd; ++i) {
            Integer id = newTicketIds.get(i);
            if (this.oldTicketIds.contains(id)) continue;
            changedTicketIds.add(id);
        }
        for (Integer id : changedIds) {
            if (!newTicketIds.contains(id)) continue;
            changedTicketIds.add(id);
        }
        Map<Integer, String> sortGroupKeys = TicketListChangeMonitor.getGroupMapping(column, Objects.equals(this.oldSortedColumn, column) ? changedTicketIds : newTicketIds);
        int insertOffset = removeOffset;
        int insertLength = newEnd - insertOffset;
        int removeLength = oldEnd - removeOffset;
        if (removeLength == 0 && insertLength == 0 && changedTicketIds.size() == 0 && changedIds.size() != 0 && (sortGroupKeys == null || sortGroupKeys.size() == 0)) {
            return;
        }
        if (insertLength > 0 && removeLength > 0) {
            int identicalLength;
            int firstNewIdx = this.oldTicketIds.indexOf(newTicketIds.get(insertOffset));
            int firstOldIdx = newTicketIds.indexOf(this.oldTicketIds.get(removeOffset));
            if (firstNewIdx >= 0 && (firstNewIdx < firstOldIdx || firstOldIdx < 0)) {
                int identicalLength2 = oldEnd - firstNewIdx;
                if (identicalLength2 <= insertLength && this.oldTicketIds.subList(firstNewIdx, oldEnd).equals(newTicketIds.subList(removeOffset, removeOffset + identicalLength2))) {
                    removeLength -= identicalLength2;
                    insertLength -= identicalLength2;
                    insertOffset += identicalLength2;
                }
            } else if (firstOldIdx >= 0 && (identicalLength = newEnd - firstOldIdx) <= removeLength && newTicketIds.subList(firstOldIdx, newEnd).equals(this.oldTicketIds.subList(insertOffset, insertOffset + identicalLength))) {
                removeLength -= identicalLength;
                insertLength -= identicalLength;
                removeOffset += identicalLength;
            }
        }
        if (this.stopped) {
            HDLogger.debug("TicketListChanged event not send because stopped.");
            return;
        }
        TicketListUpdateEvent evt = new TicketListUpdateEvent(removeOffset, removeLength, insertOffset, newTicketIds.subList(insertOffset, insertOffset + insertLength), changedTicketIds, sortGroupKeys, this.getTicketListState(), totalSearchCount, limitExceeded, this.getFactory().getID());
        this.updateListener.ticketListChanged(evt);
        this.oldTicketIds = newTicketIds;
        this.oldSortedColumn = column;
    }

    @Nonnull
    private List<TicketVO> getLimitTickets(Set<Integer> result, TicketFieldDefinition fieldDef) throws Exception {
        boolean isFirstShow;
        EntrySetSortedIterator it;
        TicketListState state = this.getTicketListState();
        int windowSize = state.getWindowSize();
        int maxSort = 100 + windowSize;
        String column = state.getSortedColumn();
        TicketReader reader = TicketManager.getReader();
        if (result.size() <= windowSize) {
            return reader.getTickets(result);
        }
        long time = System.currentTimeMillis() + 2000L;
        ArrayList<TicketVO> tickets = new ArrayList<TicketVO>(maxSort);
        FieldSortedIteratorDefinition sortedDef = fieldDef.getSortedDefinition();
        if (sortedDef != null) {
            it = sortedDef.getIterator(result, this.engine, state.isSortedAscending());
        } else if ("ticketid".equals(column)) {
            ArrayList<Integer> list = new ArrayList<Integer>(result);
            list.sort(state.isSortedAscending() ? Comparator.naturalOrder() : Comparator.reverseOrder());
            it = list.iterator();
        } else {
            SearchTag tag = this.engine.getTag(column);
            boolean forward = state.isSortedAscending();
            if (tag == null) {
                tag = this.engine.getTag("lastchanged");
                maxSort = Math.max(10000, 100 + windowSize);
                forward = false;
            }
            it = new EntrySetSortedIterator(this.engine.createEntryIterator(tag, forward), forward);
        }
        HashSet<Integer> newResult = new HashSet<Integer>();
        Consumer<Integer> addTicket = id -> {
            block5: {
                try {
                    TicketVO ticket = reader.getTicket((int)id);
                    if (ticket == null) break block5;
                    List list = tickets;
                    synchronized (list) {
                        tickets.add(ticket);
                    }
                }
                catch (AccessDeniedException accessDeniedException) {
                    // empty catch block
                }
            }
        };
        AtomicInteger threadCount = new AtomicInteger();
        boolean bl = isFirstShow = this.oldTicketIds.size() == 0;
        while (true) {
            if (it.hasNext()) {
                Integer id2 = (Integer)it.next();
                if (!result.contains(id2) || !newResult.add(id2)) continue;
                if (isFirstShow && threadCount.get() < 2 && POOL_COUNT.get() < POOL.getParallelism()) {
                    threadCount.getAndIncrement();
                    POOL_COUNT.incrementAndGet();
                    POOL.execute(() -> {
                        try (UserAccountScope scope = UserAccountScope.create((GUID)this.accountID);){
                            addTicket.accept(id2);
                        }
                        finally {
                            threadCount.getAndDecrement();
                            POOL_COUNT.decrementAndGet();
                        }
                    });
                } else {
                    addTicket.accept(id2);
                }
            }
            if (!it.hasNext() || tickets.size() >= maxSort || System.currentTimeMillis() >= time) break;
        }
        if (!it.hasNext() && !this.stopped && tickets.size() < windowSize && result.size() > newResult.size()) {
            ArrayList<Integer> list = new ArrayList<Integer>(result);
            boolean forward = state.isSortedAscending();
            list.sort(forward ? Comparator.naturalOrder() : Comparator.reverseOrder());
            int count = forward ? 0 : tickets.size();
            for (Integer id3 : list) {
                if (!newResult.add(id3)) continue;
                addTicket.accept(id3);
                if (count++ < windowSize) continue;
                break;
            }
        }
        while (threadCount.get() > 0) {
            Thread.sleep(10L);
        }
        if (it.hasNext() && !this.stopped) {
            int ticketSize = tickets.size();
            int maxSort0 = maxSort;
            POOL_COUNT.incrementAndGet();
            POOL.execute(() -> {
                try {
                    block14: {
                        long time2 = System.currentTimeMillis() + 2000L;
                        UserAccountScope scope = UserAccountScope.create((GUID)this.accountID);
                        block10: while (true) {
                            while (it.hasNext() && 100 + 2 * windowSize > newResult.size() && System.currentTimeMillis() < time2) {
                                Integer id = (Integer)it.next();
                                if (!result.contains(id) || !newResult.add(id)) continue;
                                try {
                                    reader.getTicket(id);
                                    continue block10;
                                }
                                catch (AccessDeniedException accessDeniedException) {
                                }
                            }
                            break block14;
                            {
                                continue block10;
                                break;
                            }
                            break;
                        }
                        finally {
                            if (scope != null) {
                                scope.close();
                            }
                        }
                    }
                    if (ticketSize < maxSort0 && this.startTime + 30000L > System.currentTimeMillis()) {
                        this.checkForVisibleChanges(null);
                    }
                }
                finally {
                    POOL_COUNT.decrementAndGet();
                }
            });
        }
        return tickets;
    }

    @Nonnull
    private SearchID createSearchID() {
        return new SearchID((Object)("ticketview" + this.clientID));
    }
}

