/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.userfunctions;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassManager;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserClassVO;
import com.inet.helpdesk.shared.LicenceInfo;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.PermissionCheckScope;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class ReportRestrictionFunctions
implements UserDefinedFunction {
    private static final int USER_COUNT_LICENSE = 0;
    private static final int NAMED_USER_LICENSE = 1;
    private static final int NAMED_USER_LICENSE_ERROR = 2;

    public boolean hasAccessToUserManager() {
        return SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_CREATEUSERS);
    }

    public boolean hasAccessToUserManagerAdmin() {
        return SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER_ADMIN);
    }

    public boolean hasAccessToOptions() {
        return SystemPermissionChecker.checkAccess((Permission)Permission.CONFIGURATION);
    }

    public boolean hasAccessToInventory() {
        try {
            Permission permission = Permission.valueOf((String)"inventoryRead");
            return SystemPermissionChecker.checkAccess((Permission)permission);
        }
        catch (IllegalArgumentException pluginNotAvailable) {
            return false;
        }
    }

    public boolean hasAccessToReports() {
        if (!ServerPluginManager.getInstance().isPluginLoaded("drive")) {
            return false;
        }
        return SystemPermissionChecker.checkAccess((Permission)Permission.valueOf((String)"drive"));
    }

    public boolean hasWriteAccessToInventory() {
        try {
            Permission permission = Permission.valueOf((String)"inventoryReadWrite");
            return SystemPermissionChecker.checkAccess((Permission)permission);
        }
        catch (IllegalArgumentException pluginNotAvailable) {
            return false;
        }
    }

    public boolean isCurrentUser(int usrID) throws AccessDeniedException {
        UserManager um = UserManager.getInstance();
        GUID accountID = um.getCurrentUserAccountID();
        if (accountID == null) {
            HDLogger.error("User Login required for id check!");
            throw new AccessDeniedException();
        }
        return usrID == HDUsersAndGroups.getUserID(accountID);
    }

    public boolean userHasPermission(int userID, String permissionKey) throws IllegalArgumentException {
        UserAccount ua = HDUsersAndGroups.getUserAccount(userID);
        if (ua == null) {
            throw new IllegalArgumentException("Invalid user ID " + userID);
        }
        PermissionCheckScope checkScope = new PermissionCheckScope(ua);
        Permission p = Permission.valueOf((String)permissionKey);
        return SystemPermissionChecker.hasAnyPermission((PermissionCheckScope)checkScope, (Permission[])new Permission[]{p});
    }

    public String getServerURL() {
        try {
            int position;
            HttpServletRequest req = SessionStore.getHttpServletRequest();
            if (req == null) {
                HDLogger.debug(new IllegalStateException("No request found"));
                return "";
            }
            String url = req.getRequestURL().toString();
            if (url.indexOf(63) > 0) {
                url = url.substring(0, url.indexOf(63));
            }
            if ((position = url.indexOf("/rpc/")) > -1) {
                url = url.substring(0, position + 1);
            }
            return url;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public boolean isSupervisorOf(int userId) throws IllegalArgumentException, AccessDeniedException {
        UserManager manager = UserManager.getInstance();
        UserAccount userAccount = HDUsersAndGroups.getUserAccount(userId);
        if (userAccount == null) {
            throw new IllegalArgumentException("Invalid user ID " + userId);
        }
        GUID currentUserGUID = manager.getCurrentUserAccountID();
        if (currentUserGUID == null) {
            HDLogger.error("User Login required for supervisor check!");
            throw new AccessDeniedException();
        }
        Integer userGroupKey = (Integer)userAccount.getValue((UserField)HDUsersAndGroups.FIELD_CLASS_ID);
        if (userGroupKey == null) {
            throw new IllegalArgumentException("Invalid user group ID " + userId);
        }
        List<UserClassVO> supervisorGroups = UserClassManager.getInstance().getTeamsWhereUserIsSupervisor(currentUserGUID);
        return supervisorGroups.stream().filter(e -> e.getId() == userGroupKey.intValue()).count() > 0L;
    }

    public boolean hasReadAccessToTickets(int[] tickets) throws AccessDeniedException {
        if (tickets == null) {
            return false;
        }
        for (int id : tickets) {
            if (this.hasReadAccessToTicket(id)) continue;
            return false;
        }
        return true;
    }

    public boolean hasReadAccessToTicket(int ticketId) throws AccessDeniedException {
        return TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketId);
    }

    public Boolean[] getNamedUserPermissionsFlags() {
        Permission[] permissions = HdPermissions.getSortedPermissions();
        List<Permission> namedPermissions = Arrays.asList(HdPermissions.getNamedUserLicensePermissions());
        Boolean[] values = new Boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            values[i] = namedPermissions.contains(permissions[i]) ? Boolean.TRUE : Boolean.FALSE;
        }
        return values;
    }

    public String[] getUserPermissionsNames() {
        Permission[] permissions = HdPermissions.getSortedPermissions();
        String[] names = new String[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            names[i] = permissions[i].getDisplayName();
        }
        return names;
    }

    public String[] getUserPermissionsKeys() {
        Permission[] permissions = HdPermissions.getSortedPermissions();
        String[] keys = new String[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            keys[i] = permissions[i].getKey();
        }
        return keys;
    }

    public int getNamedUserLicenseInfo() {
        LicenceInfo licInf = LicenceInfo.getInstance();
        if (licInf.isNamedUserLicence()) {
            if (licInf.getNamedUserLicenceCount() < licInf.getNamedUserCount()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public Boolean[] getUserHasPermissions(int userId, String[] permissionKeys) throws IllegalArgumentException {
        UserAccount ua = HDUsersAndGroups.getUserAccount(userId);
        if (ua == null) {
            throw new IllegalArgumentException("Invalid user ID " + userId);
        }
        Boolean[] result = new Boolean[permissionKeys.length];
        try {
            PermissionCheckScope checkScope = new PermissionCheckScope(ua);
            for (int i = 0; i < permissionKeys.length; ++i) {
                Permission p = Permission.valueOf((String)permissionKeys[i]);
                result[i] = SystemPermissionChecker.hasAnyPermission((PermissionCheckScope)checkScope, (Permission[])new Permission[]{p});
            }
        }
        catch (IllegalArgumentException ec) {
            HDLogger.error(ec);
        }
        return result;
    }

    public Integer[] getAllUsersWithPermissions() {
        ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
        additionalExpressions.add(new SearchCondition("permissions", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        UserGroupManager groupManager = UserGroupManager.getInstance();
        SearchResult groupResult = groupManager.search("", additionalExpressions, new ArrayList(), Integer.MAX_VALUE, null);
        Stream<Integer> groupIdStream = groupResult.getEntries().stream().map(e -> groupManager.getGroup((GUID)e.getId())).flatMap(g -> g.getMemberIDs().stream()).map(HDUsersAndGroups::getUserID);
        SearchResult result = UserManager.getInstance().search("", additionalExpressions, new ArrayList(), Integer.MAX_VALUE, null);
        Stream<@Nonnull Integer> individualStream = result.getEntries().stream().map(e -> HDUsersAndGroups.getUserID((GUID)e.getId()));
        Set supporters = groupManager.getGroups(HDUsersAndGroups.RESOURCE);
        supporters.addAll(groupManager.getGroups(UsersAndGroups.GROUPTYPE_ADMIN));
        Stream<Integer> supportersUserIdStream = supporters.stream().map(UserGroupInfo::getMemberIDs).flatMap(Collection::stream).map(HDUsersAndGroups::getUserID);
        Stream<@Nonnull Integer> allIds = Stream.concat(Stream.concat(groupIdStream, individualStream), supportersUserIdStream);
        return (Integer[])allIds.distinct().toArray(Integer[]::new);
    }
}

