/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.config;

import com.inet.annotations.JsonData;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigRowAction;
import com.inet.config.structure.model.ItemListConfigProperty;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.LdapConnectionInfo;
import com.inet.helpdesk.config.LdapConnectionInfoMap;
import com.inet.helpdesk.config.Translator;
import com.inet.helpdesk.core.HDLogger;
import com.inet.lib.json.Json;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import srv.automatic.LdapUtilities;

@JsonData
public class LdapConnectionInfoListConfigProperty
extends ItemListConfigProperty {
    private static final String ACTION_TEST_LDAP_NEW = "helpdesk.db.testldap.new";
    private static String DEFAULT_LDAP = "389";
    private static String DEFAULT_LDAPS = "636";

    public LdapConnectionInfoListConfigProperty(ConfigStructureSettings settings, Translator translator) {
        super(0, HDConfigKeys.LDAP_CONNECTION_INFOS.getKey(), "LDAP_CONNECTION_INFOS", LdapConnectionInfoListConfigProperty.getObjectListValue(settings), translator.translate("ldapconfigs.add.new"), new ConfigRowAction[]{LdapConnectionInfoListConfigProperty.getRowAction(settings, translator)});
    }

    static Object getObjectListValue(ConfigStructureSettings settings) {
        HashMap[] changedValue = (HashMap[])settings.getChangedValue(HDConfigKeys.LDAP_CONNECTION_INFOS, HashMap[].class);
        ArrayList<Thread> checkingThreads = new ArrayList<Thread>();
        if (changedValue != null) {
            for (HashMap account : changedValue) {
                LdapConnectionInfoListConfigProperty.setPortForDatabase(account);
                LdapConnectionInfo info = LdapConnectionInfoListConfigProperty.convertToEntry(account);
                account.put("status", DatabaseConfigInfo.Status.Invalid.name());
                if (settings.isFilter()) continue;
                LdapConnectionInfoListConfigProperty.createAndStartConnectionCheckingThreadAndAddItToTheList(account, info, checkingThreads);
            }
            if (!settings.isFilter()) {
                LdapConnectionInfoListConfigProperty.waitForCheckingThreadsToBeDone(checkingThreads);
            }
            return changedValue;
        }
        String valueStr = settings.getValue(HDConfigKeys.LDAP_CONNECTION_INFOS);
        LdapConnectionInfoMap ldapConnList = (LdapConnectionInfoMap)new Json().fromJson(valueStr, LdapConnectionInfoMap.class);
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        List list = ldapConnList.entrySet().stream().map(e -> (LdapConnectionInfo)e.getValue()).collect(Collectors.toList());
        for (LdapConnectionInfo info : list) {
            HashMap<String, String> entry = LdapConnectionInfoListConfigProperty.convertToHashmap(info);
            if (!settings.isFilter()) {
                LdapConnectionInfoListConfigProperty.createAndStartConnectionCheckingThreadAndAddItToTheList(entry, info, checkingThreads);
            }
            result.add(entry);
        }
        if (!settings.isFilter()) {
            LdapConnectionInfoListConfigProperty.waitForCheckingThreadsToBeDone(checkingThreads);
        }
        return result;
    }

    private static void waitForCheckingThreadsToBeDone(List<Thread> checkingThreads) {
        long restZeit = 3000L;
        long startingToWaitTime = System.currentTimeMillis();
        for (Thread t : checkingThreads) {
            if ((restZeit -= System.currentTimeMillis() - startingToWaitTime) <= 0L) {
                t.interrupt();
                continue;
            }
            try {
                t.join(restZeit);
                if (!t.isAlive()) continue;
                t.interrupt();
            }
            catch (InterruptedException e) {
                HDLogger.error(e);
            }
        }
    }

    private static void createAndStartConnectionCheckingThreadAndAddItToTheList(HashMap<String, String> account, LdapConnectionInfo info, List<Thread> checkingThreads) {
        Thread checkingThread = new Thread(() -> {
            try {
                LdapUtilities.getDirContext(info).getAttributes("");
                account.put("status", DatabaseConfigInfo.Status.Valid.name());
            }
            catch (NamingException exc) {
                HDLogger.debug(exc);
                account.put("status", DatabaseConfigInfo.Status.Invalid.name());
            }
        }, "connectionChecker" + (checkingThreads.size() + 1));
        checkingThread.setDaemon(true);
        checkingThread.start();
        checkingThreads.add(checkingThread);
    }

    private static HashMap<String, String> convertToHashmap(LdapConnectionInfo info) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(info);
        result.put("portldap", "");
        result.put("portldaps", "");
        if (info.getPort() > 0) {
            result.put(LdapConnectionInfoListConfigProperty.portFieldForDatabase(info.isSsl()), "" + info.getPort());
        }
        result.put("password", info.getDecodedPassword());
        result.put("isNewlyCreated", "false");
        return result;
    }

    public static LdapConnectionInfoMap convertToMap(HashMap<String, String>[] result) {
        LdapConnectionInfoMap map = new LdapConnectionInfoMap();
        for (HashMap<String, String> ldapEntry : result) {
            LdapConnectionInfo info = LdapConnectionInfoListConfigProperty.convertToEntry(ldapEntry);
            map.put(UUID.randomUUID().toString(), info);
        }
        return map;
    }

    static LdapConnectionInfo convertToEntry(HashMap<String, String> ldapEntry) {
        LdapConnectionInfo info = new LdapConnectionInfo(ldapEntry.get("name") == null ? "" : ldapEntry.get("name"));
        info.setUser(ldapEntry.get("user") == null ? "" : ldapEntry.get("user"));
        info.setHost(ldapEntry.get("host") == null ? "" : ldapEntry.get("host"));
        boolean ssl = LdapConnectionInfoListConfigProperty.isSsl(ldapEntry);
        info.setSsl(ssl);
        info.setDomaene(ldapEntry.get("domaene") == null ? "" : ldapEntry.get("domaene"));
        if ((info.getDomaene() == null || info.getDomaene().isEmpty()) && info.getUser() != null && info.getUser().contains("\\")) {
            String domaene = info.getUser().substring(0, info.getUser().indexOf(92));
            String user = info.getUser().substring(info.getUser().indexOf(92) + 1);
            info.setDomaene(domaene);
            info.setUser(user);
            ldapEntry.put("user", user);
            ldapEntry.put("domaene", domaene);
        }
        String password = ldapEntry.get("password") == null ? "" : ldapEntry.get("password");
        info.setDecodedPassword(password);
        String p = ldapEntry.get(LdapConnectionInfoListConfigProperty.portFieldForDatabase(ssl));
        p = p == null ? "" : p;
        ldapEntry.put("portldap", "");
        ldapEntry.put("portldaps", "");
        if (p != null && !p.equals("null") && !p.trim().isEmpty()) {
            try {
                int portInt = Integer.valueOf(p);
                if (portInt > 0) {
                    ldapEntry.put("port", p);
                    ldapEntry.put(LdapConnectionInfoListConfigProperty.portFieldForDatabase(ssl), p);
                    info.setPort(portInt);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        info.setSearchContext(ldapEntry.getOrDefault("searchContext", ""));
        if (ldapEntry.containsKey("status")) {
            info.setStatus(DatabaseConfigInfo.Status.valueOf(ldapEntry.get("status") == null ? "" : ldapEntry.get("status")));
        }
        return info;
    }

    static void setPortForDatabase(HashMap<String, String> account) {
        String portString;
        String portField;
        if (account.get("ssl") != null && (portField = LdapConnectionInfoListConfigProperty.portFieldForDatabase(LdapConnectionInfoListConfigProperty.isSsl(account))) != null && account.get(portField) != null && !"null".equals((portString = account.get(portField)).trim())) {
            account.put("port", portString);
        }
    }

    private static boolean isSsl(HashMap<String, String> account) {
        return Boolean.valueOf(account.getOrDefault("ssl", "false"));
    }

    private static String portFieldForDatabase(boolean ssl) {
        if (ssl) {
            return "portldaps";
        }
        return "portldap";
    }

    private static ConfigRowAction getRowAction(ConfigStructureSettings settings, Translator translator) {
        ConfigAction action = new ConfigAction("ldapconfig.new", translator.translate("AddLdapConnection"));
        ConfigCategory category = new ConfigCategory(0, "ldapconfig.new", translator.translate("LDAPverbindung"), "new-ldapconfig");
        ArrayList<ConfigPropertyGroup> propertyGroups = new ArrayList<ConfigPropertyGroup>();
        propertyGroups.add(new ConfigPropertyGroup(0, "ldapconfig.new.group", "", new ConfigAction(ACTION_TEST_LDAP_NEW, translator.translate(ACTION_TEST_LDAP_NEW))));
        HashMap properties = new HashMap();
        ArrayList<Object> propertyList = new ArrayList<Object>();
        properties.put("ldapconfig.new.group", propertyList);
        ArrayList<ConfigConditionAction> conditions = new ArrayList<ConfigConditionAction>();
        ConditionGenerator g = new ConditionGenerator();
        conditions.add(g.enableActionFor(g.createCondition().property("isNewlyCreated").equals().value((Object)"true"), "name"));
        ConfigCondition isLdap = g.createCondition().property("ssl").equals().value((Object)"false");
        ConfigCondition isLdaps = g.createCondition().property("ssl").equals().value((Object)"true");
        conditions.add(g.visibleActionFor(isLdap, "portldap"));
        conditions.add(g.visibleActionFor(isLdaps, "portldaps"));
        ConfigRowAction rowAction = new ConfigRowAction(action, null, category, propertyGroups, properties, conditions);
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("SimpleText", translator.translate("DBName"), "name", ""));
        propertyList.add(new SelectConfigProperty(123, "ssl", "SimpleText", translator.translate("ldapType"), (Object)String.valueOf(settings.getValue("ssl")), null, (List)new ArrayList<LocalizedKey>(){
            {
                this.add(new LocalizedKey("false", "LDAP"));
                this.add(new LocalizedKey("true", "LDAPS (SSL)"));
            }
        }));
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("SimpleText", translator.translate("LdapHost"), "host", ""));
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("FixNumber", translator.translate("Port"), "portldap", settings.getValue("portldap"), DEFAULT_LDAP));
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("FixNumber", translator.translate("Port"), "portldaps", settings.getValue("portldaps"), DEFAULT_LDAPS));
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("SimpleText", translator.translate("Benutzername"), "user", ""));
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("Password", translator.translate("Passwort"), "password", ""));
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("SimpleText", translator.translate("Domaene"), "domaene", ""));
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("SimpleText", translator.translate("ldap.searchContext"), "searchContext", "", translator.translate("ldap.searchContext.example")));
        propertyList.add(LdapConnectionInfoListConfigProperty.propWith("Hidden", "isNewlyCreated", "isNewlyCreated", "true"));
        return rowAction;
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, null);
    }

    private static ConfigProperty propWith(String type, String label, String keyName, String value, String placeholder) {
        return new ConfigProperty(0, keyName, type, label, (Object)value, null, placeholder);
    }
}

