/*
 * Decompiled with CFR 0.152.
 */
package srv.orderlistcache.cache;

import com.inet.helpdesk.core.HDLogger;
import com.inet.thread.ThreadUtils;
import java.sql.SQLException;
import java.util.Map;
import srv.orderlistcache.CachedResultSet;
import srv.orderlistcache.OrderListCommandFactory;
import srv.orderlistcache.cache.QueryCacheKey;

public class QueryCache {
    private final Map<QueryCacheKey, CachedResultSet> cache;
    private final OrderListCommandFactory.OrderLoader factory;

    public QueryCache(Map<QueryCacheKey, CachedResultSet> cache, OrderListCommandFactory.OrderLoader factory) {
        this.cache = cache;
        this.factory = factory;
    }

    public void invalidate(QueryCacheKey key) {
        if (HDLogger.isDebug()) {
            HDLogger.debug("WHIPE " + key);
        }
        if (this.cache.remove(key) != null && HDLogger.isDebug()) {
            HDLogger.debug("WHIPE key not in cache anymore");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedResultSet get(QueryCacheKey key) throws SQLException {
        try (ThreadUtils.Semaphore semaphore = ThreadUtils.getSemaphore((Object)key);){
            ThreadUtils.Semaphore semaphore2 = semaphore;
            synchronized (semaphore2) {
                block11: {
                    CachedResultSet current = this.cache.get(key);
                    if (current == null) break block11;
                    CachedResultSet cachedResultSet = current;
                    return cachedResultSet;
                }
                CachedResultSet rs = this.factory.createEntry(key);
                this.cache.put(key, rs);
                CachedResultSet cachedResultSet = rs;
                return cachedResultSet;
            }
        }
    }
}

