/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.TicketIdDefList;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TicketIdIdentifier {
    private static final int INVALID_KEY = 0;
    private static final Map<String, Pattern> stringToPattern = new HashMap<String, Pattern>();
    public static String[] idsString;

    public static int testForIDs(String testString) {
        if (testString == null) {
            return -1;
        }
        return TicketIdIdentifier.testForIDs(testString, idsString);
    }

    protected static int testForIDs(String testString, String[] identifierStrings) {
        List patternList = Arrays.stream(identifierStrings).map(s -> {
            Pattern pattern = stringToPattern.get(s);
            if (pattern == null) {
                String normalizedIdString = Pattern.quote(Tickets.normaliseTicketIdString(s));
                pattern = Pattern.compile(".*(" + normalizedIdString + "-*((\\d+)-*([A-Z]+[A-Za-z0-9]*))).*");
                stringToPattern.put((String)s, pattern);
            }
            return pattern;
        }).collect(Collectors.toList());
        testString = Tickets.normaliseTicketIdString(testString);
        for (Pattern p : patternList) {
            int result = TicketIdIdentifier.extractTicketID(testString, p);
            if (result == -1) continue;
            return result;
        }
        return -1;
    }

    private static int extractTicketID(String testString, Pattern p) {
        Matcher matcher = p.matcher(testString);
        if (matcher.find()) {
            try {
                String ticketId = matcher.group(3);
                String checksum = matcher.group(4);
                return TicketIdIdentifier.checkAndReturnTicketID(ticketId, checksum);
            }
            catch (Exception e) {
                HDLogger.error(e);
            }
        }
        return -1;
    }

    private static Integer checkAndReturnTicketID(String ticketID, String checksum) {
        try {
            Integer ticketIDInt = Integer.valueOf(ticketID);
            if (checksum.length() < ticketID.length()) {
                return 0;
            }
            char c = checksum.charAt(0);
            if (c - 26 != ticketID.charAt(0)) {
                return 0;
            }
            for (int i = 1; i < ticketID.length(); ++i) {
                if (ticketID.charAt(i - 1) - ticketID.charAt(i) + 74 == checksum.charAt(i)) continue;
                if (ticketID.charAt(i - 1) == '=' && ticketID.charAt(i) == '?') {
                    return ticketIDInt;
                }
                return 0;
            }
            String serverUID = checksum.substring(ticketID.length());
            String expectedID = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.TICKET_ID_SERVER_UID);
            if (serverUID.length() >= expectedID.length() && !expectedID.equals(serverUID = serverUID.substring(0, expectedID.length()))) {
                return -1;
            }
            return ticketIDInt;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static {
        new ConfigValue<TicketIdDefList>(HDConfigKeys.TICKET_ID_DEF_LIST){

            protected void setValue(String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                ArrayList<String> keys = new ArrayList<String>();
                TicketIdDefList defList = (TicketIdDefList)this.get();
                for (int i = 0; i < defList.size(); ++i) {
                    String normalisedValue = Tickets.normaliseTicketIdString((String)defList.get(i));
                    keys.add(i, normalisedValue);
                }
                if (keys.size() == 0) {
                    keys.add("TicketID");
                }
                idsString = keys.toArray(new String[keys.size()]);
            }
        };
    }
}

