/*
 * Decompiled with CFR 0.152.
 */
package srv.mail;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.shared.utils.TrustAllSSLSocketFactory;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;

public class MailConnectionCreator {
    public static Folder getConnectedFolder(EmailAccount emailAccount, @Nonnull SessionStoreStatus status, int connectiontimeout, int timeout) throws HelpDeskServerException {
        if (status == null) {
            throw new IllegalArgumentException("status must not be null");
        }
        Logger logger = LogManager.getLogger((String)"Mail");
        Folder folder = null;
        String host = emailAccount.getHost();
        String account = emailAccount.getAccount();
        if (host != null && host.trim().length() > 0 && account != null && account.trim().length() > 0) {
            Store store = null;
            try {
                store = MailConnectionCreator.generateConnectedStore(emailAccount, logger, connectiontimeout, timeout);
                status.setStore(store);
                folder = store.getFolder("INBOX");
                if (folder == null || !folder.exists()) {
                    throw new HelpDeskServerException("Connect failed: 'INBOX' does not exist.", (ErrorCode)HelpDeskErrorCodes.MAIL_ACCOUNT_OPEN_ERROR);
                }
                folder.open(2);
            }
            catch (Exception ex) {
                StringBuilder buf = new StringBuilder("Konnte ").append((Object)emailAccount.getProtocol()).append("-Konto ").append(account).append(" nicht \u00f6ffnen!").append('\n');
                buf.append(ex.getMessage() + (account.contains("@") ? " (Benutzernamen ohne Dom\u00e4ne probieren?)" : ""));
                HelpDeskServerException exception = new HelpDeskServerException(buf.toString(), (Throwable)ex, HelpDeskErrorCodes.MAIL_ACCOUNT_OPEN_ERROR);
                logger.error((Object)exception);
                try {
                    if (folder != null && folder.isOpen()) {
                        folder.close(true);
                    }
                }
                catch (MessagingException mex) {
                    logger.error((Object)new HelpDeskServerException("Could not close folder " + account, (Throwable)mex, HelpDeskErrorCodes.MAIL_ACCOUNT_CLOSE_ERROR));
                }
                try {
                    if (store != null && store.isConnected()) {
                        store.close();
                    }
                }
                catch (MessagingException mex2) {
                    logger.error((Object)new HelpDeskServerException("Could not close store " + account, (Throwable)mex2, HelpDeskErrorCodes.MAIL_ACCOUNT_CLOSE_ERROR));
                }
                throw exception;
            }
            return folder;
        }
        if (account == null || account.trim().length() == 0) {
            throw new HelpDeskServerException("Connect failed: host '" + host + "' - AUTHENTICATE failed", (ErrorCode)HelpDeskErrorCodes.MAIL_ACCOUNT_OPEN_ERROR);
        }
        throw new HelpDeskServerException("Connect failed: host '" + host + "'.", (ErrorCode)HelpDeskErrorCodes.MAIL_ACCOUNT_OPEN_ERROR);
    }

    private static Store generateConnectedStore(EmailAccount emailAccount, Logger logger, int connectiontimeout, int timeout) throws MessagingException {
        boolean isSSL = emailAccount.getSSL();
        Properties props = MailConnectionCreator.generateProps(emailAccount, isSSL, connectiontimeout, timeout);
        props.setProperty("mail.debug", String.valueOf(logger.isDebug()));
        props.setProperty("mail.debug.auth", String.valueOf(logger.isDebug()));
        Session session = Session.getInstance((Properties)props, null);
        if (logger.isDebug()) {
            session.setDebugOut(LogManager.getLogStream());
            logger.debug((Object)("Session class loader: " + session.getClass().getClassLoader()));
            logger.debug((Object)("Context class loader: " + Thread.currentThread().getContextClassLoader()));
        }
        String emailProtocol = emailAccount.getProtocol().toString().toLowerCase();
        if (isSSL && "imap".equals(emailProtocol)) {
            emailProtocol = "imaps";
        }
        Store store = session.getStore(emailProtocol);
        String host = emailAccount.getHost();
        String account = emailAccount.getAccount();
        String passwordDecoded = emailAccount.getPasswordDecoded();
        store.connect(host, account, passwordDecoded);
        return store;
    }

    private static Properties generateProps(EmailAccount emailAccount, boolean isSSL, int connectiontimeout, int timeout) {
        String protokollString;
        Properties props = (Properties)System.getProperties().clone();
        int mailPort = emailAccount.getPort();
        switch (emailAccount.getProtocol()) {
            case WebDAV: {
                if (mailPort == 0) {
                    mailPort = isSSL ? 443 : 80;
                }
                protokollString = "mail.webdav.";
                props.setProperty("webdav.inbox", emailAccount.getDirectory());
                break;
            }
            case POP3: {
                if (mailPort == 0) {
                    mailPort = isSSL ? 995 : 110;
                }
                protokollString = "mail.pop3.";
                break;
            }
            default: {
                if (mailPort == 0) {
                    mailPort = isSSL ? 993 : 143;
                }
                protokollString = isSSL ? "mail.imaps." : "mail.imap.";
            }
        }
        props.setProperty(protokollString + "port", String.valueOf(mailPort));
        if (isSSL) {
            props.setProperty(protokollString + "socketFactory.fallback", "false");
            props.setProperty(protokollString + "socketFactory.port", String.valueOf(mailPort));
            props.setProperty(protokollString + "socketFactory.class", TrustAllSSLSocketFactory.class.getName());
        } else {
            props.setProperty(protokollString + "socketFactory.fallback", "");
            props.setProperty(protokollString + "socketFactory.port", "");
            props.setProperty(protokollString + "socketFactory.class", "");
        }
        props.setProperty(protokollString + "fetchsize", "524288");
        props.setProperty(protokollString + "auth.ntlm.disable", String.valueOf(emailAccount.getPreventNtlmAuth()));
        props.setProperty(protokollString + "auth.plain.disable", String.valueOf(emailAccount.getPreventPlainAuth()));
        props.setProperty(protokollString + "connectiontimeout", String.valueOf(connectiontimeout));
        props.setProperty(protokollString + "timeout", String.valueOf(timeout));
        return props;
    }

    public static class SessionStoreStatus {
        private Store store;
        private Session session;

        public Session getSession() {
            return this.session;
        }

        public Store getStore() {
            return this.store;
        }

        public void setStore(Store store) {
            this.store = store;
        }

        public void setSession(Session session) {
            this.session = session;
        }
    }
}

