/*
 * Decompiled with CFR 0.152.
 */
package srv.controller;

import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import srv.controller.UserSession;

public class UserVersionManager {
    private static final UserVersionManager INSTANCE = new UserVersionManager();
    private static final int DEFAULT_USER_VERSION = 1;
    private static final int DEFAULT_ORDER_VERSION = 0;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<GUID, Versions> versionMap = new HashMap<GUID, Versions>();
    private int currentUserVersion = 1;

    UserVersionManager() {
    }

    public static UserVersionManager getInstance() {
        return INSTANCE;
    }

    public int getCurrentUserVersion() {
        try {
            this.readWriteLock.readLock().lock();
            int n = this.currentUserVersion;
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Versions getVersions(GUID userId) {
        try {
            this.readWriteLock.readLock().lock();
            Versions ver = this.versionMap.get(userId);
            if (ver == null) {
                Versions versions = new Versions(1, 0);
                return versions;
            }
            Versions versions = new Versions(ver.getUserVersion(), ver.getOrderVersion());
            return versions;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void incUserVersion(GUID accountID) {
        try {
            this.readWriteLock.writeLock().lock();
            Versions ver = this.versionMap.get(accountID);
            if (ver == null) {
                ver = new Versions(1, 0);
                this.versionMap.put(accountID, ver);
            }
            ver.setUserVersion(++this.currentUserVersion);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void incOrderVersion(GUID accountID) {
        try {
            this.readWriteLock.writeLock().lock();
            Versions ver = this.versionMap.get(accountID);
            if (ver == null) {
                ver = new Versions(1, 0);
                this.versionMap.put(accountID, ver);
            }
            ver.setOrderVersion(ver.getOrderVersion() + 1);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public void removeVersions(GUID accountID) {
        try {
            this.readWriteLock.writeLock().lock();
            this.versionMap.remove(accountID);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangedUsers(UserSession session) {
        if (session == null) {
            return "";
        }
        try {
            this.readWriteLock.readLock().lock();
            int version = session.getCheckedVersion();
            if (version < 1 || version == this.currentUserVersion) {
                String string = "";
                return string;
            }
            StringBuffer buf = null;
            for (Map.Entry<GUID, Versions> entry : this.versionMap.entrySet()) {
                if (entry.getValue().getUserVersion() <= version) continue;
                int userID = HDUsersAndGroups.getUserID(entry.getKey());
                if (buf == null) {
                    buf = new StringBuffer().append(userID);
                    continue;
                }
                buf.append(',').append(userID);
            }
            String string = buf == null ? "" : buf.toString();
            return string;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserGroupChangesVersion(int[] groups) {
        OrSearchExpression orExpression = new OrSearchExpression();
        Arrays.stream(groups).forEach(id -> orExpression.add((Object)new SearchCondition("groupid", SearchCondition.SearchTermOperator.Equals, (Object)id)));
        SearchResult result = UserManager.getInstance().search("", Arrays.asList(orExpression), Collections.emptyList(), Integer.MAX_VALUE, null);
        List accountIDs = result.getEntries().stream().map(SearchResultEntry::getId).collect(Collectors.toList());
        try {
            this.readWriteLock.readLock().lock();
            int maxVersion = -1;
            for (GUID accID : accountIDs) {
                Versions ver;
                if (maxVersion == -1) {
                    maxVersion = 0;
                }
                int orderVer = (ver = this.versionMap.get(accID)) == null ? 0 : ver.getOrderVersion();
                maxVersion = Math.max(maxVersion, orderVer);
            }
            String string = String.valueOf(maxVersion);
            return string;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public static class Versions {
        private int userVersion;
        private int orderVersion;

        public Versions(int userVersion, int orderVersion) {
            this.userVersion = userVersion;
            this.orderVersion = orderVersion;
        }

        void setUserVersion(int userVersion) {
            this.userVersion = userVersion;
        }

        void setOrderVersion(int orderVersion) {
            this.orderVersion = orderVersion;
        }

        public int getUserVersion() {
            return this.userVersion;
        }

        public int getOrderVersion() {
            return this.orderVersion;
        }
    }
}

