/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

public class LdapFormatHandler {
    private static HashMap<String, LdapFormatParser> FORMATER = new HashMap();
    private static final long WIN_EPOC_MS = 11644473600000L;
    private static final String DATE_DEUTSCH = "EE, d.MMM.yy H:mm";
    private static final String DATE_ENGLISH = "EE, MMM.d.yy H:mm";
    private static final SimpleDateFormat LDAP_DATE_PARSER = new SimpleDateFormat("yyyyMMddHHmmss");
    private static Format DATE_DISPLY_FORMATER;
    private static long MAX_TIME;
    private static final Logger logger;

    private LdapFormatHandler() {
        FORMATER.put("accountExpires", new LdapTimeStampFormatParser());
        FORMATER.put("badPasswordTime", new LdapTimeStampFormatParser());
        FORMATER.put("lastLogon", new LdapTimeStampFormatParser());
        FORMATER.put("lastLogonTimestamp", new LdapTimeStampFormatParser());
        FORMATER.put("lockoutTime", new LdapTimeStampFormatParser());
        FORMATER.put("pwdLastSet", new LdapTimeStampFormatParser());
        FORMATER.put("createTimeStamp", new LdapDateFormatParser());
        FORMATER.put("dsCorePropagationData", new LdapDateFormatParser());
        FORMATER.put("expirationTime", new LdapDateFormatParser());
        FORMATER.put("modifyTimeStamp", new LdapDateFormatParser());
        FORMATER.put("whenChanged", new LdapDateFormatParser());
        FORMATER.put("whenCreated", new LdapDateFormatParser());
    }

    public static String handleLdapFormat(String key, String value) {
        LdapFormatParser format = FORMATER.get(key);
        if (format != null) {
            Object result = format.parseLDAP(value);
            if (result instanceof Date) {
                return DATE_DISPLY_FORMATER.format(result);
            }
            if (result != null) {
                return result.toString();
            }
            return "";
        }
        return value;
    }

    static {
        LDAP_DATE_PARSER.setTimeZone(TimeZone.getTimeZone("GMT"));
        DATE_DISPLY_FORMATER = Locale.getDefault().getLanguage().equals("de") ? new SimpleDateFormat(DATE_DEUTSCH) : new SimpleDateFormat(DATE_ENGLISH);
        Calendar cal = Calendar.getInstance();
        cal.set(2100, 1, 1);
        MAX_TIME = cal.getTimeInMillis();
        new LdapFormatHandler();
        logger = LogManager.getLogger((String)"Data Import");
    }

    private class LdapDateFormatParser
    implements LdapFormatParser {
        private LdapDateFormatParser() {
        }

        @Override
        public Object parseLDAP(String ldapDate) {
            try {
                return LDAP_DATE_PARSER.parse(ldapDate);
            }
            catch (ParseException e) {
                logger.error((Object)e);
                return null;
            }
        }
    }

    private class LdapTimeStampFormatParser
    implements LdapFormatParser {
        private LdapTimeStampFormatParser() {
        }

        @Override
        public Object parseLDAP(String ldapTimestamp) {
            long value = Long.parseLong(ldapTimestamp);
            if (value <= 0L) {
                return null;
            }
            if ((value = value / 10000L - 11644473600000L) > MAX_TIME) {
                return null;
            }
            return new Date(value);
        }
    }

    private static interface LdapFormatParser {
        public Object parseLDAP(String var1);
    }
}

