/*
 * Decompiled with CFR 0.152.
 */
package srv.automatic;

public class CIHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    Entry posEntry;
    int posCounter;

    private CIHashMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
        this.count = 0;
    }

    public CIHashMap() {
        this(256, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public void remove(String key) {
        Entry[] tab = this.table;
        if (key != null) {
            Entry prev;
            int hash = this.getKeyHashCode(key);
            int index = CIHashMap.indexFor(hash, tab.length);
            Entry e = prev = this.table[index];
            while (e != null) {
                Entry next = e.next;
                if (key == e.key) {
                    --this.count;
                    if (prev == e) {
                        this.table[index] = next;
                    } else {
                        prev.next = next;
                    }
                    return;
                }
                prev = e;
                e = next;
            }
        }
    }

    public int[] get(String key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = this.getKeyHashCode(key);
            int index = CIHashMap.indexFor(hash, tab.length);
            Entry e = tab[index];
            while (e != null) {
                if (e.hash == hash && this.keyEquals(key, e.key)) {
                    return e.values;
                }
                e = e.next;
            }
        } else {
            Entry e = tab[0];
            while (e != null) {
                if (e.key == null) {
                    return e.values;
                }
                e = e.next;
            }
        }
        return null;
    }

    private boolean keyEquals(String key1, String key2) {
        if (key1.length() == key2.length()) {
            return key1.equals(key2);
        }
        return false;
    }

    private int getKeyHashCode(String key) {
        int h = key.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = CIHashMap.indexFor(e.hash, newCapacity);
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public void put(String key, int[] values) {
        int hash = this.getKeyHashCode(key);
        int index = CIHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && this.keyEquals(key, e.key)) {
                e.values = values;
                return;
            }
            e = e.next;
        }
        this.table[index] = new Entry(hash, key, values, this.table[index]);
        if (this.count++ >= this.threshold) {
            this.rehash();
        }
    }

    public void clear() {
        if (this.table.length > 1024) {
            int newCapacity = 1024;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            this.table = new Entry[newCapacity];
        } else {
            Entry[] tab = this.table;
            int index = tab.length;
            while (--index >= 0) {
                tab[index] = null;
            }
        }
        this.count = 0;
    }

    public boolean moveToFirstEntry() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            this.posEntry = tab[i];
            if (this.posEntry == null) continue;
            this.posCounter = i;
            return true;
        }
        return false;
    }

    public boolean nextEntry() {
        Entry[] tab = this.table;
        if (this.posEntry.next != null) {
            this.posEntry = this.posEntry.next;
        } else {
            this.posEntry = null;
            for (int i = this.posCounter + 1; i < tab.length; ++i) {
                this.posEntry = tab[i];
                if (this.posEntry == null) continue;
                this.posCounter = i;
                return true;
            }
        }
        return this.posEntry != null;
    }

    public String getEntryKey() {
        return this.posEntry.key;
    }

    public int[] getEntryValues() {
        return this.posEntry.values;
    }

    public int capacity() {
        return this.table.length;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    private static class Entry {
        int hash;
        String key;
        int[] values;
        Entry next;

        Entry(int hash, String key, int[] values, Entry next) {
            this.hash = hash;
            this.key = key;
            this.values = values;
            this.next = next;
        }
    }
}

