/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.core.HDLogger;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class WriteThreadDump {
    public WriteThreadDump() {
        this.dumpThread();
    }

    private OutputStream getOutputStream() {
        try {
            return new FileOutputStream("thread_dump.txt");
        }
        catch (FileNotFoundException e) {
            HDLogger.error(e);
            return System.err;
        }
    }

    private void dumpThread() {
        HDLogger.debug("Write ThreadDump");
        PrintWriter out = new PrintWriter(this.getOutputStream());
        Map<Thread, StackTraceElement[]> stackMap = Thread.getAllStackTraces();
        out.println("Begin of thread dump, time is " + DateFormat.getInstance().format(new Date()));
        out.println();
        if (stackMap != null) {
            for (Map.Entry<Thread, StackTraceElement[]> entry : stackMap.entrySet()) {
                Thread thread = entry.getKey();
                StackTraceElement[] stack = entry.getValue();
                if (thread != null) {
                    out.println("Thread: '" + thread.getName() + "', State is '" + thread.getState().toString() + "'");
                }
                if (stack != null) {
                    for (StackTraceElement elem : stack) {
                        out.println("\t" + elem);
                    }
                }
                out.println();
            }
        }
        out.println("End of thread dump");
        out.println("_______________________________________________________________");
        Properties props = System.getProperties();
        Enumeration<Object> enumera = props.keys();
        while (enumera.hasMoreElements()) {
            Object obj = enumera.nextElement();
            out.println(obj + ": " + props.getProperty(obj.toString()));
        }
        out.close();
    }
}

