/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.core.swing.AbstractResultSet;
import com.inet.helpdesk.core.swing.MyResultSetMetaData;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccountScope;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.annotation.SuppressFBWarnings;
import srv.ServerUtilities;
import srv.mail.AutoMailSender;

public class WorkflowResultSet
extends AbstractResultSet {
    static final String[] NAMES = new String[]{"Referenz1", "Referenz2", "Spaetestens", "ResID", "Status", "Betreff", "Auftrag", "html", "Kategorie", "PriID", "Kennung", "KlaID", "ItiID", "BunFeld1", "BunFeld2", "BunFeld3", "BunFeld4", "Deadline", "Sollzeit", "EmailEingang"};
    private static final int[] TYPS = new int[]{4, 4, 93, 4, 4, 12, 12, 4, 4, 4, 12, 4, 4, 12, 12, 12, 12, 93, 4, 4};
    private ArrayList<Object[]> steps;
    private int aufID;
    private int producer;
    private Number usrID;
    private Object[] values;
    private boolean autoLinking = false;
    private String wfName;
    private String displayName;
    private String producerAddress;
    private Timestamp zeitpunkt;
    private Connection con;
    private Statement stBun = null;
    private Statement stAuf = null;
    private Statement stRea = null;
    private Statement stWf = null;
    private Statement stLink = null;
    private ResultSet rsBun = null;
    private ResultSet rsAuf = null;
    private ResultSet rsRea = null;
    private ResultSet rsWf = null;
    private ResultSet rsLink = null;

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="SQL query is build with hard coded values. No user input available, therefore no SQL injection is possible.")
    public WorkflowResultSet(Connection con, Number usrID, int aufID, int linking, String wfName, String inputTyp, int producer, String displayName, String producerAddress) throws SQLException {
        this.wfName = wfName;
        this.usrID = usrID;
        this.aufID = aufID;
        this.con = con;
        this.displayName = displayName;
        this.producerAddress = producerAddress;
        this.producer = producer;
        this.zeitpunkt = new Timestamp(System.currentTimeMillis());
        this.steps = new ArrayList();
        this.stBun = con.createStatement(1005, 1008);
        this.rsBun = this.stBun.executeQuery("Select * From tblBuendel Where BunID = " + aufID);
        this.stAuf = con.createStatement(1005, 1008);
        this.rsAuf = this.stAuf.executeQuery("SELECT * FROM tblAuftraege WHERE AufID = " + aufID);
        this.rsBun.next();
        this.rsAuf.next();
        int status = this.rsBun.getInt("Status");
        Object wfid = this.rsAuf.getObject("WFID");
        if (status < 100 || status > 299 || this.rsAuf.getInt("Master") == 0 || wfid != null && ((Number)wfid).intValue() > 0) {
            try {
                this.rsBun.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.stBun.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.rsAuf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.stAuf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new SQLException("Execution of workflow failed(invalid data)!");
        }
        this.stRea = con.createStatement(1005, 1008);
        this.rsRea = this.stRea.executeQuery("SELECT * FROM tblRealisierung WHERE 1 = 0");
        this.stWf = con.createStatement(1005, 1008);
        this.rsWf = this.stWf.executeQuery("SELECT * FROM tblWFaktiv WHERE 1 = 0");
        boolean bl = this.autoLinking = linking > 0;
        if (this.autoLinking) {
            this.stLink = con.createStatement(1005, 1008);
            this.rsLink = this.stLink.executeQuery("SELECT * FROM tblFreeLinks WHERE 1 = 0");
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!columnName.equalsIgnoreCase(NAMES[i])) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.values[columnIndex] = x;
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.values[columnIndex] = x;
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.values[columnIndex] = x;
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.values[columnIndex] = x;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.values = new Object[NAMES.length + 1];
        this.steps.add(this.values);
    }

    private Object updateData(ResultSet rs, String columnName) throws SQLException {
        return this.updateData(rs, columnName, columnName);
    }

    private Object updateData(ResultSet rs, String aliasColumn, String dbColumnName) throws SQLException {
        Object obj = this.values[this.findColumn(aliasColumn)];
        rs.updateObject(dbColumnName, obj);
        return obj;
    }

    @Override
    public void insertRow() throws SQLException {
        Object[] formerStep;
        this.rsBun.moveToInsertRow();
        int ticketId = TicketManipulatorBackdoor.getBackdoor().getIDGenerator().generateNewTicketID();
        this.rsBun.updateInt("BunID", ticketId);
        int status = ((Number)this.updateData(this.rsBun, "Status")).intValue();
        this.updateData(this.rsBun, "BunFeld1");
        this.updateData(this.rsBun, "BunFeld2");
        this.updateData(this.rsBun, "BunFeld3");
        this.updateData(this.rsBun, "BunFeld4");
        this.updateData(this.rsBun, "Sollzeit");
        this.rsBun.updateString("Bearbeiter", this.displayName);
        this.rsBun.updateInt("LastEditorID", this.producer);
        this.rsBun.updateInt("Anlagen", 0);
        this.rsBun.insertRow();
        this.values[0] = new Integer(ticketId);
        int reaID = ServerUtilities.addRealisierung(this.con, this.rsRea, ticketId, ticketId, -8, this.zeitpunkt, this.producer, this.displayName, null, null, null, null, 0, null, 0, "\"" + this.wfName + "\" eingeleitet");
        this.rsAuf.moveToInsertRow();
        this.rsAuf.updateObject("UsrID", (Object)this.usrID);
        this.rsAuf.updateInt("BunID", ticketId);
        this.rsAuf.updateInt("AufID", ticketId);
        this.rsAuf.updateInt("WFID", this.aufID);
        this.rsAuf.updateInt("AnfReaID", reaID);
        this.updateData(this.rsAuf, "ResID");
        this.updateData(this.rsAuf, "KlaID");
        this.updateData(this.rsAuf, "PriID");
        this.updateData(this.rsAuf, "ItiID");
        this.updateData(this.rsAuf, "Auftrag");
        this.updateData(this.rsAuf, "html", "ishtml");
        this.updateData(this.rsAuf, "Kategorie", "BetID");
        this.updateData(this.rsAuf, "Betreff", "DerBetreff");
        this.updateData(this.rsAuf, "Kennung", "spezFeld");
        this.updateData(this.rsAuf, "Deadline", "DeadlineZeit");
        this.updateData(this.rsAuf, "EmailEingang");
        this.rsAuf.updateInt("Master", 1);
        if (status > 99) {
            int reaId = ServerUtilities.addRealisierung(this.con, this.rsRea, ticketId, ticketId, 5, this.zeitpunkt, this.producer, this.displayName, null, null, null, null, 0, null, 0, null);
            this.rsAuf.updateInt("AutorisierenReaID", reaId);
        }
        this.rsAuf.insertRow();
        this.rsWf.moveToInsertRow();
        this.rsWf.updateInt("HauptAuftrag", this.aufID);
        this.rsWf.updateInt("TeilAuftrag", ticketId);
        int ref = ((Number)this.values[1]).intValue();
        if (ref > 0) {
            formerStep = this.steps.get(ref - 1);
            this.rsWf.updateObject("Ende1", formerStep[0]);
        }
        if ((ref = ((Number)this.values[2]).intValue()) > 0) {
            formerStep = this.steps.get(ref - 1);
            this.rsWf.updateObject("Ende2", formerStep[0]);
        }
        this.updateData(this.rsWf, "Spaetestens");
        this.rsWf.updateString("WFName", this.wfName);
        this.rsWf.insertRow();
        if (this.autoLinking) {
            this.rsLink.moveToInsertRow();
            this.rsLink.updateInt("FromAufID", this.aufID);
            this.rsLink.updateInt("ToAufID", ticketId);
            this.rsLink.insertRow();
            this.rsLink.moveToInsertRow();
            this.rsLink.updateInt("FromAufID", ticketId);
            this.rsLink.updateInt("ToAufID", this.aufID);
            this.rsLink.insertRow();
        }
        try (UserAccountScope scope = UserAccountScope.create((GUID)HDUsersAndGroups.getUserAccount(this.producer).getID());){
            TicketManipulatorBackdoor.getBackdoor().notifyNewTicketCreatedUpdateSearchIndexAfterwardsAndSendEvent(ticketId);
        }
        if (status > 99) {
            AutoMailSender.sendIfNeeded(ticketId, 9, this.producerAddress);
            ServerUtilities.getOpenOrderController().notifyResourceIfNeeded(ticketId, 9, this.producer);
        }
    }

    @Override
    public void close() throws SQLException {
        String sql = "UPDATE tblAuftraege SET WFID = ?, WFStartDate = ? WHERE AufID = ?";
        try (UserAccountScope scope = UserAccountScope.create((GUID)HDUsersAndGroups.getUserAccount(this.producer).getID());
             PreparedStatement pstm = this.con.prepareStatement(sql);){
            TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(this.aufID, () -> {
                pstm.setInt(1, this.aufID);
                pstm.setTimestamp(2, this.zeitpunkt);
                pstm.setInt(3, this.aufID);
                pstm.executeUpdate();
                return null;
            });
        }
        try {
            this.rsBun.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.stBun.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.rsAuf.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.stAuf.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.rsRea.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.stRea.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.rsWf.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.stWf.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.autoLinking) {
            try {
                this.rsLink.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.stLink.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.values = null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new MyResultSetMetaData(TYPS, NAMES);
    }
}

