/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.core.swing.ListResultSet;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.jj.srv.JavaCommand;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import srv.ServerUtilities;
import srv.controller.ticket.Auftrag;

public class TicketStateCommand
extends JavaCommand {
    private static final int[] TYPEN_ANSWER = new int[]{4, 4, 4, 4, 4, 4};
    private static final String[] COLUMNS_ANSWER = new String[]{"Status", "ResID", "UsrID", "BgrID", "Occupied", "AutorisierenReaID"};
    private int ticketId;
    private Connection con;
    private PreparedStatement pst = null;
    private ResultSet rs = null;

    public TicketStateCommand(Connection con) {
        this.con = con;
    }

    public void setInt(int intIndex, int x) throws SQLException {
        if (intIndex != 1) {
            throw new SQLException("Invalid position " + x);
        }
        this.ticketId = x;
    }

    public ResultSet executeQuery() throws SQLException {
        ListResultSet theRS = new ListResultSet();
        ArrayList<Object[]> daten = new ArrayList<Object[]>();
        Auftrag auf = ServerUtilities.getOpenOrderController().getAuftrag(this.ticketId);
        Object[] result = new Object[COLUMNS_ANSWER.length];
        if (auf != null) {
            result[0] = auf.getStatus();
            result[1] = auf.getResource().getId();
            UserAccount aufUser = auf.getUser();
            result[2] = aufUser != null ? Integer.valueOf(HDUsersAndGroups.getUserID(aufUser)) : null;
            result[3] = aufUser != null ? aufUser.getValue((UserField)HDUsersAndGroups.FIELD_GROUP_ID) : null;
            result[4] = ServerUtilities.conti.getTicketAccessController().isOrderOpened(this.ticketId);
            result[5] = auf.getAutorisierenReaID();
        } else {
            this.pst = this.con.prepareStatement("SELECT tblBuendel.Status, tblAuftraege.ResID, tblAuftraege.UsrID, tblUser.BgrID, tblAuftraege.AutorisierenReaID FROM tblBuendel, tblAuftraege LEFT OUTER JOIN tblUser ON tblAuftraege.UsrID = tblUser.UsrID WHERE tblAuftraege.AufID = ? AND tblBuendel.BunID = tblAuftraege.BunID");
            this.pst.setInt(1, this.ticketId);
            this.rs = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> this.pst.executeQuery());
            if (this.rs.next()) {
                result[0] = this.rs.getObject("Status");
                result[1] = this.rs.getObject("ResID");
                result[2] = this.rs.getObject("UsrID");
                result[3] = this.rs.getObject("BgrID");
                result[4] = -1;
                result[5] = this.rs.getObject("AutorisierenReaID");
            } else {
                result = null;
            }
            this.close();
        }
        if (result != null) {
            daten.add(result);
        }
        theRS.setColumns(COLUMNS_ANSWER);
        theRS.setColumnTypes(TYPEN_ANSWER);
        theRS.setValues(daten);
        return theRS;
    }

    public boolean execute() throws SQLException {
        throw new SQLException("not supported");
    }

    public int executeUpdate() throws SQLException {
        throw new SQLException("not supported");
    }

    public void close() throws SQLException {
        if (this.rs != null) {
            try {
                this.rs.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.rs = null;
        }
        if (this.pst != null) {
            try {
                this.pst.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pst = null;
        }
    }
}

