/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.error.ErrorCode;
import com.inet.helpdesk.config.AppDataLocation;
import com.inet.helpdesk.config.DatabaseConfigInfo;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.EmailAccount;
import com.inet.helpdesk.config.EmailAccountList;
import com.inet.helpdesk.config.FreifeldSettingList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.config.TicketIdDefList;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.TicketAttachmentsDuplicatorExtension;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.HelpDeskServerException;
import com.inet.helpdesk.core.swing.ListResultSet;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.mail.reader.EmailReader_Main;
import com.inet.helpdesk.shared.model.Actions;
import com.inet.helpdesk.shared.util.SqlUtilities;
import com.inet.http.servlet.ClientLocale;
import com.inet.jj.srv.JJServer;
import com.inet.jj.srv.JavaCommandFactory;
import com.inet.lib.json.Json;
import com.inet.logging.Logger;
import com.inet.plugin.ServerPluginManager;
import java.io.FileInputStream;
import java.lang.reflect.Type;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;
import srv.HdLicenseObserver;
import srv.KonnektorPort;
import srv.MultiResultSet;
import srv.ServerInterface;
import srv.automatic.AutoProcess;
import srv.automatic.trigger.TriggerHandler;
import srv.controller.MetaController;
import srv.controller.OpenOrderController;
import srv.controller.ticket.Auftrag;
import srv.controller.ticket.timeline.ResourceTimelineManager;
import srv.jtapi.JTAPIinterface;
import srv.mail.Mail;
import srv.orderlistcache.OrderListCommandFactory;

public class ServerUtilities {
    public static final int DB_UNKNOWN = 0;
    public static final int SQL_SERVER_DB = 2;
    public static final int ORACLE_DB = 3;
    public static final int MYSQL_DB = 4;
    private static final int CLIENT_OPTION_AUTOLINKING_BEIM_SPLITEN = 65536;
    private static final int[] TYPEN_NAME_VALUE = new int[]{12, 12};
    private static final String[] COLUMNS_NAME_VALUE = new String[]{"Name", "Value"};
    private static final int[] EIN_STRING = new int[]{12};
    private static final String[] EIN_NAME = new String[]{"Name"};
    private static final int[] EIN_INTEGER = new int[]{4};
    private static final int[] TYPEN_DEADLINE = new int[]{93};
    private static final String[] COLUMNS_DEADLINE = new String[]{"newDeadLine"};
    private static final String EMPTY_STR = "";
    private static String currencyPattern = null;
    private static ArrayList<Object[]> imapData = null;
    private static final int[] TYPEN_IMAP = new int[]{4, 12, 12, 12, 12, 4};
    private static final String[] COLUMNS_IMAP = new String[]{"counter", "ImapAccount", "ImapKategorie", "ImapAlias", "ImapName", "Valid"};
    public static TriggerHandler TRIGGERS = new TriggerHandler();
    private static final int[] TYPEN_FILE = new int[]{-2};
    private static final String[] COLUMNS_FILE = new String[]{"Filename"};
    private static final ConfigValue<String> MAIL_HOST = new ConfigValue(HDConfigKeys.MAIL_HOST);
    private static final ConfigValue<TicketIdDefList> TICKET_ID_DEF_LIST = new ConfigValue(HDConfigKeys.TICKET_ID_DEF_LIST);
    private static final ConfigValue<Boolean> GERAETE_VERERBUNG = new ConfigValue(HDConfigKeys.GERAETE_VERERBUNG);
    private static final ConfigValue<Integer> CLIENT_START_OPTION = new ConfigValue(HDConfigKeys.CLIENT_START_OPTION);
    private static final ConfigValue<String> ADDITIONAL_DEVICE_COLUMN = new ConfigValue(HDConfigKeys.ADDITIONAL_DEVICE_COLUMN);
    private static final ConfigValue<String> SPERRLIST = new ConfigValue(HDConfigKeys.SPERRLIST);
    private static final ConfigValue<String> CLIENT_TREE_CONFIG = new ConfigValue(HDConfigKeys.CLIENT_TREE_CONFIG);
    private static final ConfigValue<String> MAIL_AUTORISIERUNG_RES = new ConfigValue(HDConfigKeys.MAIL_AUTORISIERUNG_RES);
    private static final ConfigValue<Boolean> MAIL_BEENDEN_USER = new ConfigValue(HDConfigKeys.MAIL_BEENDEN_USER);
    private static final ConfigValue<Boolean> MAIL_AUTORISIERUNG_USER = new ConfigValue(HDConfigKeys.MAIL_AUTORISIERUNG_USER);
    private static final ConfigValue<Integer> USER_ACCESS_FILTER = new ConfigValue(HDConfigKeys.USER_ACCESS_FILTER);
    private static final ConfigValue<Integer> ESCALATION_WARNING_ACTION = new ConfigValue(HDConfigKeys.ESCALATION_WARNING_ACTION);
    private static final ConfigValue<String> CLIENT_HOSTNAME = new ConfigValue(HDConfigKeys.CLIENT_HOSTNAME);
    private static final ConfigValue<String> CLIENT_CONFIG_FILE = new ConfigValue(HDConfigKeys.CLIENT_CONFIG_FILE);
    private static final ConfigValue<String> REQUEST_CONDITION_FILE = new ConfigValue(HDConfigKeys.REQUEST_CONDITION_FILE);
    private static final ConfigValue<String> MAIL_SENDER = new ConfigValue(ConfigKey.MAIL_SENDER);
    private static final ConfigValue<String> MAIL_SENDER_ORDER = new ConfigValue(HDConfigKeys.MAIL_SENDER_ORDER);
    private static final ConfigValue<FreifeldSettingList> FREIFELDER = new ConfigValue(HDConfigKeys.FREIFELDER);
    private static final ConfigValue<DatabaseConfigInfoList> DATABASE_CONFIG_INFO_LIST = new ConfigValue<DatabaseConfigInfoList>(HDConfigKeys.DB_CONFIGS){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            DatabaseConfigInfoList dbList = (DatabaseConfigInfoList)super.get();
            for (DatabaseConfigInfo db : dbList) {
                if (db.getDbName() == null) continue;
                ServerUtilities.addAsUserDataSource(db.getDbName());
            }
        }
    };
    private static final ConfigValue<Boolean> DRIVER_LOG = new ConfigValue<Boolean>(ConfigKey.LOG_DRIVER){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void setValue(String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            if (jjserver == null) return;
            Class<JJServer> clazz = JJServer.class;
            synchronized (JJServer.class) {
                jjserver.setLogLevel((Boolean)super.get() != false ? 3 : 1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    };
    public static final ConfigValue<Boolean> CLIENT_ENDUSER_SHOWBEARBEITER = new ConfigValue(HDConfigKeys.CLIENT_ENDUSER_SHOWBEARBEITER);
    private static final ConfigValue[] CONFIG_VALUES_TO_SEND_THE_CLIENT = new ConfigValue[]{ADDITIONAL_DEVICE_COLUMN, SPERRLIST, CLIENT_TREE_CONFIG, MAIL_AUTORISIERUNG_RES, MAIL_AUTORISIERUNG_USER, MAIL_BEENDEN_USER, USER_ACCESS_FILTER, ESCALATION_WARNING_ACTION, CLIENT_HOSTNAME, CLIENT_CONFIG_FILE, REQUEST_CONDITION_FILE, MAIL_SENDER};
    public static boolean linuxServer = false;
    public static int HD_db_Typ;
    public static final String HELPDESK_DB = "HDS";
    public static final String SMS_DB = "SMS";
    public static boolean isSMSavailable;
    public static boolean isImportZeit;
    public static final String sprache_Standard = "xx";
    private static int TIMER_COUNTER;
    public static final ConfigValue<Integer> GUI_PORT;
    private static JJServer jjserver;
    static long jjserverStart;
    public static MetaController conti;
    private static OpenOrderController testConti;
    public static JTAPIinterface jtapiObs;
    public static SqlUtilities sqlUtilities;
    public static ServerInterface serverInterface;
    static AutoProcess autoProc;
    static boolean smsDB_Connect;
    private static long serverTimeDiff;
    private static String fileSeperator;
    public static Locale serverLocale;
    public static ListResourceBundle hdsLangRess;
    public static final Integer NULL_AS_USER_ID;
    private static final List<String> COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT;

    public static String getLangMsg(String msgID, Object ... msgParameter) {
        return ServerUtilities.getLangMsgBundle(msgID, hdsLangRess, msgParameter);
    }

    public static String getLangMsgBundle(String msgID, ResourceBundle resBun, Object ... msgParameter) {
        String msg = msgID;
        try {
            msg = resBun.getString(msg);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        msg = MessageFormat.format(msg, msgParameter);
        return msg;
    }

    public static int getCurrentRelease() {
        return 252;
    }

    @Nonnull
    public static JJServer initJJServer(int portNR) {
        String test = System.getProperty("os.name", EMPTY_STR).toLowerCase();
        linuxServer = test.indexOf("linux") > -1;
        JJServer jjs = new JJServer(portNR, LoaderUtils.getUpdateableClassLoader());
        jjs.setEnableQueryStatistics(true);
        jjs.setOnlyCommandMode(true);
        return jjs;
    }

    public static void changeLogStream(boolean on) {
        if (on) {
            ServerUtilities.getJJServer().setLogLevel(3);
        } else {
            ServerUtilities.getJJServer().setLogLevel(1);
        }
    }

    public static void addAsUserDataSource(String dbName) {
        if (DATABASE_CONFIG_INFO_LIST == null) {
            return;
        }
        DatabaseConfigInfoList list = (DatabaseConfigInfoList)DATABASE_CONFIG_INFO_LIST.get();
        DatabaseConfigInfo configInfo = list.get(dbName);
        Object url = configInfo.getUrl();
        if (url != null && ((String)url).length() > 10) {
            if (((String)url).startsWith("jdbc:inetdae7:") && !((String)url).contains("lastUpdateCount")) {
                url = (String)url + "&lastUpdateCount=true";
            }
            String user = configInfo.getUser();
            String pw = configInfo.getDecodedPassword();
            String driverClassName = configInfo.getDriverClassName();
            ServerUtilities.addUserDataSourceToJJServer((String)url, pw, user, driverClassName, dbName);
            if (SMS_DB.equals(dbName)) {
                isSMSavailable = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String testDB(String theUrl, String pwd, String theUser, String driverClassName, String name, boolean logOnErrorLevel) {
        String threadID = Thread.currentThread().getName() + Thread.currentThread().getId();
        Connection dbCon = null;
        Statement st = null;
        ResultSet rs = null;
        boolean isOracle = driverClassName.equals("com.inet.ora.OraDriver");
        try {
            ServerUtilities.addUserDataSourceToJJServer(theUrl, pwd, theUser, driverClassName, threadID);
            int origTimeout = DriverManager.getLoginTimeout();
            DriverManager.setLoginTimeout(10);
            try {
                dbCon = ServerUtilities.getJJServer().getConnection(threadID);
                if (HELPDESK_DB.equals(name)) {
                    int shouldBeRelease;
                    st = dbCon.createStatement();
                    rs = st.executeQuery("SELECT * FROM tblOptionen");
                    boolean hadNext = rs.next();
                    int release = hadNext ? rs.getInt("Release") : -1;
                    if (release != (shouldBeRelease = 252)) {
                        String string = hdsLangRess.getString("FalscheDB");
                        return string;
                    }
                } else {
                    DatabaseMetaData dbMeta = dbCon.getMetaData();
                    HDLogger.info(dbMeta.getDatabaseProductName() + " " + dbMeta.getDriverName());
                }
            }
            finally {
                DriverManager.setLoginTimeout(origTimeout);
            }
            String dbMeta = null;
            return dbMeta;
        }
        catch (Throwable er) {
            Object msg = er.getMessage();
            Locale locale = ClientLocale.getThreadLocale();
            if (er.getCause() instanceof UnknownHostException) {
                msg = ((ListResourceBundle)ListResourceBundle.getBundle("lang.HDSMsg", locale)).getString("UnknownHost");
            } else if (er instanceof SQLInvalidAuthorizationSpecException || er.getMessage() != null && er.getMessage().contains("Access denied for user")) {
                msg = ((ListResourceBundle)ListResourceBundle.getBundle("lang.HDSMsg", locale)).getString(isOracle ? "InvalidAuthorizationDb" : "InvalidAuthorization");
            } else if (msg != null && ((String)msg).contains("TLS10")) {
                msg = (String)msg + "\n" + ((ListResourceBundle)ListResourceBundle.getBundle("lang.HDSMsg", locale)).getString("DatabaseTLSUpdateNeeded");
            }
            if (msg == null || ((String)msg).length() == 0) {
                msg = er.toString();
            }
            HelpDeskServerException exception = new HelpDeskServerException(er, (ErrorCode)HelpDeskErrorCodes.SQL_CONNECTION_TEST_ERROR);
            if (logOnErrorLevel) {
                HDLogger.error(exception);
            } else {
                HDLogger.debug(exception);
            }
            Object object = msg;
            return object;
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            try {
                st.close();
            }
            catch (Throwable throwable) {}
            try {
                dbCon.close();
            }
            catch (Throwable throwable) {}
            try {
                ServerUtilities.getJJServer().removeUDS(threadID);
            }
            catch (Throwable e) {
                HDLogger.error(e);
            }
        }
    }

    private static void addUserDataSourceToJJServer(String theUrl, String pwd, String theUser, String driverClassName, String udsId) {
        if (driverClassName != null) {
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (theUser == null) {
            theUser = EMPTY_STR;
        }
        if (pwd == null) {
            pwd = EMPTY_STR;
        }
        Properties info = ServerUtilities.generateConnectionProperties(theUser, pwd, driverClassName);
        Properties existingUds = ServerUtilities.getJJServer().getUDS(udsId);
        if (existingUds != null) {
            if (ServerUtilities.isSameUDS(existingUds, theUrl, pwd, theUser)) {
                return;
            }
            try {
                ServerUtilities.getJJServer().removeUDS(udsId);
            }
            catch (Throwable e) {
                HDLogger.error(e);
            }
        }
        ServerUtilities.getJJServer().addUDS(udsId, null, theUrl, info);
    }

    private static boolean isSameUDS(Properties existingUds, String theUrl, String pwd, String theUser) {
        boolean same = Objects.equals(theUrl, existingUds.getProperty("url"));
        same &= Objects.equals(pwd, existingUds.getProperty("password"));
        return same &= Objects.equals(theUser, existingUds.getProperty("user"));
    }

    private static Properties generateConnectionProperties(String user, String pw, String driverClassName) {
        Properties info = new Properties();
        info.put("user", user);
        info.put("password", pw);
        if ("com.mysql.cj.jdbc.Driver".equals(driverClassName)) {
            info.put("sessionVariables", "sql_mode = 'NO_BACKSLASH_ESCAPES'");
        }
        return info;
    }

    public static Locale getServerLocal() {
        return serverLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="constant SQL command is used")
    public static long getServerTimeDiff() {
        if (serverTimeDiff == -1L) {
            Connection con = null;
            Statement st = null;
            ResultSet rs = null;
            String command = (String)ServerUtilities.getJJServer().getCommand("OptionenUtil");
            if (command == null) {
                throw new IllegalStateException("Command 'OptionenUtil' noch nicht initialisiert");
            }
            try {
                con = ServerUtilities.getJJServer().getConnection(HELPDESK_DB);
                st = con.createStatement();
                rs = st.executeQuery(command);
                rs.next();
                serverTimeDiff = rs.getTimestamp("ServerTime").getTime() - System.currentTimeMillis();
            }
            catch (Throwable e) {
                HDLogger.error(e);
                serverTimeDiff = 0L;
                ServerUtilities.systemOut("CSDateDiff Exc ", e, EMPTY_STR);
            }
            finally {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
                try {
                    st.close();
                }
                catch (Throwable throwable) {}
                try {
                    con.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return serverTimeDiff;
    }

    static void resetServerTimeDiff() {
        serverTimeDiff = -1L;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance(TimeZone.getDefault());
    }

    public static void setDatabaseType(int dbType) {
        HD_db_Typ = dbType;
        sqlUtilities = new SqlUtilities(HD_db_Typ);
    }

    public static void systemOut(String sqlQueryID, Throwable e, String msg) {
        ServerUtilities.systemOut(sqlQueryID, e, msg, HDLogger.LOG);
    }

    public static void systemOut(String problem, Throwable e, String msg, Logger logger) {
        logger.info((Object)(problem + "\t" + Runtime.getRuntime().totalMemory() + "\t" + Runtime.getRuntime().freeMemory()));
        if (msg != null) {
            StringBuffer msgBuffer = new StringBuffer();
            msgBuffer.append("\t");
            msgBuffer.append(msg);
            msgBuffer.append("\n");
            logger.info((Object)msgBuffer.toString());
        }
        if (e != null) {
            logger.error((Object)e);
            while (e != null) {
                if (e instanceof SQLException) {
                    logger.warn((Object)("\tSQL State:" + ((SQLException)e).getSQLState() + "\tError Code:" + ((SQLException)e).getErrorCode()));
                    e = ((SQLException)e).getNextException();
                    continue;
                }
                e = null;
            }
        }
    }

    public static ResultSet getDeadline(String resID, String priID, Timestamp ts) throws Exception {
        ListResultSet theRS = new ListResultSet();
        theRS.setColumns(COLUMNS_DEADLINE);
        theRS.setColumnTypes(TYPEN_DEADLINE);
        Timestamp deadlineTS = ServerUtilities.calcDeadline(Integer.valueOf(resID), Integer.valueOf(priID), ts);
        return theRS.setSingleValue(deadlineTS, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="only int can be passed in")
    public static boolean resetDeadline(int aID) throws SQLException {
        boolean retval = true;
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = ServerUtilities.getJJServer().getConnection(HELPDESK_DB);
            st = con.createStatement();
            rs = st.executeQuery("SELECT ResID, PriID, DeadlineZeit FROM tblAuftraege WHERE AufID = " + aID);
            rs.next();
            if (rs.getTimestamp("DeadlineZeit") != null) {
                ServerUtilities.setDeadline(con, rs.getString("ResID"), String.valueOf(aID), String.valueOf(aID), rs.getString("PriID"), true);
            }
        }
        catch (Throwable er) {
            retval = false;
            HDLogger.error(er);
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            try {
                st.close();
            }
            catch (Throwable throwable) {}
            try {
                con.close();
            }
            catch (Throwable throwable) {}
        }
        return retval;
    }

    public static Timestamp calcDeadline(int resID, int priID, Timestamp ts) {
        ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
        Date deadlineTime = rtm.calcTargetTime(resID, priID, ts);
        return deadlineTime != null ? new Timestamp(deadlineTime.getTime()) : null;
    }

    public static void setDeadline(Connection con, String resID, String bunID, String aufID, String priID, boolean force) {
        Timestamp deadline = ServerUtilities.calcDeadline(Integer.valueOf(resID), Integer.valueOf(priID), new Timestamp(System.currentTimeMillis()));
        ServerUtilities.setDeadline(con, Integer.valueOf(bunID), Integer.valueOf(aufID), deadline, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="only int can be passed in")
    public static void setDeadline(Connection con, int bunID, int aufID, @Nullable Timestamp deadline, boolean force) {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement(1005, 1008);
            if (deadline != null) {
                rs = st.executeQuery("SELECT AufID, DeadLineZeit FROM tblAuftraege WHERE AufID = " + aufID);
                rs.next();
                if (force || rs.getObject("DeadLineZeit") == null) {
                    rs.updateObject("DeadLineZeit", (Object)deadline);
                    rs.updateRow();
                    st.execute("UPDATE tblBuendel SET DeadLine = 0 WHERE BunID = " + bunID);
                }
            } else if (force) {
                st.execute("UPDATE tblAuftraege SET DeadLineZeit = Null WHERE AufID = " + aufID);
            }
        }
        catch (SQLException sqlex) {
            ServerUtilities.systemOut("Protokoll", sqlex, "Konnte Deadline nicht setzen!");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
            }
            try {
                st.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static String getFileSeparator() {
        if (fileSeperator == null) {
            fileSeperator = System.getProperty("file.separator", "//");
        }
        return fileSeperator;
    }

    private static TicketAttachmentsDuplicatorExtension.AttachmentDuplicationResult duplicateAllAttachments(Connection connection, int originalTicketId, int originalStepId, int duplicateTicketId, int duplicateTicketStepId) {
        boolean atLeastOneAttDuplicated = false;
        boolean nonEmbeddedAttIncluded = false;
        ServerPluginManager spm = ServerPluginManager.getInstance();
        for (TicketAttachmentsDuplicatorExtension extension : spm.get(TicketAttachmentsDuplicatorExtension.class)) {
            TicketAttachmentsDuplicatorExtension.AttachmentDuplicationResult result = extension.duplicateAttachments(connection, originalTicketId, originalStepId, duplicateTicketId, duplicateTicketStepId);
            if (result.isAtLeastOneAttDuplicated()) {
                atLeastOneAttDuplicated = true;
            }
            if (!result.isNonEmbeddedAttIncluded()) continue;
            nonEmbeddedAttIncluded = true;
        }
        return new TicketAttachmentsDuplicatorExtension.AttachmentDuplicationResult(atLeastOneAttDuplicated, nonEmbeddedAttIncluded);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Internal API, Input can only be fixed files")
    public static ResultSet getFile(String fileName) throws Throwable {
        Path filePath = Paths.get(fileName, new String[0]);
        if (!filePath.isAbsolute()) {
            filePath = AppDataLocation.getBaseLocationPath().resolve(filePath);
        }
        ListResultSet theRS = new ListResultSet();
        FileInputStream fs = new FileInputStream(filePath.toFile());
        byte[] Inputtext = new byte[fs.available()];
        fs.read(Inputtext);
        fs.close();
        theRS.setColumns(COLUMNS_FILE);
        theRS.setColumnTypes(TYPEN_FILE);
        return theRS.setSingleValue(Inputtext, true);
    }

    private static ArrayList<Object[]> loadImapData() {
        int i;
        ArrayList<Object[]> daten = new ArrayList<Object[]>();
        EmailAccountList accounts = (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
        for (i = 0; i < accounts.size(); ++i) {
            EmailAccount account = (EmailAccount)accounts.get(i);
            Object[] datensatz = new Object[6];
            datensatz[1] = account.getFrom();
            try {
                Integer categoryId = account.getCategoryId();
                String categoryPath = CategoryManager.getInstance().findCategoryPathOrThrow(categoryId);
                datensatz[2] = categoryPath.toLowerCase();
            }
            catch (Exception exc) {
                HDLogger.error(exc);
                datensatz[2] = EMPTY_STR;
            }
            String name = account.getFromName();
            datensatz[3] = name != null && name.trim().length() > 0 ? name : account.getAccount();
            datensatz[4] = account.getAccount();
            String error = account.getErrorMessage();
            Object object = datensatz[5] = error == null || error.length() == 0 ? Integer.valueOf(0) : Integer.valueOf(1);
            if (account.getFrom() == null || !Mail.testEmailAddressString(account.getFrom())) continue;
            daten.add(datensatz);
        }
        Collections.sort(daten, new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return ((String)o1[3]).compareTo((String)o2[3]);
            }
        });
        for (i = 0; i < daten.size(); ++i) {
            daten.get((int)i)[0] = i;
        }
        return daten;
    }

    public static void realizeImapChange() {
        imapData = null;
        conti.setChanged(4, false);
    }

    public static ArrayList<Object[]> getMailData() {
        if (imapData == null) {
            imapData = ServerUtilities.loadImapData();
        }
        return imapData;
    }

    public static ResultSet getImapAccounts() throws Throwable {
        ListResultSet theRS = new ListResultSet();
        if (imapData == null) {
            imapData = ServerUtilities.loadImapData();
        }
        theRS.setColumns(COLUMNS_IMAP);
        theRS.setColumnTypes(TYPEN_IMAP);
        theRS.setValues(imapData);
        return theRS;
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="only int can be passed in")
    public static void calculateProcessingTime(Connection con, int id) {
        int summe = 0;
        try (Statement st = con.createStatement();
             ResultSet rs = st.executeQuery("SELECT StartZeit, EndZeit FROM tblRealisierung WHERE BunID = " + id);){
            while (rs.next()) {
                Timestamp start = rs.getTimestamp("StartZeit");
                Timestamp ende = rs.getTimestamp("EndZeit");
                if (start == null || ende == null) continue;
                summe = (int)((long)summe + (ende.getTime() - start.getTime()) / 60000L);
            }
            try (PreparedStatement pst = con.prepareStatement("UPDATE tblBuendel Set SummeZeit = ? WHERE BunID = " + id);){
                pst.setInt(1, summe);
                pst.execute();
            }
            Auftrag auf = testConti.getAuftrag(id);
            if (auf != null) {
                testConti.getResource(auf.getResource().getId()).realizeChanges(testConti);
            }
        }
        catch (Throwable ex) {
            HDLogger.error("Fehler bei calculate processing time: ");
            HDLogger.error(ex);
        }
    }

    public static int buildAuftrag(Connection con, int usrID, int resID, int priID, int klaID, int itiID, int ishtml, Integer kategorieId, String betreff, String auftrag, String spezFeld, String bunFeld1, String bunFeld2, String bunFeld3, String bunFeld4, Timestamp zeitpunkt, Integer creatorID, String displayName, String lastProcessor, String inTyp, int status) {
        return ServerUtilities.buildAuftrag(con, usrID, resID, priID, klaID, itiID, ishtml, kategorieId, betreff, auftrag, spezFeld, bunFeld1, bunFeld2, bunFeld3, bunFeld4, zeitpunkt, creatorID, displayName, lastProcessor, inTyp, status, -1, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="only int can be passed in")
    public static int buildAuftrag(Connection con, int usrID, int resID, int priID, int klaID, int itiID, int ishtml, Integer kategorieId, String betreff, String auftrag_argument, String spezFeld, String bunFeld1, String bunFeld2, String bunFeld3, String bunFeld4, Timestamp zeitpunkt, Integer creatorID, String displayName, String lastProcessor, String inTyp, int status, int sourceStep, Object deadline_argument, Object targettime) {
        try {
            int bunId;
            con.setAutoCommit(false);
            int n = bunId = DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                Object deadline = deadline_argument;
                if (deadline == null && resID > 0) {
                    ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
                    Date deadlineTime = rtm.calcDeadline(resID, priID);
                    deadline = deadlineTime != null ? new Timestamp(deadlineTime.getTime()) : null;
                }
                String auftrag = auftrag_argument;
                int id = TicketManipulatorBackdoor.getBackdoor().getIDGenerator().generateNewTicketID();
                Statement st = null;
                ResultSet rs = null;
                try {
                    TicketAttachmentsDuplicatorExtension.AttachmentDuplicationResult attDupResult22;
                    st = con.createStatement(1005, 1008);
                    rs = st.executeQuery("Select * From tblBuendel Where 1 = 0");
                    rs.moveToInsertRow();
                    rs.updateInt("BunID", id);
                    rs.updateInt("Status", status);
                    rs.updateString("Bearbeiter", lastProcessor);
                    if (creatorID != null && creatorID != -1) {
                        rs.updateInt("LastEditorID", (int)creatorID);
                    }
                    rs.updateString("BunFeld1", bunFeld1);
                    rs.updateString("BunFeld2", bunFeld2);
                    rs.updateString("BunFeld3", bunFeld3);
                    rs.updateString("BunFeld4", bunFeld4);
                    rs.updateObject("SollZeit", targettime);
                    rs.insertRow();
                    rs.last();
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    rs = st.executeQuery("SELECT * FROM tblRealisierung WHERE ReaID = " + sourceStep);
                    String description = null;
                    String bcc = null;
                    String cc = null;
                    String an = null;
                    String emailAddr = null;
                    int orgBundle = -1;
                    if (rs.next()) {
                        description = rs.getString("Description");
                        emailAddr = rs.getString("EmailIn");
                        an = rs.getString("EmailAn");
                        cc = rs.getString("EmailCC");
                        bcc = rs.getString("EmailBCC");
                        orgBundle = rs.getInt("OrgBunID");
                    }
                    String orgReference = null;
                    String newReference = null;
                    int reaID = ServerUtilities.addRealisierung(con, rs, id, id, 4, zeitpunkt, creatorID, displayName, emailAddr, an, cc, bcc, 0, null, 0, description);
                    if (orgBundle > -1 && (attDupResult22 = ServerUtilities.duplicateAllAttachments(con, orgBundle, sourceStep, id, reaID)).isAtLeastOneAttDuplicated()) {
                        if (attDupResult22.isNonEmbeddedAttIncluded()) {
                            try (Statement updateAttFlagStm = con.createStatement();){
                                updateAttFlagStm.executeUpdate("UPDATE tblBuendel SET Anlagen=1 WHERE BunID=" + id);
                            }
                        }
                        rs.updateInt("AttAufID", id);
                        rs.updateRow();
                        orgReference = " src=\"Attachments/ticket/" + orgBundle + "/" + sourceStep + "/";
                        newReference = " src=\"Attachments/ticket/" + id + "/" + reaID + "/";
                    }
                    if (status > 99) {
                        ServerUtilities.addRealisierung(con, rs, id, id, 5, zeitpunkt, creatorID, displayName, null, null, null, null, 0, null, 0, null);
                    }
                    try {
                        rs.close();
                    }
                    catch (Throwable attDupResult22) {
                        // empty catch block
                    }
                    rs = st.executeQuery("SELECT * FROM tblAuftraege WHERE 1 = 0");
                    rs.moveToInsertRow();
                    rs.updateInt("UsrID", usrID);
                    rs.updateInt("ResID", resID);
                    rs.updateInt("PriID", priID);
                    rs.updateInt("ItiID", itiID);
                    rs.updateInt("BunID", id);
                    rs.updateInt("AufID", id);
                    rs.updateInt("ishtml", ishtml);
                    rs.updateInt("KlaID", klaID);
                    rs.updateInt("Master", 1);
                    rs.updateInt("AnfReaID", reaID);
                    if (ishtml != 0 && orgReference != null) {
                        auftrag = auftrag.replace(orgReference, newReference);
                    }
                    rs.updateString("Auftrag", auftrag);
                    if (kategorieId != null) {
                        rs.updateInt("BetID", (int)kategorieId);
                    } else {
                        rs.updateNull("BetID");
                    }
                    rs.updateString("DerBetreff", betreff);
                    rs.updateString("spezFeld", spezFeld);
                    rs.updateObject("DeadlineZeit", deadline);
                    rs.updateString("EmailEingang", inTyp);
                    rs.insertRow();
                    try {
                        rs.close();
                    }
                    catch (Throwable attDupResult22) {
                        // empty catch block
                    }
                    int clientOptions = (Integer)CLIENT_START_OPTION.get();
                    if (orgBundle > -1 && (clientOptions & 0x10000) > 0) {
                        rs = st.executeQuery("SELECT * FROM tblFreeLinks WHERE 0 = 1");
                        rs.moveToInsertRow();
                        rs.updateInt("FromAufID", id);
                        rs.updateInt("ToAufID", orgBundle);
                        rs.insertRow();
                        rs.moveToInsertRow();
                        rs.updateInt("FromAufID", orgBundle);
                        rs.updateInt("ToAufID", id);
                        rs.insertRow();
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    con.commit();
                    Integer n = id;
                    return n;
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        st.close();
                    }
                    catch (Throwable throwable) {}
                }
            }).intValue();
            return n;
        }
        catch (Exception ex) {
            try {
                con.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            HDLogger.debug("Neu: " + inTyp);
            if (ex instanceof SQLException) {
                HDLogger.error(new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR));
            } else {
                HDLogger.error(new HelpDeskServerException((Throwable)ex, (ErrorCode)HelpDeskErrorCodes.FATAL_ERROR));
            }
            int n = -1;
            return n;
        }
        finally {
            try {
                con.setAutoCommit(true);
            }
            catch (Throwable throwable) {}
        }
    }

    public static synchronized int addRealisierung(Connection con, ResultSet rs, int bID, int auf, int aktID, Timestamp zeitpunkt, @Nullable Integer userID, String theName2, String emailAddr, String an, String cc, String bcc, int attAufID, String was, int textTyp, String description) throws SQLException {
        return ServerUtilities.addRealisierung(con, rs, bID, auf, aktID, 0, zeitpunkt, zeitpunkt, null, userID, theName2, emailAddr, an, cc, bcc, attAufID, was, textTyp, description, null);
    }

    public static synchronized int addRealisierungAndUpdateTicketManagerCache(Connection con, ResultSet rs, int bID, int auf, int aktID, Timestamp zeitpunkt, @Nullable Integer userID, String theName2, String emailAddr, String an, String cc, String bcc, int attAufID, String was, int textTyp, String description) throws SQLException {
        return TicketManipulatorBackdoor.getBackdoor().updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(auf, () -> ServerUtilities.addRealisierung(con, rs, bID, auf, aktID, 0, zeitpunkt, zeitpunkt, null, userID, theName2, emailAddr, an, cc, bcc, attAufID, was, textTyp, description, null));
    }

    public static synchronized int addRealisierung(@Nullable Connection con, @Nullable ResultSet rs, int bID, int auf, int aktID, int resource, Timestamp zeitStart, Timestamp zeitEnde, Object stundensatz, @Nullable Integer userID, String theName2, String emailAddr, String an, String cc, String bcc, int attAufID, String was, int textTyp, String description, Object pauschale) throws SQLException {
        int reaID = TicketManipulatorBackdoor.getBackdoor().getIDGenerator().generateNewReaStepID();
        Statement st = null;
        if (userID != null && userID == -1) {
            userID = null;
        }
        try {
            TicketVO ticket;
            if (rs == null) {
                st = con.createStatement(1005, 1008);
                rs = st.executeQuery("SELECT * FROM tblRealisierung WHERE 1=0");
            }
            rs.moveToInsertRow();
            if (Actions.isMoveReaStepWithActionFromBundleSlaveToMaster(aktID)) {
                rs.updateInt("BunID", bID);
            } else {
                rs.updateInt("BunID", auf);
            }
            rs.updateInt("ReaID", reaID);
            rs.updateInt("OrgBunID", auf);
            rs.updateInt("AktID", aktID);
            rs.updateObject("StartZeit", (Object)zeitStart);
            rs.updateObject("EndZeit", (Object)zeitEnde);
            if (stundensatz != null) {
                rs.updateObject("Stundensatz", stundensatz);
            }
            if (pauschale != null) {
                rs.updateObject("Pauschale", pauschale);
            }
            if (description != null && ((String)description).length() > 250) {
                description = ((String)description).substring(0, 245) + "...";
            }
            rs.updateString("Description", (String)description);
            rs.updateString("was", was);
            rs.updateInt("ishtml", textTyp);
            if (userID == null) {
                rs.updateNull("UserID");
            } else {
                rs.updateInt("UserID", (int)userID);
            }
            ServerUtilities.updateLastChangedBy(auf, userID, con);
            rs.updateString("DisplayName", theName2);
            rs.updateString("EmailIn", emailAddr);
            rs.updateString("EmailAn", ServerUtilities.cutEmails(an));
            rs.updateString("EmailCC", ServerUtilities.cutEmails(cc));
            rs.updateString("EmailBCC", ServerUtilities.cutEmails(bcc));
            rs.updateInt("RessID", resource);
            if (attAufID > 0) {
                rs.updateInt("AttAufID", attAufID);
            }
            if (Actions.isVisibleForBundleEnduser(aktID) && (con != null && con.getAutoCommit() || rs != null && rs.getStatement().getConnection().getAutoCommit()) && (ticket = TicketManager.getReaderForSystem().getTicket(auf)) != null && ticket.isMasterInBundle()) {
                rs.updateBoolean("bundleVisible", true);
            }
            rs.insertRow();
            rs.last();
        }
        catch (SQLException sqlex) {
            HDLogger.error(new HelpDeskServerException((Throwable)sqlex, (ErrorCode)HelpDeskErrorCodes.SQL_EXECUTION_ERROR));
            throw sqlex;
        }
        finally {
            if (st != null) {
                try {
                    rs.close();
                }
                catch (Throwable throwable) {}
                try {
                    st.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return reaID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateLastChangedBy(Integer ticketId, Integer userID, Connection con) throws SQLException {
        boolean closeConnection = false;
        if (con == null) {
            con = ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).getConnection();
            closeConnection = true;
        }
        try (PreparedStatement stm = con.prepareStatement("Update tblBuendel SET LastChangedByID = ? WHERE BunID = ?");){
            if (userID == null) {
                stm.setNull(1, 4);
            } else {
                stm.setInt(1, userID);
            }
            stm.setInt(2, ticketId);
            stm.executeUpdate();
        }
        finally {
            if (closeConnection) {
                con.close();
            }
        }
    }

    public static String cutEmails(String in) {
        if (in != null && in.length() > 1020) {
            int last = in.lastIndexOf(59, 1023);
            if (last == -1) {
                last = 1023;
            }
            in = in.substring(0, last);
        }
        return in;
    }

    public static Properties getClientSettings() {
        if (currencyPattern == null) {
            double doub = 1223.33;
            ConfigValue[] format = NumberFormat.getCurrencyInstance();
            currencyPattern = Locale.getDefault().getLanguage() + Locale.getDefault().getCountry() + format.format(doub);
        }
        Properties props = new Properties();
        HdLicenseObserver.addLicenseData(props, null);
        props.setProperty(SMS_DB, isSMSavailable ? "true" : "false");
        props.setProperty("SMTP", MAIL_HOST.get() == null ? EMPTY_STR : (String)MAIL_HOST.get());
        TicketIdDefList defList = (TicketIdDefList)TICKET_ID_DEF_LIST.get();
        props.setProperty("TicketID", defList.size() == 0 ? "TicketID" : (String)defList.get(0));
        props.setProperty("Bestand", ((Boolean)GERAETE_VERERBUNG.get()).toString());
        props.setProperty("JTAPI", jtapiObs != null ? "true" : "false");
        props.setProperty("NEW_TICKET_TRIGGER", TriggerHandler.getTrigger(4) != null ? "true" : "false");
        props.setProperty("clientstartoption", ((Integer)CLIENT_START_OPTION.get()).toString());
        props.setProperty("CurrentVersion", "21.10.801");
        props.setProperty("LoopCount", String.valueOf(TIMER_COUNTER));
        if (!ServerUtilities.isDatabaseConnectionValid()) {
            props.setProperty("DBaccess", "notAvailable");
        }
        props.setProperty("EskalationWerte", MetaController.getEscalationStates());
        props.setProperty("DBtyp", String.valueOf(HD_db_Typ));
        props.setProperty("curPattern", currencyPattern);
        for (ConfigValue value : CONFIG_VALUES_TO_SEND_THE_CLIENT) {
            Object str = value.get();
            if (str == null || str.toString().length() <= 0) continue;
            props.setProperty(value.getConfigKey().getKey(), str.toString());
        }
        String order = (String)MAIL_SENDER_ORDER.get();
        int catIndex = order.indexOf("2");
        int mailboxIndex = order.indexOf("1");
        String prefixNumber = catIndex >= 0 && catIndex < mailboxIndex ? "1" : "2";
        String suffixAbsender = EMPTY_STR;
        if (mailboxIndex >= 0) {
            EmailAccountList mailAcc = (EmailAccountList)EmailReader_Main.MAIL_ACCOUNTS.get();
            if (mailAcc.size() > 0) {
                for (EmailAccount a : mailAcc) {
                    if (a.getFrom() == null) continue;
                    suffixAbsender = a.getFrom();
                    break;
                }
            }
        } else {
            String defaultSender = (String)ConfigKey.MAIL_SENDER.getCurrent();
            if (defaultSender != null && !defaultSender.isBlank()) {
                suffixAbsender = defaultSender;
            }
        }
        props.setProperty("ClientMail", prefixNumber + ";" + suffixAbsender);
        ((Collection)FREIFELDER.get()).stream().forEach(s -> props.setProperty(s.getFreifeld().name(), (s.getDatabase() == null ? EMPTY_STR : s.getDatabase()) + ";" + s.getQueryName() + ";" + s.getFreifeldType()));
        props.setProperty("license.licensee", HdLicenseObserver.getLicensee());
        props.setProperty("UserColumns", ServerUtilities.getOldstyleUserColumsFromConfigProperty());
        props.setProperty("ShowBearb", ((Boolean)CLIENT_ENDUSER_SHOWBEARBEITER.get()).toString());
        return props;
    }

    public static String getOldstyleUserColumsFromConfigProperty() {
        String json = ConfigurationManager.getInstance().getCurrent().get(HDConfigKeys.CLIENT_ENDUSER_VISIBLE_TICKET_FIELDS);
        List allowedColumns = (List)new Json().fromJson(json, List.class, new Type[]{String.class});
        String setting = allowedColumns.stream().map(key -> COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.indexOf(key)).filter(index -> index > -1).map(Objects::toString).collect(Collectors.joining(","));
        return setting;
    }

    public static void setLoopCount(int counter) {
        TIMER_COUNTER = counter;
    }

    public static ResultSet setAuthResultsetTyps(MultiResultSet mrs) {
        mrs.setColumns(COLUMNS_NAME_VALUE);
        mrs.setColumnTypes(TYPEN_NAME_VALUE);
        return mrs;
    }

    public static ResultSet getTerminalConnections(int id) {
        ListResultSet theRS = ServerUtilities.getSingleStringResultSet();
        return theRS.setSingleValue(jtapiObs.getCallInformation(id), true);
    }

    public static ListResultSet getSingleStringResultSet() {
        ListResultSet theRS = new ListResultSet();
        theRS.setColumns(EIN_NAME);
        theRS.setColumnTypes(EIN_STRING);
        return theRS;
    }

    public static ResultSet getTerminalCount(int id) {
        ListResultSet theRS = ServerUtilities.getSingleStringResultSet();
        theRS.setColumnTypes(EIN_INTEGER);
        if (jtapiObs != null) {
            return theRS.setSingleValue(new Integer(jtapiObs.getTerminalCount(id)), true);
        }
        return theRS.setSingleValue(new Integer(-1), true);
    }

    public static String getCutedString(String str, int maxSubjectLength) {
        if (str == null) {
            return EMPTY_STR;
        }
        if (str.length() > maxSubjectLength) {
            return str.substring(0, maxSubjectLength - 3) + "...";
        }
        return str;
    }

    @Deprecated
    public static boolean isDatabaseConnectionValid() {
        return ((ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class)).isHelpDeskDatabaseConnectionValid();
    }

    public static void printProperties() {
        HDLogger.debug("################################## System Properties ######################################");
        Properties props = System.getProperties();
        Enumeration<Object> enumera = props.keys();
        while (enumera.hasMoreElements()) {
            Object obj = enumera.nextElement();
            HDLogger.debug(obj + " " + props.getProperty(obj.toString()));
        }
        HDLogger.debug("####################################### END ##############################################");
    }

    public static OpenOrderController getOpenOrderController() {
        if (testConti == null) {
            OrderListCommandFactory inquiryCacheController = new OrderListCommandFactory("AdminEdit_IO", OpenOrderController.getListOfOpenOrdersQuery());
            ServerUtilities.getJJServer().addCommand("AdminEdit_IO", (JavaCommandFactory)inquiryCacheController);
            testConti = new OpenOrderController(inquiryCacheController);
        }
        return testConti;
    }

    public static void setOpenOrderController(OpenOrderController testConti) {
        ServerUtilities.testConti = testConti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static JJServer getJJServer() {
        if (jjserver != null) return jjserver;
        Class<JJServer> clazz = JJServer.class;
        synchronized (JJServer.class) {
            if (jjserver != null) return jjserver;
            int konnectorPort = KonnektorPort.get();
            HDLogger.info("Konnekter port: " + konnectorPort);
            jjserver = ServerUtilities.initJJServer(konnectorPort);
            jjserver.setLogStream(System.out);
            jjserver.setLogLevel((Boolean)DRIVER_LOG.get() != false ? 3 : 1);
            // ** MonitorExit[var0] (shouldn't be in output)
            return jjserver;
        }
    }

    static {
        isSMSavailable = false;
        isImportZeit = false;
        TIMER_COUNTER = 0;
        GUI_PORT = new ConfigValue<Integer>(ConfigKey.LISTENER_PORT){

            protected Integer convert(String strValue) throws IllegalArgumentException {
                try {
                    return Integer.valueOf(strValue);
                }
                catch (Exception e) {
                    return new Integer(8002);
                }
            }
        };
        conti = new MetaController();
        jtapiObs = null;
        sqlUtilities = new SqlUtilities(0);
        serverTimeDiff = -1L;
        fileSeperator = null;
        serverLocale = Locale.getDefault();
        hdsLangRess = (ListResourceBundle)ListResourceBundle.getBundle("lang.HDSMsg", serverLocale);
        NULL_AS_USER_ID = null;
        LoaderUtils.getUpdateableClassLoader();
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT = new ArrayList<String>();
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add("ticketid");
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_ATTACHMENTS.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_SUBJECT.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_STATUS_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_RESOURCE_GUID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_INQUIRY_DATE.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CATEGORY_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_PRIORITY_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CLASSIFICATION_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_ITIL_ID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_DEADLINE.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_IDENTIFIER.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_LAST_EDITOR_GUID.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_LAST_CHANGED.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CUSTOM_1.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CUSTOM_2.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CUSTOM_3.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CUSTOM_4.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CUSTOM_6.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_CUSTOM_7.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.ATTRIBUTE_SUM_TIME.getKey());
        COLUMNS_ALLOWED_FOR_ENDUSER_POSSIBLE_IN_SWING_CLIENT.add(Tickets.FIELD_TARGET_TIME.getKey());
    }
}

