/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.DatabaseConfigInfoList;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.usersandgroups.user.HelpDeskUserManager;
import com.inet.jj.srv.JJServer;
import com.inet.jj.srv.JavaCommandFactory;
import com.inet.search.command.SearchID;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import srv.ResultSetCommandFactory;
import srv.ServerInitializer;
import srv.ServerUtilities;
import srv.automatic.Timer;
import srv.jtapi.JTAPIinterface;

public class ServerInitializerFullHD
extends ServerInitializer {
    private static final ConfigValue<HashMap<String, String>> TRIGGER_FILES = new ConfigValue(HDConfigKeys.TRIGGER_FILES);
    private static final ConfigValue<DatabaseConfigInfoList> DB_LIST = new ConfigValue(HDConfigKeys.DB_CONFIGS);
    private static final ConfigValue<String> JTAPI_PEER = new ConfigValue(HDConfigKeys.JTAPI_PEER);
    private static final ConfigValue<String> JTAPI_PROVIDER = new ConfigValue(HDConfigKeys.JTAPI_PROVIDER);
    private Timer timer;

    protected ServerInitializerFullHD() {
    }

    public static void createFullInstance() {
        if (instance == null) {
            instance = new ServerInitializerFullHD();
        }
    }

    @Override
    public void interruptExecution() {
        if (this.timer != null) {
            this.timer.stopTimer();
        }
        super.interruptExecution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startAdditionalParts() {
        if (this.serverInterrupted) {
            return;
        }
        super.startAdditionalParts();
        this.startServerComponents();
        try {
            Class<JJServer> clazz = JJServer.class;
            synchronized (JJServer.class) {
                if (this.serverInterrupted) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ServerUtilities.getJJServer().start();
                ServerUtilities.jjserverStart = System.currentTimeMillis();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            HDLogger.error(e);
            ServerUtilities.systemOut("Fehler bei JJServer.start ", e, "");
            ServerUtilities.serverInterface.errorExit(616, "No Client Socket");
            return;
        }
        {
            if (this.serverInterrupted) {
                return;
            }
            ForkJoinPool.commonPool().execute(() -> HelpDeskUserManager.getRecoveryEnabledInstance().search("", new ArrayList(), new ArrayList(), 100, new SearchID((Object)this)));
            return;
        }
    }

    private void startServerComponents() {
        String jtapiPeer = ((String)JTAPI_PEER.get()).trim();
        if (jtapiPeer.length() > 0) {
            this.initJTAPI(jtapiPeer);
        }
        HDLogger.warn(ServerUtilities.hdsLangRess.getString("HDSgestartet"));
        try {
            ServerUtilities.TRIGGERS.readTriggers((Map)TRIGGER_FILES.get());
        }
        catch (Exception e) {
            ServerUtilities.systemOut("Initialisieren Trigger", e, "Trigger Initialisierung fehlgeschlagen");
        }
        this.timer = new Timer();
        try (Connection conSmS = ServerUtilities.getJJServer().getConnection("SMS");){
            if (conSmS.getMetaData() != null) {
                ServerUtilities.isSMSavailable = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void closeJTAPI() {
        if (ServerUtilities.jtapiObs != null) {
            try {
                HDLogger.debug("close JTAPI");
                ServerUtilities.jtapiObs.closeObservation();
                ServerUtilities.jtapiObs = null;
                System.gc();
            }
            catch (Throwable e) {
                HDLogger.error(e);
            }
        }
    }

    private void initJTAPI(String peer) {
        ServerInitializerFullHD.closeJTAPI();
        try {
            Class<?> cls = LoaderUtils.getUpdateableClassLoader().loadClass("com.inet.helpdesk.jtapi.JTAPIObserver");
            ServerUtilities.jtapiObs = (JTAPIinterface)cls.newInstance();
            ServerUtilities.jtapiObs.init(peer, (String)JTAPI_PROVIDER.get());
            ServerUtilities.getJJServer().addCommand("Jtapi_Connnection", (JavaCommandFactory)new ResultSetCommandFactory("Jtapi_Connnection"));
        }
        catch (Throwable e) {
            ServerUtilities.jtapiObs = null;
            HDLogger.error(e);
        }
    }
}

