/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.jj.srv.JavaCommand;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.annotation.SuppressFBWarnings;
import srv.NotifyOnExecuteSQLCommandResultSet;

public class NotifyOnExecuteSQLCommand
extends JavaCommand {
    private String commandName;
    private PreparedStatement stmt;
    private Runnable callback;

    public NotifyOnExecuteSQLCommand(String commandName, PreparedStatement stmt, Runnable callback) {
        this.commandName = commandName;
        this.stmt = stmt;
        this.callback = callback;
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.stmt.unwrap(iface);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public ResultSet executeQuery(String sql) throws SQLException {
        return new NotifyOnExecuteSQLCommandResultSet(this.stmt.executeQuery(sql), this.callback);
    }

    public ResultSet executeQuery() throws SQLException {
        return new NotifyOnExecuteSQLCommandResultSet(this.stmt.executeQuery(), this.callback);
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.stmt.isWrapperFor(iface);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public int executeUpdate(String sql) throws SQLException {
        try {
            int n = this.stmt.executeUpdate(sql);
            return n;
        }
        finally {
            this.callback.run();
        }
    }

    public int executeUpdate() throws SQLException {
        try {
            int n = this.stmt.executeUpdate();
            return n;
        }
        finally {
            this.callback.run();
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.stmt.setNull(parameterIndex, sqlType);
    }

    public void close() throws SQLException {
        this.stmt.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.stmt.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.stmt.setByte(parameterIndex, x);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.stmt.setMaxFieldSize(max);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.stmt.setShort(parameterIndex, x);
    }

    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.stmt.setInt(parameterIndex, x);
    }

    public void setMaxRows(int max) throws SQLException {
        this.stmt.setMaxRows(max);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.stmt.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.stmt.setFloat(parameterIndex, x);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stmt.setEscapeProcessing(enable);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.stmt.setDouble(parameterIndex, x);
    }

    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.stmt.setBigDecimal(parameterIndex, x);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.stmt.setQueryTimeout(seconds);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.stmt.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.stmt.setBytes(parameterIndex, x);
    }

    public void cancel() throws SQLException {
        this.stmt.cancel();
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.stmt.setDate(parameterIndex, x);
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.stmt.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.stmt.setTimestamp(parameterIndex, x);
    }

    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.stmt.setCursorName(name);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.stmt.setAsciiStream(parameterIndex, x, length);
    }

    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.stmt.setUnicodeStream(parameterIndex, x, length);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public boolean execute(String sql) throws SQLException {
        try {
            boolean bl = this.stmt.execute(sql);
            return bl;
        }
        finally {
            this.callback.run();
        }
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.stmt.setBinaryStream(parameterIndex, x, length);
    }

    public ResultSet getResultSet() throws SQLException {
        return new NotifyOnExecuteSQLCommandResultSet(this.stmt.getResultSet(), this.callback);
    }

    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    public void clearParameters() throws SQLException {
        this.stmt.clearParameters();
    }

    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.stmt.setObject(parameterIndex, x, targetSqlType);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.stmt.setObject(parameterIndex, x);
    }

    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.stmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    public boolean execute() throws SQLException {
        try {
            boolean bl = this.stmt.execute();
            return bl;
        }
        finally {
            this.callback.run();
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public void addBatch(String sql) throws SQLException {
        this.stmt.addBatch(sql);
    }

    public void addBatch() throws SQLException {
        this.stmt.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.stmt.executeBatch();
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.stmt.setRef(parameterIndex, x);
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.stmt.setBlob(parameterIndex, x);
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.stmt.setClob(parameterIndex, x);
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.stmt.setArray(parameterIndex, x);
    }

    public Connection getConnection() throws SQLException {
        return this.stmt.getConnection();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.stmt.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.stmt.setDate(parameterIndex, x, cal);
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.stmt.getMoreResults(current);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.stmt.setTime(parameterIndex, x, cal);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stmt.getGeneratedKeys();
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.stmt.setTimestamp(parameterIndex, x, cal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            int n = this.stmt.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            this.callback.run();
        }
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.stmt.setNull(parameterIndex, sqlType, typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            int n = this.stmt.executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            this.callback.run();
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.stmt.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.stmt.getParameterMetaData();
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.stmt.setRowId(parameterIndex, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            int n = this.stmt.executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            this.callback.run();
        }
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        this.stmt.setNString(parameterIndex, value);
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.stmt.setNCharacterStream(parameterIndex, value, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            boolean bl = this.stmt.execute(sql, autoGeneratedKeys);
            return bl;
        }
        finally {
            this.callback.run();
        }
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.stmt.setNClob(parameterIndex, value);
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.stmt.setClob(parameterIndex, reader, length);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.stmt.execute(sql, columnIndexes);
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.stmt.setBlob(parameterIndex, inputStream, length);
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.stmt.setNClob(parameterIndex, reader, length);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.stmt.execute(sql, columnNames);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.stmt.setSQLXML(parameterIndex, xmlObject);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.stmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }

    public boolean isClosed() throws SQLException {
        return this.stmt.isClosed();
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.stmt.setPoolable(poolable);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.stmt.setAsciiStream(parameterIndex, x, length);
    }

    public boolean isPoolable() throws SQLException {
        return this.stmt.isPoolable();
    }

    public void closeOnCompletion() throws SQLException {
        this.stmt.closeOnCompletion();
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.stmt.setBinaryStream(parameterIndex, x, length);
    }

    public boolean isCloseOnCompletion() throws SQLException {
        return this.stmt.isCloseOnCompletion();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public long getLargeUpdateCount() throws SQLException {
        return this.stmt.getLargeUpdateCount();
    }

    public void setLargeMaxRows(long max) throws SQLException {
        this.stmt.setLargeMaxRows(max);
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.stmt.setAsciiStream(parameterIndex, x);
    }

    public long getLargeMaxRows() throws SQLException {
        return this.stmt.getLargeMaxRows();
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.stmt.setBinaryStream(parameterIndex, x);
    }

    public long[] executeLargeBatch() throws SQLException {
        return this.stmt.executeLargeBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.stmt.setCharacterStream(parameterIndex, reader);
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.stmt.setNCharacterStream(parameterIndex, value);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.stmt.executeLargeUpdate(sql);
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.stmt.setClob(parameterIndex, reader);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stmt.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.stmt.setBlob(parameterIndex, inputStream);
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.stmt.setNClob(parameterIndex, reader);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.stmt.executeLargeUpdate(sql, columnIndexes);
    }

    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.stmt.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="just passed to the underlying command")
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.stmt.executeLargeUpdate(sql, columnNames);
    }

    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.stmt.setObject(parameterIndex, x, targetSqlType);
    }

    public long executeLargeUpdate() throws SQLException {
        return this.stmt.executeLargeUpdate();
    }
}

