/*
 * Decompiled with CFR 0.152.
 */
package srv;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.swing.ListResultSet;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.jj.srv.JavaCommand;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import srv.ServerUtilities;
import srv.automatic.trigger.Trigger;
import srv.automatic.trigger.TriggerHandler;
import srv.controller.ticket.Auftrag;

public class NewTicketModificationCommand
extends JavaCommand {
    private String[] columns;
    private ArrayList<String> columnNames = new ArrayList();
    private ArrayList<Object> columnValues = new ArrayList();
    private int[] typs;

    public void setObject(String paramName, Object value) throws SQLException {
        this.columnNames.add(paramName);
        this.columnValues.add(value);
    }

    public void setString(String paramName, String value) throws SQLException {
        this.setObject(paramName, value);
    }

    public void setInt(String paramName, int value) throws SQLException {
        this.setObject(paramName, value);
    }

    public void setMaxRows(int maxRs) {
    }

    public ResultSet executeQuery() throws SQLException {
        this.columns = new String[this.columnNames.size()];
        this.typs = new int[this.columnNames.size()];
        Object[] result = new Object[this.columnNames.size()];
        for (int i = 0; i < this.columnNames.size(); ++i) {
            this.columns[i] = this.columnNames.get(i);
            result[i] = this.columnValues.get(i);
            this.typs[i] = result[i] instanceof Number ? 4 : 12;
        }
        Trigger tr = TriggerHandler.getTrigger(4);
        if (tr != null) {
            int i;
            String[] codedNames = new String[this.columns.length];
            Hashtable<String, String> data = new Hashtable<String, String>();
            for (i = 0; i < this.columns.length; ++i) {
                codedNames[i] = this.columns[i].toLowerCase();
                Object value = result[i];
                if (value instanceof Number) {
                    int val = ((Number)value).intValue();
                    if ("resid".equals(codedNames[i])) {
                        codedNames[i] = "resbezeichnung";
                        value = val > 0 ? ServerUtilities.getOpenOrderController().getAttributName(Auftrag.Field.RESOURCE, val, true) : "";
                    } else if ("priid".equals(codedNames[i])) {
                        codedNames[i] = "pribezeichnung";
                        value = ServerUtilities.getOpenOrderController().getAttributName(Auftrag.Field.PRIORITAET, val, true);
                    } else if ("klaid".equals(codedNames[i])) {
                        codedNames[i] = "klassifizierung";
                        value = ServerUtilities.getOpenOrderController().getAttributName(Auftrag.Field.KLASSIFIZIERUNG, val, true);
                    } else if ("itiid".equals(codedNames[i])) {
                        codedNames[i] = "itilbezeichnung";
                        value = ServerUtilities.getOpenOrderController().getAttributName(Auftrag.Field.ITIL, val, true);
                    } else if ("gebid".equals(codedNames[i])) {
                        codedNames[i] = "gebbezeichnung";
                        value = ServerUtilities.getOpenOrderController().getAttributName(Auftrag.Field.ORT, val, true);
                    } else if ("bgrid".equals(codedNames[i])) {
                        codedNames[i] = "benutzergruppe";
                        value = ServerUtilities.getOpenOrderController().getAttributName(Auftrag.Field.BENUTZERGRUPPE, val, true);
                    } else if ("katid".equals(codedNames[i])) {
                        try {
                            value = CategoryManager.getInstance().findCategoryPathOrThrow(val);
                            codedNames[i] = "betreff";
                        }
                        catch (ServerDataException e) {
                            HDLogger.error(e);
                        }
                    }
                } else if ("spezfeld".equals(codedNames[i])) {
                    codedNames[i] = "kennung";
                }
                if (value == null) {
                    HDLogger.debug(codedNames[i] + " is null");
                    value = "";
                }
                data.put(codedNames[i], value.toString());
            }
            tr.checkData(data, true);
            for (i = 0; i < this.columns.length; ++i) {
                if (this.typs[i] == 4) {
                    String str = data.get(codedNames[i]);
                    if ("resbezeichnung".equals(codedNames[i])) {
                        int wert;
                        UserGroupInfo matchedResource = HDUsersAndGroups.getFirstActiveResourceMatchedByName(str);
                        if (matchedResource != null) {
                            result[i] = matchedResource.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
                        }
                        if ((str = data.get("resbezeichnungstart")) == null || (wert = ServerUtilities.getOpenOrderController().getMatchingResource(str.toLowerCase())) <= -1) continue;
                        result[i] = new Integer(wert);
                        continue;
                    }
                    if ("pribezeichnung".equals(codedNames[i])) {
                        int wert = ServerUtilities.getOpenOrderController().getKey(str.toLowerCase(), Auftrag.Field.PRIORITAET, true);
                        if (wert <= -1) continue;
                        result[i] = new Integer(wert);
                        continue;
                    }
                    if ("klassifizierung".equals(codedNames[i])) {
                        int wert = ServerUtilities.getOpenOrderController().getKey(str.toLowerCase(), Auftrag.Field.KLASSIFIZIERUNG, true);
                        if (wert <= -1) continue;
                        result[i] = new Integer(wert);
                        continue;
                    }
                    if ("itilbezeichnung".equals(codedNames[i])) {
                        int wert = ServerUtilities.getOpenOrderController().getKey(str.toLowerCase(), Auftrag.Field.ITIL, true);
                        if (wert <= -1) continue;
                        result[i] = new Integer(wert);
                        continue;
                    }
                    if (!"betreff".equals(codedNames[i])) continue;
                    int value = CategoryManager.getInstance().findOrCreateCategory(str);
                    result[i] = value;
                    this.columns[i] = "KatID";
                    continue;
                }
                result[i] = data.get(codedNames[i]);
            }
        }
        ListResultSet theRS = new ListResultSet();
        ArrayList<Object[]> daten = new ArrayList<Object[]>();
        daten.add(result);
        theRS.setColumns(this.columns);
        theRS.setColumnTypes(this.typs);
        theRS.setValues(daten);
        return theRS;
    }

    public boolean execute() throws SQLException {
        throw new SQLException("not supported");
    }

    public int executeUpdate() throws SQLException {
        throw new SQLException("not supported");
    }

    public void close() throws SQLException {
    }
}

