/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.util;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.core.ticketmanager.ui.model.FieldEditDefinition;
import com.inet.helpdesk.core.ticketmanager.ui.model.TicketFieldDefinition;
import com.inet.helpdesk.webapi.HelpDeskTicketWebAPIExtension;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIAttachmentsHelper;
import com.inet.http.servlet.SessionStore;
import com.inet.http.upload.AttachmentDescription;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.logging.LogManager;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@InternalApi
public class HelpDeskWebAPIHelper {
    public static final String REQUEST_REQUIRES_ENCODED_TICKET_ID = "com.inet.helpdesk.webapi.ticketid.required";

    public static boolean requestRequiresEncodedTicketId() {
        return SessionStore.getHttpServletRequest() != null && null != SessionStore.getHttpServletRequest().getAttribute(REQUEST_REQUIRES_ENCODED_TICKET_ID);
    }

    public static void setRequestRequiresEncodedTicketId() {
        if (SessionStore.getHttpServletRequest() != null) {
            SessionStore.getHttpServletRequest().setAttribute(REQUEST_REQUIRES_ENCODED_TICKET_ID, new Object());
        }
    }

    @Nullable
    public static Object getValidAPIObject(@Nullable Object value) {
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        if (value instanceof String || value instanceof Boolean || value instanceof Number) {
            return value;
        }
        if (value.getClass().getAnnotation(JsonData.class) != null) {
            return value;
        }
        LogManager.getApplicationLogger().debug((Object)("Object of type '" + value.getClass().toString() + "' is not a valid value for the HelpDesk Web API."));
        return null;
    }

    public static MutableTicketData createMutableTicketData(@Nonnull Map<String, String> fields) {
        MutableTicketData mutableTicketData = new MutableTicketData();
        List ticketFieldDefinition = ServerPluginManager.getInstance().get(TicketFieldDefinition.class);
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            Optional<FieldEditDefinition> field = ticketFieldDefinition.parallelStream().filter(f -> f.getKey().equals(entry.getKey())).map(f -> f.getEditDefinition()).filter(Objects::nonNull).findFirst();
            if (!field.isPresent()) {
                LogManager.getApplicationLogger().debug((Object)("The ticket field was not found or must not be edited for the key: " + entry.getKey()));
                continue;
            }
            field.get().updateTicketData(mutableTicketData, Collections.singletonMap(entry.getKey(), entry.getValue()));
        }
        return mutableTicketData;
    }

    public static ExtensionArguments createExtensionArguments(@Nonnull Map<String, String> arguments) {
        ExtensionArguments args = ExtensionArguments.create();
        List extensionArguments = ServerPluginManager.getInstance().get(ExtensionArguments.ExtArg.class);
        for (Map.Entry<String, String> entry : arguments.entrySet()) {
            Optional<ExtensionArguments.ExtArg> argument = extensionArguments.parallelStream().filter(e -> e.getKey().equals(entry.getKey())).findFirst();
            if (!argument.isPresent()) {
                LogManager.getApplicationLogger().debug((Object)("The ticket argument was not found or must not be edited for the key: " + entry.getKey()));
                continue;
            }
            try {
                ExtensionArguments.ExtArg extArg = argument.get();
                Class valueType = extArg.getValueType();
                Object value = HelpDeskWebAPIHelper.resolvePrimitiveType(valueType, entry.getValue());
                if (value == null) {
                    value = extArg.fromJson(entry.getValue());
                }
                args.put(extArg, value);
            }
            catch (JsonException | ClassCastException e2) {
                LogManager.getApplicationLogger().debug((Object)("The value can not be resolved for the key: " + entry.getKey()));
            }
        }
        return args;
    }

    public static void addAttachmentsToExtensionArguments(ExtensionArguments extensionArgs, HttpServletRequest request, List<AttachmentDescription> attachments) {
        if (ServerPluginManager.getInstance().isPluginLoaded("attachments")) {
            HelpDeskWebAPIAttachmentsHelper.addAttachmentsToExtensionArguments(extensionArgs, request, attachments);
        }
    }

    public static MutableReaStepData createMutableReaStepData(Map<String, String> fields) {
        MutableReaStepData reaStepData = new MutableReaStepData();
        List fieldsReaStep = ServerPluginManager.getInstance().get(ReaStepField.class);
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            Optional<ReaStepField> field = fieldsReaStep.parallelStream().filter(f -> f.getKey().equals(entry.getKey())).findFirst();
            if (!field.isPresent()) {
                LogManager.getApplicationLogger().debug((Object)("The ticket argument was not found or must not be edited for the key: " + entry.getKey()));
                continue;
            }
            try {
                Class valueType = field.get().getValueType();
                Object value = HelpDeskWebAPIHelper.resolvePrimitiveType(valueType, entry.getValue());
                if (value == null) {
                    value = new Json().fromJson(entry.getValue(), valueType);
                }
                field.get().validate(value);
                reaStepData.put(field.get(), value);
            }
            catch (JsonException | ClassCastException e) {
                LogManager.getApplicationLogger().debug((Object)("The value can not be resolved for the key: " + entry.getKey()));
            }
        }
        return reaStepData;
    }

    private static <T> T resolvePrimitiveType(Class<T> clazz, String value) {
        PropertyEditor editor;
        if ((clazz.isPrimitive() || clazz.isAssignableFrom(String.class)) && (editor = PropertyEditorManager.findEditor(clazz)) != null) {
            editor.setAsText(value);
            return (T)editor.getValue();
        }
        return null;
    }

    public static List<String> getRequestedFields(HttpServletRequest request, Consumer<List<String>> allowAllFieldsConsumer) {
        ArrayList<String> requestedFields = new ArrayList();
        String[] fields = request.getParameterValues("fields");
        if (fields != null) {
            if (fields.length == 1) {
                fields = fields[0].split(",");
            }
            requestedFields = Arrays.asList(fields);
            requestedFields.forEach(e -> e.trim());
        } else {
            UserManager userManager = UserManager.getInstance();
            UserAccount currentUserAccount = userManager.getCurrentUserAccount();
            if (currentUserAccount != null && !currentUserAccount.getID().equals((Object)UserManager.PRIVILEGED_ACCOUNT_ID)) {
                allowAllFieldsConsumer.accept(requestedFields);
            }
        }
        return requestedFields;
    }

    public static void checkTicketReadAccessOrThrow(Integer ticketId, HttpServletResponse response) {
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadTicket(ticketId)) {
            ResponseWriter.forbidden((HttpServletResponse)response);
            throw new AccessDeniedException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.accessDenied", new Object[0]));
        }
    }

    public static void checkTicketWriteAccessOrThrow(Integer ticketId, HttpServletResponse response) {
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanWriteTicket(ticketId)) {
            ResponseWriter.forbidden((HttpServletResponse)response);
            throw new AccessDeniedException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.accessDenied", new Object[0]));
        }
    }

    public static void checkReaStepReadAccessOrThrow(Integer reaStepId, HttpServletResponse response) {
        if (!TicketManager.getTicketPermissionChecker().checkCurrentUserCanReadReaStep(reaStepId)) {
            ResponseWriter.forbidden((HttpServletResponse)response);
            throw new AccessDeniedException(HelpDeskTicketWebAPIExtension.LANG.getMsg("webapi.ticket.step.accessDenied", new Object[0]));
        }
    }
}

