/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.ticket;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketview.GlobalSearchViewDefinition;
import com.inet.helpdesk.webapi.data.HelpDeskTicketSearchRequestData;
import com.inet.helpdesk.webapi.data.HelpDeskTicketSearchResponseData;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.webapi.api.ResponseWriter;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HelpDeskTicketSearchHandler
extends RequestHandler<Void, Set<Integer>> {
    public static final String REQUEST_HANDLER_NAME = "search";

    public HelpDeskTicketSearchHandler() {
        super(new String[]{REQUEST_HANDLER_NAME});
    }

    public String getHelpPageKey() {
        return "webapi.ticket.search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Integer> handle(HttpServletRequest request, HttpServletResponse response, Void input, boolean previewModeEnabled) throws IOException {
        Locale locale;
        String query = "";
        int start = 0;
        int limit = 100;
        Locale defaultLocale = locale = ClientLocale.getThreadLocale();
        try {
            HelpDeskTicketSearchRequestData requestData = (HelpDeskTicketSearchRequestData)this.jsonFromRequest(request, HelpDeskTicketSearchRequestData.class);
            query = requestData.getQuery();
            limit = requestData.getLimit();
            start = requestData.getStart();
            locale = requestData.getLocale();
        }
        catch (ClientMessageException requestData) {
            // empty catch block
        }
        IndexSearchEngine<Integer> engine = TicketManager.getReader().getSearchEngine();
        SearchCommand globalCommand = GlobalSearchViewDefinition.INSTANCE.createSearchCommand(UserManager.getInstance().getCurrentUserAccountID(), locale, engine);
        SearchCommand searchCommand = new TextSearchCommandBuilder(engine, query).build(locale);
        searchCommand.getSearchExpression().addAll(0, (Collection)globalCommand.getSearchExpression());
        Set search = engine.simpleSearch(searchCommand);
        try {
            ClientLocale.setThreadLocale((Locale)locale);
            List suggestedValues = engine.getSuggestedValues(query, null);
            boolean hasMore = search.size() > start + limit;
            Set<Integer> responseList = search.stream().skip(start).limit(limit).collect(Collectors.toSet());
            ResponseWriter.json((HttpServletResponse)response, (Object)HelpDeskTicketSearchResponseData.from(responseList, suggestedValues, hasMore));
            Set set = search;
            return set;
        }
        finally {
            ClientLocale.setThreadLocale((Locale)defaultLocale);
        }
    }
}

