/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.webapi.data.step;

import com.inet.annotations.JsonData;
import com.inet.editor.HtmlConverter;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepAttribute;
import com.inet.helpdesk.core.ticketmanager.model.reasteps.ReaStepField;
import com.inet.helpdesk.webapi.data.step.AttachmentResponseData;
import com.inet.helpdesk.webapi.data.step.TicketStepEntryResponseData;
import com.inet.helpdesk.webapi.util.HelpDeskWebAPIHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonData
public class TicketStepDetailedEntryResponseData
extends TicketStepEntryResponseData {
    private String text;
    private boolean htmlContent;
    private String actionDisplayName;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, Object> fields = new HashMap<String, Object>();

    protected TicketStepDetailedEntryResponseData() {
    }

    public TicketStepDetailedEntryResponseData(ReaStepVO reaStepVO) {
        super(reaStepVO);
        this.actionDisplayName = ((ActionVO)ActionManager.getInstance().get(reaStepVO.getActionID())).getDisplayValue();
    }

    public static TicketStepDetailedEntryResponseData from(ReaStepVO reaStepsForTicket, ReaStepTextVO reaStepText, boolean inlineImages, List<String> requestedFields, List<AttachmentResponseData> attachments) {
        Object value;
        TicketStepDetailedEntryResponseData data = new TicketStepDetailedEntryResponseData(reaStepsForTicket);
        if (reaStepText != null) {
            data.htmlContent = reaStepText.hasHtmlContent();
            data.text = reaStepText.getText();
            if (data.htmlContent && inlineImages) {
                try {
                    data.text = HtmlConverter.html2inlinedHtml((String)data.text, (boolean)true, (URL)new URL("attachment://"));
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        for (ReaStepAttribute<Object> reaStepAttribute : reaStepsForTicket.getIncludedAttributes()) {
            if (!requestedFields.contains(reaStepAttribute.getKey()) || (value = HelpDeskWebAPIHelper.getValidAPIObject(reaStepsForTicket.getAttribute(reaStepAttribute))) == null) continue;
            data.attributes.put(reaStepAttribute.getKey(), value);
        }
        for (ReaStepField reaStepField : reaStepsForTicket.getIncludedFields()) {
            if (!requestedFields.contains(reaStepField.getKey()) || (value = HelpDeskWebAPIHelper.getValidAPIObject(reaStepsForTicket.getValue(reaStepField))) == null) continue;
            data.fields.put(reaStepField.getKey(), value);
        }
        if (attachments.size() > 0) {
            data.fields.put("attachments", attachments);
        }
        return data;
    }
}

