/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.tokenizers.TextSearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserManager;

public class FieldLumpSum
extends UserField<Double> {
    public static final String KEY_ONE = "lumpsum1";
    public static final String KEY_TWO = "lumpsum2";
    public static final String KEY_THREE = "lumpsum3";

    public static FieldLumpSum createFirst() {
        return new FieldLumpSum(KEY_ONE, 50);
    }

    public static FieldLumpSum createSecond() {
        return new FieldLumpSum(KEY_TWO, 40);
    }

    public static FieldLumpSum createThird() {
        return new FieldLumpSum(KEY_THREE, 30);
    }

    private FieldLumpSum(String key, int priority) {
        super(FieldLumpSum.createSearchTag(key, priority), (Object)0.0);
    }

    private static SearchTag createSearchTag(final String key, int priority) {
        return new SearchTag(key, (SearchTokenizer)TextSearchTokenizer.DEFAULT, priority, key, true){

            public String getDisplayName() {
                UserField field = UserManager.getInstance().getField(key);
                return HDFieldDisplayNameProvider.getDisplayNameForCustomField(field);
            }
        };
    }

    public void validate(Double value) {
        super.validate((Object)value);
        BasicFieldValidation.throwIfNull((Object)value);
        BasicFieldValidation.throwIfNegative((double)value);
        BasicFieldValidation.throwIfExceedsLimit((double)value, (double)1000.0);
    }
}

