/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user.fields;

import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.id.GUID;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.CollectionSearchTokenizer;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.UserField;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class FieldAllowedActions
extends UserField<Set<Integer>> {
    public static final String KEY = "allowedactions";

    public FieldAllowedActions() {
        super(FieldAllowedActions.createSearchTag(), Collections.emptySet());
    }

    private static SearchTag createSearchTag() {
        return new SearchTag(KEY, SearchDataType.StringMap, false, (SearchTokenizer)new CollectionSearchTokenizer(), -10, KEY, true){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.getDisplayNameForField(FieldAllowedActions.KEY);
            }

            public Map<? extends Comparable<?>, String> getMapData() {
                return FieldAllowedActions.getAllowedActionsDisplayNameMap();
            }
        };
    }

    public Set<Integer> getValidOrDefaultValue(Set<Integer> value, GUID entryID) {
        if (value == null) {
            return Collections.emptySet();
        }
        if (!value.isEmpty()) {
            List validActionIDs = ActionManager.getInstance().getAll(true).stream().map(FieldVO::getId).collect(Collectors.toList());
            value.retainAll(validActionIDs);
        }
        return (Set)super.getValidOrDefaultValue(value, entryID);
    }

    public void validate(Set<Integer> value) {
        super.validate(value);
        BasicFieldValidation.throwIfNull(value);
    }

    public Set<Integer> copyValue(Set<Integer> value) {
        if (value == null) {
            return null;
        }
        return new HashSet<Integer>(value);
    }

    public static Map<String, String> getAllowedActionsDisplayNameMap() {
        List all = ActionManager.getInstance().getAll(true);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ActionVO actionVO : all) {
            map.put(String.valueOf(actionVO.getId()), actionVO.getDisplayValue());
        }
        return map;
    }
}

