/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.user;

import com.inet.helpdesk.core.data.ActionCreationNotificator;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchDataCacheChangeListener;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.api.user.search.UserSearchDataCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HelpDeskUserSearchDataCache
extends UserSearchDataCache {
    public HelpDeskUserSearchDataCache(UserPersistence persistence, List<UserField<Object>> userFields) {
        super(persistence, userFields);
        ActionCreationNotificator acn = (ActionCreationNotificator)ServerPluginManager.getInstance().getSingleInstance(ActionCreationNotificator.class);
        acn.registerListener(actionID -> {
            SearchDataCacheChangeListener[] listeners;
            HashMap oldData = new HashMap();
            HashMap<String, Set<Integer>> newData = new HashMap<String, Set<Integer>>();
            newData.put(HDUsersAndGroups.FIELD_ALLOWED_ACTIONS.getKey(), Collections.singleton(actionID));
            for (SearchDataCacheChangeListener listener : listeners = this.getListeners()) {
                listener.entryChanged((Object)UserManager.MASTER_ACCOUNT_ID, oldData, newData);
            }
        });
    }

    protected Map<String, Object> toMap(UserAccount userAccount, boolean hasAuthGroupNames) {
        if (UserManager.MASTER_ACCOUNT_ID.equals((Object)userAccount.getID())) {
            MutableUserData userData = new MutableUserData();
            for (UserField field : userAccount.getIncludedFields()) {
                userData.put(field, userAccount.getValue(field));
            }
            userData.put((UserField)HDUsersAndGroups.FIELD_ALLOWED_ACTIONS, ActionManager.getInstance().getAllValidIds());
            userAccount = UserAccount.create((GUID)userAccount.getID(), (UserAccountType)userAccount.getAccountType(), (long)userAccount.getLastModified(), (long)userAccount.getLastAccess(), (MutableUserData)userData, (List)userAccount.getLoginSettings(), (Set)userAccount.getPermissions(), (boolean)userAccount.isActive());
        }
        return super.toMap(userAccount, hasAuthGroupNames);
    }
}

