/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.user;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.ui.fields.SelectFieldValue;
import com.inet.usersandgroups.api.ui.fields.SelectOption;
import com.inet.usersandgroups.api.ui.fields.SelectOptionResult;
import com.inet.usersandgroups.api.ui.fields.user.SelectUserFieldDefinition;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.stream.Stream;

public class ValueProviderUserFieldDefinition
extends SelectUserFieldDefinition<String> {
    private final UserField<String> userField;
    private final ServerValuesConnector.ValueProvider valueProvider;
    private final int settingId;

    public ValueProviderUserFieldDefinition(String groupKey, UserField<String> userField, int prio, ServerValuesConnector.ValueProvider valueProvider, int settingId) {
        super(groupKey, userField.getKey(), prio);
        this.userField = userField;
        this.valueProvider = valueProvider;
        this.settingId = settingId;
    }

    public SelectOption getValue(UserAccount userAccount) {
        String value = null;
        if (userAccount != null) {
            value = (String)userAccount.getValue(this.userField);
        }
        if (value == null) {
            value = (String)this.userField.getDefaultValue();
        }
        return new SelectOption(value, value);
    }

    public SelectOptionResult getOptions(UserAccount userAccount, String searchTerm, int currentSize, int chunkSize) {
        ArrayList options = new ArrayList();
        try {
            boolean hasFilter = !StringFunctions.isEmpty((String)searchTerm);
            ArrayList<Entry> data = this.valueProvider.getData(userAccount, !hasFilter);
            if (data != null && !data.isEmpty()) {
                Stream<Object> stream = data.stream();
                if (hasFilter) {
                    String lowerSearchTerm = searchTerm.toLowerCase();
                    if (this.allowsCustomValue() && currentSize == 0) {
                        boolean anyMatch = stream.anyMatch(e -> e.getDisplayName().equalsIgnoreCase(lowerSearchTerm));
                        if (!anyMatch) {
                            Entry firstEntry = data.get(0);
                            data.add(0, new Entry(firstEntry.getTypeId(), -1, searchTerm, searchTerm));
                        }
                        stream = data.stream();
                    }
                    stream = stream.filter(e -> e.getDisplayName().toLowerCase().contains(lowerSearchTerm));
                }
                stream.skip(currentSize).limit(chunkSize).forEach(e -> {
                    String name = e.getDisplayName();
                    options.add(new SelectOption(name, name));
                });
            }
            return new SelectOptionResult(options.size(), options);
        }
        catch (ServerDataException ex) {
            ErrorCode.throwAny((Throwable)ex);
            return null;
        }
    }

    public String convertFromString(String value) {
        if (!StringFunctions.isEmpty((String)value)) {
            SelectOption option = (SelectOption)new Json().fromJson(value, SelectOption.class);
            return option.getValue();
        }
        return "";
    }

    public String getLabel() {
        return HDFieldDisplayNameProvider.getDisplayNameForCustomField(this.userField);
    }

    public boolean isAvailable(UserAccount userAccount) {
        if (HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount())) {
            return true;
        }
        return !HDUsersAndGroups.isFieldOptionSet(this.settingId, 32);
    }

    public SelectFieldValue getFieldValue(UserAccount userAccount) {
        SelectFieldValue result = super.getFieldValue(userAccount);
        if (!HDUsersAndGroups.isSupporter(UserManager.getInstance().getCurrentUserAccount()) && HDUsersAndGroups.isFieldOptionSet(this.settingId, 4)) {
            result.setEnabled(false);
        }
        return result;
    }

    public boolean allowsCustomValue() {
        return this.valueProvider.allowCustomValues();
    }

    public boolean allowsMultipleValues() {
        return this.valueProvider.allowMultipleValues();
    }
}

