/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.group;

import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.helpdesk.usersandgroups.ui.fields.values.TimeRangeFieldValue;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.GroupFieldDefinition;
import com.inet.usersandgroups.api.ui.fields.values.FieldValue;
import java.time.DayOfWeek;
import java.time.format.TextStyle;
import java.util.HashMap;

public class ResHourRangeGroupFieldDefinition
extends GroupFieldDefinition<ResourceFieldWorkingHours.HourRange> {
    private static final String FIELD_TYPE = "fieldtype_timerange";
    private final DayOfWeek dayOfWeek;

    public ResHourRangeGroupFieldDefinition(String groupKey, DayOfWeek dayOfWeek) {
        super(groupKey, "resourceworkinghours" + dayOfWeek.getValue(), FIELD_TYPE, dayOfWeek.getValue());
        this.dayOfWeek = dayOfWeek;
    }

    public FieldValue getFieldValue(UserGroupInfo groupInfo) {
        ResourceFieldWorkingHours.WorkingHours workingHours;
        ResourceFieldWorkingHours.HourRange hourRange = null;
        ResourceFieldWorkingHours.WorkingHours workingHours2 = workingHours = groupInfo == null ? ResourceFieldWorkingHours.DEFAULT_WORKING_HOURS : (ResourceFieldWorkingHours.WorkingHours)groupInfo.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS);
        if (workingHours != null) {
            hourRange = workingHours.getHourRange(this.dayOfWeek);
        }
        if (hourRange != null) {
            TimeRangeFieldValue timeRangeFieldValue = new TimeRangeFieldValue(hourRange);
            timeRangeFieldValue.setVisibleInPreview(true);
            return timeRangeFieldValue;
        }
        TimeRangeFieldValue timeRangeFieldValue = new TimeRangeFieldValue();
        timeRangeFieldValue.setVisibleInPreview(false);
        return timeRangeFieldValue;
    }

    public ResourceFieldWorkingHours.HourRange convertFromString(String value) {
        if (StringFunctions.isEmpty((String)value)) {
            return null;
        }
        return (ResourceFieldWorkingHours.HourRange)new Json().fromJson(value, ResourceFieldWorkingHours.HourRange.class);
    }

    public String getLabel() {
        return this.dayOfWeek.getDisplayName(TextStyle.FULL, ClientLocale.getThreadLocale());
    }

    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        MutableUserGroupData mutableData = userGroupUpdateData.getUserGroupData();
        ResourceFieldWorkingHours.WorkingHours workingHours = (ResourceFieldWorkingHours.WorkingHours)mutableData.get((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS);
        if (workingHours == null && userGroup != null) {
            workingHours = (ResourceFieldWorkingHours.WorkingHours)userGroup.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS);
        }
        HashMap<DayOfWeek, ResourceFieldWorkingHours.HourRange> updatedHourRanges = new HashMap<DayOfWeek, ResourceFieldWorkingHours.HourRange>();
        if (workingHours != null) {
            updatedHourRanges.putAll(workingHours.getHourRanges());
        }
        if (value != null) {
            ResourceFieldWorkingHours.HourRange range = (ResourceFieldWorkingHours.HourRange)value;
            if (range.getStart() == null && range.getEnd() == null) {
                updatedHourRanges.remove(this.dayOfWeek);
            } else {
                updatedHourRanges.put(this.dayOfWeek, range);
            }
        }
        mutableData.put((UserGroupField)HDUsersAndGroups.RES_FIELD_WORKING_HOURS, (Object)new ResourceFieldWorkingHours.WorkingHours(updatedHourRanges));
    }

    public void validate(Object value) throws ClientMessageException {
        HashMap<DayOfWeek, ResourceFieldWorkingHours.HourRange> hourRanges = new HashMap<DayOfWeek, ResourceFieldWorkingHours.HourRange>();
        if (value != null) {
            hourRanges.put(this.dayOfWeek, (ResourceFieldWorkingHours.HourRange)value);
        }
        try {
            HDUsersAndGroups.RES_FIELD_WORKING_HOURS.validate(new ResourceFieldWorkingHours.WorkingHours(hourRanges));
        }
        catch (Throwable t) {
            throw new ClientMessageException(t.getMessage());
        }
    }
}

