/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups.ui.fields.group;

import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.ClientMessageException;
import com.inet.id.GUID;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.groups.UserGroupTreeUtils;
import com.inet.usersandgroups.api.ui.fields.SelectOption;
import com.inet.usersandgroups.api.ui.fields.SelectOptionResult;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.SelectGroupFieldDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class OtherResourcesGroupFieldDefinition
extends SelectGroupFieldDefinition<String> {
    public OtherResourcesGroupFieldDefinition() {
        super("resource", "otherresources", 0);
    }

    public String getLabel() {
        return null;
    }

    public SelectOptionResult getOptions(UserGroupInfo groupInfo, String searchTerm, int currentSize, int chunkSize) {
        boolean addDeleteOnlyOption;
        Set allGroups = UserGroupManager.getRecoveryEnabledInstance().getAllGroups();
        List descendantGroups = UserGroupTreeUtils.findDescendantGroups((UserGroupInfo)groupInfo, (Set)allGroups).getDescendantGroups();
        int counter = 0;
        if (!StringFunctions.isEmpty((String)searchTerm)) {
            searchTerm = searchTerm.toLowerCase();
        }
        TreeMap sortedMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        allGroups.removeAll(descendantGroups);
        allGroups.removeIf(ugi -> groupInfo.getID().equals((Object)ugi.getID()));
        allGroups.forEach(g -> {
            if (g.getType() != HDUsersAndGroups.RESOURCE) {
                return;
            }
            GroupInfo gi = new GroupInfo((UserGroupInfo)g);
            sortedMap.put(gi.path, gi);
        });
        String deleteOnlyLabel = HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.groupFieldDefinition.resource.otherresources.donotmovetickets", new Object[0]);
        ArrayList<SelectOption> options = new ArrayList<SelectOption>();
        boolean bl = addDeleteOnlyOption = currentSize == 0;
        if (searchTerm.trim().length() > 0 && !deleteOnlyLabel.toLowerCase().startsWith(searchTerm.toLowerCase())) {
            addDeleteOnlyOption = false;
        }
        if (addDeleteOnlyOption) {
            options.add(new SelectOption("", deleteOnlyLabel));
        }
        ++counter;
        for (Map.Entry entry : sortedMap.entrySet()) {
            String groupDisplayName;
            GroupInfo group = (GroupInfo)entry.getValue();
            if (!StringFunctions.isEmpty((String)searchTerm) && !(groupDisplayName = group.displayName.toLowerCase()).contains(searchTerm)) continue;
            if (currentSize == 0 && counter == 1 && addDeleteOnlyOption) {
                options.add(new SelectOption(null, HDFieldDisplayNameProvider.MSG.getMsg("usersandgroupsmanager.groupFieldDefinition.resource.otherresources.moveticketsto", new Object[0])));
                ++counter;
            }
            if (counter >= currentSize && counter < currentSize + chunkSize) {
                options.add(new SelectOption(group.guid.toString(), group.displayName));
            }
            ++counter;
        }
        return new SelectOptionResult(counter, options);
    }

    public SelectOption getValue(UserGroupInfo groupInfo) {
        return null;
    }

    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
    }

    public String convertFromString(String value) {
        return null;
    }

    public void validate(Object value) throws ClientMessageException {
    }

    private class GroupInfo {
        private String displayName = "";
        private String path = "";
        private GUID guid;

        public GroupInfo(UserGroupInfo g) {
            this.getKeyPath(g);
            this.guid = g.getID();
        }

        private void getKeyPath(UserGroupInfo g) {
            UserGroupInfo parentGroup;
            if (this.displayName.length() > 0) {
                this.displayName = " \\ " + this.displayName;
            }
            this.displayName = g.getDisplayName() + this.displayName;
            if (this.path.length() > 0) {
                this.path = "\\" + this.path;
            }
            this.path = g.getDisplayName() + "\\" + g.getID().toString() + this.path;
            GUID parentID = g.getParentID();
            if (g.getID().equals((Object)parentID)) {
                return;
            }
            if (parentID != null && (parentGroup = UserGroupManager.getRecoveryEnabledInstance().getGroup(parentID)) != null) {
                this.getKeyPath(parentGroup);
            }
        }
    }
}

