/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.helpdesk.core.ticketmanager.fields.location.LocationManager;
import com.inet.helpdesk.core.ticketmanager.fields.location.LocationVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import java.util.List;
import javax.annotation.Nonnull;

public class UserModelConverter {
    public static String[] getEmailAddresses(@Nonnull UserAccount account) {
        String email = (String)account.getValue((UserField)UsersAndGroups.FIELD_EMAIL);
        if (email == null) {
            email = "";
        }
        return email.split(";");
    }

    public static User convertUserAccount(UserAccount account) {
        if (account == null) {
            return null;
        }
        User userInfo = new User();
        UserModelConverter.convertUserAccount(account, userInfo);
        return userInfo;
    }

    public static void convertUserAccount(@Nonnull UserAccount account, @Nonnull User userInfo) {
        Integer groupID;
        userInfo.addData(Field.USERDATA_USERID, HDUsersAndGroups.getUserID(account));
        List logins = account.getLoginSettings();
        userInfo.addData(Field.USERDATA_USERNAME, logins.size() > 0 ? ((LoginSettings)logins.get(0)).getLoginID() : account.getDisplayName());
        userInfo.addData(Field.USERDATA_FIRSTNAME, account.getValue((UserField)UsersAndGroups.FIELD_FIRSTNAME));
        userInfo.addData(Field.USERDATA_LASTNAME, account.getValue((UserField)UsersAndGroups.FIELD_LASTNAME));
        String[] allEmailAddresses = UserModelConverter.getEmailAddresses(account);
        if (allEmailAddresses.length > 0) {
            userInfo.addData(Field.USERDATA_EMAIL, allEmailAddresses);
        }
        userInfo.addData(Field.USERDATA_DISPLAYNAME, account.getDisplayName());
        userInfo.addData(Field.USERDATA_COMPUTERNAME, account.getValue((UserField)HDUsersAndGroups.FIELD_COMPUTER_NAME));
        userInfo.addData(Field.USERDATA_LANGUAGE, account.getValue((UserField)HDUsersAndGroups.FIELD_LANGUAGE));
        Integer locationID = (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
        if (locationID != null) {
            LocationVO location = (LocationVO)LocationManager.getInstance().get(locationID);
            String locationDisplayName = location != null ? location.getDisplayValue() : "";
            userInfo.addData(Field.USERDATA_LOCATION, locationID);
            userInfo.addData(Field.USERDATA_LOCATION_DISPLAYNAME, locationDisplayName);
        }
        if ((groupID = (Integer)account.getValue((UserField)HDUsersAndGroups.FIELD_GROUP_ID)) != null) {
            UserGroupVO group = (UserGroupVO)UserGroupVOManager.getInstance().get(groupID);
            String groupDisplayName = group != null ? group.getDisplayValue() : "";
            userInfo.addData(Field.USERDATA_GROUP, groupID);
            userInfo.addData(Field.USERDATA_GROUP_DISPLAYNAME, groupDisplayName);
        }
        userInfo.addData(Field.USERDATA_ROOM, account.getValue((UserField)HDUsersAndGroups.FIELD_ROOM));
        userInfo.addData(Field.USERDATA_TELEPHONE, account.getValue((UserField)HDUsersAndGroups.FIELD_TELEPHONE));
        userInfo.addData(Field.USERDATA_DEPARTMENT, account.getValue((UserField)HDUsersAndGroups.FIELD_DEPARTMENT));
        userInfo.addData(Field.USERDATA_COSTCENTRE, account.getValue((UserField)HDUsersAndGroups.FIELD_COST_CENTRE));
        userInfo.addData(Field.USERDATA_USERFIELD1, account.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_1));
        userInfo.addData(Field.USERDATA_USERFIELD2, account.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_2));
        userInfo.addData(Field.USERDATA_USERFIELD3, account.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_3));
        userInfo.addData(Field.USERDATA_USERFIELD4, account.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_4));
        userInfo.addData(Field.USERDATA_USERFIELD5, account.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_5));
        userInfo.addData(Field.USERDATA_USERFIELD6, account.getValue((UserField)HDUsersAndGroups.FIELD_CUSTOM_6));
        userInfo.addData(Field.USERDATA_LUMPSUM1, account.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_1));
        userInfo.addData(Field.USERDATA_LUMPSUM2, account.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_2));
        userInfo.addData(Field.USERDATA_LUMPSUM3, account.getValue((UserField)HDUsersAndGroups.FIELD_LUMP_SUM_3));
        userInfo.addData(Field.USERDATA_IMPORT_NAME, account.getValue((UserField)HDUsersAndGroups.FIELD_IMPORT_NAME));
        userInfo.addData(Field.USERDATA_LASTMODIFIED, account.getLastModified());
        userInfo.addData(Field.USERDATA_DELETED, !account.isActive());
    }
}

