/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.usersandgroups;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.model.general.ActionType;
import com.inet.helpdesk.core.model.general.FieldSetting;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.usersandgroups.HDFieldDisplayNameProvider;
import com.inet.helpdesk.usersandgroups.groups.IHelpDeskUserGroupManager;
import com.inet.helpdesk.usersandgroups.groups.fields.GroupFieldAllowedActions;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldEmail;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldEscalationResourceID;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldHourlyRate;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldID;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldNotificationSettings;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldParentID;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldSettings;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.helpdesk.usersandgroups.user.fields.FieldAllowedActions;
import com.inet.helpdesk.usersandgroups.user.fields.FieldClientDetails;
import com.inet.helpdesk.usersandgroups.user.fields.FieldComputerName;
import com.inet.helpdesk.usersandgroups.user.fields.FieldCostCentre;
import com.inet.helpdesk.usersandgroups.user.fields.FieldCustomUserField;
import com.inet.helpdesk.usersandgroups.user.fields.FieldDepartment;
import com.inet.helpdesk.usersandgroups.user.fields.FieldGroupID;
import com.inet.helpdesk.usersandgroups.user.fields.FieldImportName;
import com.inet.helpdesk.usersandgroups.user.fields.FieldLanguage;
import com.inet.helpdesk.usersandgroups.user.fields.FieldLocationID;
import com.inet.helpdesk.usersandgroups.user.fields.FieldLumpSum;
import com.inet.helpdesk.usersandgroups.user.fields.FieldRoom;
import com.inet.helpdesk.usersandgroups.user.fields.FieldTelephone;
import com.inet.helpdesk.usersandgroups.user.fields.FieldUserID;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.PermissionCheckScope;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.thread.SessionLocal;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.Field;
import com.inet.usersandgroups.api.FieldAndGroupTypeAssociation;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.GroupTypeDef;
import com.inet.usersandgroups.api.groups.MemberToTypeCardinality;
import com.inet.usersandgroups.api.groups.MembershipType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.PredefinedUserGroup;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HDUsersAndGroups {
    public static final FieldUserID FIELD_USER_ID = new FieldUserID();
    public static final FieldComputerName FIELD_COMPUTER_NAME = new FieldComputerName();
    public static final FieldCostCentre FIELD_COST_CENTRE = new FieldCostCentre();
    public static final FieldDepartment FIELD_DEPARTMENT = new FieldDepartment();
    public static final FieldImportName FIELD_IMPORT_NAME = new FieldImportName();
    public static final FieldLanguage FIELD_LANGUAGE = new FieldLanguage();
    public static final FieldRoom FIELD_ROOM = new FieldRoom();
    public static final FieldTelephone FIELD_TELEPHONE = new FieldTelephone();
    public static final FieldLumpSum FIELD_LUMP_SUM_1 = FieldLumpSum.createFirst();
    public static final FieldLumpSum FIELD_LUMP_SUM_2 = FieldLumpSum.createSecond();
    public static final FieldLumpSum FIELD_LUMP_SUM_3 = FieldLumpSum.createThird();
    public static final FieldCustomUserField FIELD_CUSTOM_1 = FieldCustomUserField.createFirst();
    public static final FieldCustomUserField FIELD_CUSTOM_2 = FieldCustomUserField.createSecond();
    public static final FieldCustomUserField FIELD_CUSTOM_3 = FieldCustomUserField.createThird();
    public static final FieldCustomUserField FIELD_CUSTOM_4 = FieldCustomUserField.createFourth();
    public static final FieldCustomUserField FIELD_CUSTOM_5 = FieldCustomUserField.createFifth();
    public static final FieldCustomUserField FIELD_CUSTOM_6 = FieldCustomUserField.createSixth();
    public static final FieldGroupID FIELD_GROUP_ID = new FieldGroupID();
    public static final FieldLocationID FIELD_LOCATION_ID = new FieldLocationID();
    public static final FieldClientDetails FIELD_CLIENT_DETAILS = new FieldClientDetails();
    public static final FieldAllowedActions FIELD_ALLOWED_ACTIONS = new FieldAllowedActions();
    public static final GroupType RESOURCE = GroupType.of((String)"resource");
    public static final MembershipType RESOURCE_MEMBERSHIPTYPE_READ = new MembershipType("read", () -> HDFieldDisplayNameProvider.MSG.getMsg("resource.membershipType.readOnly", new Object[0]));
    public static final MembershipType RESOURCE_MEMBERSHIPTYPE_WRITE = new MembershipType("write", () -> HDFieldDisplayNameProvider.MSG.getMsg("resource.membershipType.write", new Object[0]));
    public static final GroupTypeDef GROUPTYPEDEF_RESOURCE = HDUsersAndGroups.createResourceGroupTypeDef();
    public static final GroupType GROUPTYPE_SUPPORTERS = GroupType.of((String)"supporters");
    public static final GroupTypeDef GROUPTYPEDEF_SUPPORTERS = HDUsersAndGroups.createSupportersGroupTypeDef();
    public static final UserGroupKey GROUP_SUPPORTERS = UserGroupKey.of((String)"supporters", (GroupType)GROUPTYPE_SUPPORTERS);
    public static final GUID GROUPID_SUPPORTERS = GUID.valueOf((String)"sys09dlmeidonrthlu42m0jcc");
    public static final GroupType GROUPTYPE_ENDUSER = GroupType.of((String)"endusers");
    public static final GroupTypeDef GROUPTYPEDEF_ENDUSER = HDUsersAndGroups.createEndusersGroupTypeDef();
    public static final UserGroupKey GROUP_ENDUSER = UserGroupKey.of((String)"endusers", (GroupType)GROUPTYPE_ENDUSER);
    public static final GUID GROUPID_ENDUSER = GUID.valueOf((String)"sys10fee317ztmp0ztlgyy502");
    public static final ResourceFieldID RES_FIELD_ID = new ResourceFieldID();
    public static final ResourceFieldParentID RES_FIELD_PARENT_ID = new ResourceFieldParentID();
    public static final ResourceFieldEmail RES_FIELD_EMAIL = new ResourceFieldEmail();
    public static final ResourceFieldEscalationResourceID RES_FIELD_ESC_RES_ID = new ResourceFieldEscalationResourceID();
    public static final ResourceFieldHourlyRate RES_FIELD_HOURLY_RATE = new ResourceFieldHourlyRate();
    public static final ResourceFieldSettings RES_FIELD_SETTINGS = new ResourceFieldSettings();
    public static final ResourceFieldNotificationSettings RES_FIELD_NOTIF_SETTINGS = new ResourceFieldNotificationSettings();
    public static final ResourceFieldWorkingHours RES_FIELD_WORKING_HOURS = new ResourceFieldWorkingHours();
    public static final GroupFieldAllowedActions GROUP_FIELD_ALLOWED_ACTIONS = new GroupFieldAllowedActions();
    private static final int CHECK_RESOURCE_READ = 1;
    private static final int CHECK_RESOURCE_WRITE = 2;
    private static final int CHECK_RESOURCE_READ_OR_WRITE = 3;
    public static final Permission[] SUPPORTER_PERMISSIONS = new Permission[]{HdPermissions.DISPATCHER, HdPermissions.TICKET_RESOURCES_READ};
    private static SessionLocal<Map<Integer, FieldSetting>> localFieldSettings = new SessionLocal();

    private static GroupTypeDef createResourceGroupTypeDef() {
        HashSet<MembershipType> membershipTypes = new HashSet<MembershipType>();
        membershipTypes.add(RESOURCE_MEMBERSHIPTYPE_READ);
        membershipTypes.add(RESOURCE_MEMBERSHIPTYPE_WRITE);
        return new GroupTypeDef(500, RESOURCE, membershipTypes, MemberToTypeCardinality.One, new GroupTypeDef.GroupTypeRestrictions[0]){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.resources", new Object[0]);
            }

            public URL getIconURL(int size) {
                if (size <= 32) {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/resourcegroups_32.png");
                }
                return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/resourcegroups_96.png");
            }

            public String getDescription() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.resources.description", new Object[0]);
            }

            public String getCreateLabel() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.resources.createlabel", new Object[0]);
            }

            public boolean allowsNonUniqueNames() {
                return true;
            }

            public boolean inheritsMembershipsFromParent() {
                return true;
            }

            public int getMaxTreeLevel() {
                return 2;
            }
        };
    }

    private static GroupTypeDef createSupportersGroupTypeDef() {
        return new GroupTypeDef(40, GROUPTYPE_SUPPORTERS, new GroupTypeDef.GroupTypeRestrictions[]{GroupTypeDef.GroupTypeRestrictions.PreventCreation, GroupTypeDef.GroupTypeRestrictions.PreventDeactivation, GroupTypeDef.GroupTypeRestrictions.PreventRenaming, GroupTypeDef.GroupTypeRestrictions.PreventMembershipEditing, GroupTypeDef.GroupTypeRestrictions.PreventRemoval}){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.supporters", new Object[0]);
            }

            public String getDescription() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.supporters.description", new Object[0]);
            }

            public URL getIconURL(int size) {
                if (size <= 32) {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/supportergroup_32.png");
                }
                return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/supportergroup_96.png");
            }

            public boolean isSystemGroup() {
                return true;
            }
        };
    }

    private static GroupTypeDef createEndusersGroupTypeDef() {
        return new GroupTypeDef(40, GROUPTYPE_ENDUSER, new GroupTypeDef.GroupTypeRestrictions[]{GroupTypeDef.GroupTypeRestrictions.PreventCreation, GroupTypeDef.GroupTypeRestrictions.PreventDeactivation, GroupTypeDef.GroupTypeRestrictions.PreventRenaming, GroupTypeDef.GroupTypeRestrictions.PreventMembershipEditing, GroupTypeDef.GroupTypeRestrictions.PreventRemoval}){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.endusers", new Object[0]);
            }

            public String getDescription() {
                return HDFieldDisplayNameProvider.MSG.getMsg("grouptype.endusers.description", new Object[0]);
            }

            public URL getIconURL(int size) {
                if (size <= 32) {
                    return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/usergroups_32.png");
                }
                return ((Object)((Object)this)).getClass().getResource("/com/inet/helpdesk/usersandgroups/images/usergroups_96.png");
            }

            public boolean isSystemGroup() {
                return true;
            }
        };
    }

    public static Set<GroupTypeDef> getGroupTypeDefinitionsForRegistration() {
        HashSet<GroupTypeDef> defs = new HashSet<GroupTypeDef>();
        defs.add(GROUPTYPEDEF_RESOURCE);
        defs.add(GROUPTYPEDEF_SUPPORTERS);
        defs.add(GROUPTYPEDEF_ENDUSER);
        return defs;
    }

    public static Set<PredefinedUserGroup> getPredefinedUserGroupsForRegistration() {
        HashSet<PredefinedUserGroup> groups = new HashSet<PredefinedUserGroup>();
        groups.add(new PredefinedUserGroup(GROUP_SUPPORTERS, GROUPID_SUPPORTERS, new MutableUserGroupData()){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("group.supporter", new Object[0]);
            }
        });
        groups.add(new PredefinedUserGroup(GROUP_ENDUSER, GROUPID_ENDUSER, new MutableUserGroupData()){

            public String getDisplayName() {
                return HDFieldDisplayNameProvider.MSG.getMsg("group.endusers", new Object[0]);
            }
        });
        return groups;
    }

    @Nonnull
    public static List<UserField<?>> getUserFieldsForRegistration() {
        ArrayList result = new ArrayList(HDUsersAndGroups.getFieldsWithValuesInTblUser());
        result.add(FIELD_CLIENT_DETAILS);
        result.add(FIELD_ALLOWED_ACTIONS);
        return result;
    }

    @Nonnull
    public static List<UserGroupField<?>> getGroupFieldsForRegistration() {
        ArrayList result = new ArrayList(HDUsersAndGroups.getResourceGroupFieldsWithValuesInTblRessourcen());
        result.add(GROUP_FIELD_ALLOWED_ACTIONS);
        return result;
    }

    public static List<UserGroupField<?>> getResourceGroupFieldsWithValuesInTblRessourcen() {
        return Arrays.asList(new UserGroupField[]{RES_FIELD_ID, RES_FIELD_PARENT_ID, RES_FIELD_EMAIL, RES_FIELD_ESC_RES_ID, RES_FIELD_HOURLY_RATE, RES_FIELD_SETTINGS, RES_FIELD_NOTIF_SETTINGS, RES_FIELD_WORKING_HOURS});
    }

    public static List<FieldAndGroupTypeAssociation> getFieldAndGroupTypeAssociationsForRegistration() {
        Set fieldKeys = HDUsersAndGroups.getGroupFieldsForRegistration().stream().map(Field::getKey).collect(Collectors.toSet());
        FieldAndGroupTypeAssociation resourceFieldBundle = new FieldAndGroupTypeAssociation(RESOURCE, fieldKeys);
        FieldAndGroupTypeAssociation standardFieldBundle = new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_STANDARD, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        FieldAndGroupTypeAssociation allUsersFieldBundle = new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_ALLUSERS, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        FieldAndGroupTypeAssociation authFieldBundle = new FieldAndGroupTypeAssociation(UsersAndGroups.GROUPTYPE_AUTH, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        FieldAndGroupTypeAssociation supportersFieldBundle = new FieldAndGroupTypeAssociation(GROUPTYPE_SUPPORTERS, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        FieldAndGroupTypeAssociation endusersFieldBundle = new FieldAndGroupTypeAssociation(GROUPTYPE_ENDUSER, new String[]{GROUP_FIELD_ALLOWED_ACTIONS.getKey()});
        ArrayList<FieldAndGroupTypeAssociation> bundles = new ArrayList<FieldAndGroupTypeAssociation>();
        bundles.add(resourceFieldBundle);
        bundles.add(standardFieldBundle);
        bundles.add(allUsersFieldBundle);
        bundles.add(authFieldBundle);
        bundles.add(supportersFieldBundle);
        bundles.add(endusersFieldBundle);
        return bundles;
    }

    @Nonnull
    public static List<UserField<?>> getFieldsWithValuesInTblUser() {
        ArrayList fields = new ArrayList();
        fields.add(FIELD_USER_ID);
        fields.add(FIELD_COMPUTER_NAME);
        fields.add(FIELD_COST_CENTRE);
        fields.add(FIELD_DEPARTMENT);
        fields.add(FIELD_IMPORT_NAME);
        fields.add(FIELD_LANGUAGE);
        fields.add(FIELD_ROOM);
        fields.add(FIELD_TELEPHONE);
        fields.add(FIELD_LUMP_SUM_1);
        fields.add(FIELD_LUMP_SUM_2);
        fields.add(FIELD_LUMP_SUM_3);
        fields.add(FIELD_CUSTOM_1);
        fields.add(FIELD_CUSTOM_2);
        fields.add(FIELD_CUSTOM_3);
        fields.add(FIELD_CUSTOM_4);
        fields.add(FIELD_CUSTOM_5);
        fields.add(FIELD_CUSTOM_6);
        fields.add(FIELD_GROUP_ID);
        fields.add(FIELD_LOCATION_ID);
        return fields;
    }

    public static boolean isResourceMember(@Nonnull UserAccount account) {
        Set groups = UserGroupManager.getInstance().getGroupsForUser(account.getID());
        for (UserGroupInfo group : groups) {
            if (group.getType() != RESOURCE) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWritePermissionInResource(GUID userId, UserGroupInfo resourceGroup) {
        Set membershipTypes = resourceGroup.getMembershipTypes(userId);
        if (membershipTypes != null && membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_WRITE)) {
            return true;
        }
        return HDUsersAndGroups.hasPermissionByParentResource(userId, resourceGroup, 2);
    }

    public static boolean hasAccessInResource(GUID userId, UserGroupInfo resourceGroup) {
        Set membershipTypes = resourceGroup.getMembershipTypes(userId);
        if (membershipTypes != null && (membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_READ) || membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_WRITE))) {
            return true;
        }
        return HDUsersAndGroups.hasPermissionByParentResource(userId, resourceGroup, 3);
    }

    public static boolean hasReadPermissionInResource(GUID userId, UserGroupInfo resourceGroup) {
        Set membershipTypes = resourceGroup.getMembershipTypes(userId);
        if (membershipTypes != null && membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_READ)) {
            return true;
        }
        return HDUsersAndGroups.hasPermissionByParentResource(userId, resourceGroup, 1);
    }

    private static boolean hasPermissionByParentResource(GUID userId, UserGroupInfo resourceGroup, int checkWhat) {
        UserGroupInfo parentGroup;
        GUID parentID = resourceGroup.getParentID();
        if (parentID != null && !resourceGroup.hasMembers() && (parentGroup = UserGroupManager.getInstance().getGroup(parentID)) != null) {
            Set membershipTypes = parentGroup.getMembershipTypes(userId);
            if (membershipTypes != null) {
                if ((checkWhat & 1) == 1 && membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_READ)) {
                    return true;
                }
                if ((checkWhat & 2) == 2 && membershipTypes.contains(RESOURCE_MEMBERSHIPTYPE_WRITE)) {
                    return true;
                }
            }
            if (HDUsersAndGroups.hasPermissionByParentResource(userId, parentGroup, checkWhat)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isNamedUser(@Nonnull UserAccount account) {
        return HDUsersAndGroups.isResourceMember(account) || SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])HdPermissions.getNamedUserLicensePermissions());
    }

    public static boolean isDispatcher(@Nonnull UserAccount account) {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{HdPermissions.DISPATCHER});
    }

    public static boolean isUserManager(@Nonnull UserAccount account) {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])new Permission[]{UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER});
    }

    public static boolean isSupporter(@Nonnull UserAccount account) {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)account, (Permission[])SUPPORTER_PERMISSIONS) || HDUsersAndGroups.isResourceMember(account);
    }

    public static boolean isSupporter(@Nullable GUID userAccountID, final @Nonnull Set<UserGroupInfo> groupsForUser) {
        UserAccount userAccount;
        if (!((Boolean)SystemPermissionChecker.SYSTEMPERMISSION_ENABLED.get()).booleanValue()) {
            return true;
        }
        UserAccount userAccount2 = userAccount = userAccountID == null ? null : UserManager.getInstance().getUserAccount(userAccountID);
        if (userAccount == null) {
            return false;
        }
        if (groupsForUser.stream().anyMatch(g -> g.getType() == RESOURCE && g.isActive())) {
            return true;
        }
        PermissionCheckScope scope = new PermissionCheckScope(){

            public UserAccount getUserAccount() {
                return userAccount;
            }

            public UserGroupInfo getAllUsersGroup() {
                return groupsForUser.stream().filter(g -> UsersAndGroups.GROUPID_ALLUSERS.equals((Object)g.getID())).findFirst().get();
            }

            public Set<UserGroupInfo> getUserGroups() {
                return groupsForUser;
            }
        };
        return SystemPermissionChecker.hasAnyPermission((PermissionCheckScope)scope, (Permission[])new Permission[]{HdPermissions.DISPATCHER, HdPermissions.TICKET_RESOURCES_READ});
    }

    public static boolean isEnduser(@Nonnull UserAccount account) {
        return !HDUsersAndGroups.isSupporter(account);
    }

    public static boolean isEnduser(@Nullable GUID userAccountID, @Nonnull Set<UserGroupInfo> groupsForUser) {
        return !HDUsersAndGroups.isSupporter(userAccountID, groupsForUser);
    }

    public static int getUserID(GUID accountID) {
        return HDUsersAndGroups.getUserID(UserManager.getInstance().getUserAccount(accountID));
    }

    public static int getUserID(UserAccount userAccount) {
        if (userAccount == null) {
            return -1;
        }
        Integer value = (Integer)userAccount.getValue((UserField)FIELD_USER_ID);
        if (value == null) {
            return -1;
        }
        return value;
    }

    @Nullable
    public static UserAccount getUserAccount(int userID) {
        UserManager manager = UserManager.getInstance();
        return HDUsersAndGroups.getUserAccount(userID, manager);
    }

    @Nullable
    public static UserAccount getUserAccount(int userID, UserManager manager) {
        if (userID < 0) {
            return null;
        }
        SearchCommand command = new SearchCommand(new SearchExpression[]{new SearchCondition("usrid", SearchCondition.SearchTermOperator.Equals, (Object)userID)});
        SearchResult result = manager.getSearchEngine().search(command);
        List entries = result.getEntries();
        if (entries.isEmpty()) {
            return null;
        }
        GUID accountID = (GUID)((SearchResultEntry)entries.get(0)).getId();
        return manager.getUserAccount(accountID);
    }

    public static Set<GUID> getMembersInResource(GUID resourceId, MembershipType membershipType) {
        UserGroupInfo resource = UserGroupManager.getInstance().getGroup(resourceId);
        Set memberIDs = resource.getMemberIDs(membershipType);
        if (resource.getParentID() != null && memberIDs.isEmpty()) {
            UserGroupInfo resourceParent = UserGroupManager.getInstance().getGroup(resource.getParentID());
            memberIDs = resourceParent.getMemberIDs(membershipType);
        }
        return memberIDs;
    }

    @Nullable
    public static GUID getResourceGroupUUID(int resID) {
        if (resID <= 0) {
            return null;
        }
        UserGroupInfo res = HDUsersAndGroups.getResource(resID);
        if (res == null) {
            HDLogger.error(new Throwable("User Group representing resource with ID =\"" + resID + "\" could not be found."));
            return null;
        }
        return res.getID();
    }

    public static UserGroupInfo getResource(int resID) {
        return ((IHelpDeskUserGroupManager)UserGroupManager.getInstance()).getUserGroupInfoForResourceId(resID);
    }

    public static int getResourceId(GUID resourceGroupId) {
        return (Integer)UserGroupManager.getRecoveryEnabledInstance().getGroup(resourceGroupId).getValue((UserGroupField)RES_FIELD_ID);
    }

    public static UserGroupInfo getResourceFromRecoveryEnabledManager(int resID) {
        return ((IHelpDeskUserGroupManager)UserGroupManager.getRecoveryEnabledInstance()).getUserGroupInfoForResourceId(resID);
    }

    public static String getResourceIconKey(UserGroupInfo ressourceGroup) {
        if (ressourceGroup == null || !ressourceGroup.isActive()) {
            return "deleted";
        }
        if (SystemPermissionChecker.checkAccess((Permission)HdPermissions.TICKET_RESOURCES_READ_WRITE)) {
            return "write";
        }
        if (HDUsersAndGroups.hasWritePermissionInResource(UserManager.getInstance().getCurrentUserAccountID(), ressourceGroup)) {
            return "write";
        }
        if (SystemPermissionChecker.checkAccess((Permission)HdPermissions.TICKET_RESOURCES_READ)) {
            return "read";
        }
        if (HDUsersAndGroups.hasReadPermissionInResource(UserManager.getInstance().getCurrentUserAccountID(), ressourceGroup)) {
            return "read";
        }
        return "blocked";
    }

    public static UserGroupInfo getFirstActiveResourceMatchedByName(String resourceName) {
        Set resources = UserGroupManager.getInstance().getGroups(RESOURCE);
        return resources.stream().filter(ugi -> resourceName.equalsIgnoreCase(ugi.getName())).findFirst().orElse(null);
    }

    public static boolean isFieldOptionSet(int settingsId, int option) {
        FieldSetting setting;
        Map<Integer, FieldSetting> settingMap = (Map<Integer, FieldSetting>)localFieldSettings.get();
        if (settingMap == null) {
            try {
                settingMap = ((ServerDataConnector)ServerPluginManager.getInstance().getSingleInstance(ServerDataConnector.class)).getFieldSettings();
                localFieldSettings.set(settingMap);
            }
            catch (ServerDataException e) {
                throw new IllegalStateException(e);
            }
        }
        if ((setting = (FieldSetting)settingMap.get(settingsId)) == null) {
            throw new IllegalArgumentException("no known setting " + settingsId);
        }
        UserAccount currentUserAccount = UserManager.getInstance().getCurrentUserAccount();
        return (setting.getOptionValue(ActionType.editUser, ContextType.enduser, currentUserAccount) & option) == option;
    }

    public static boolean isPrivilegedUser(int userId) {
        return userId == Integer.MAX_VALUE;
    }

    public static boolean isPrivilegedUser(GUID userId) {
        return userId == UserManager.PRIVILEGED_ACCOUNT_ID;
    }

    public static Set<Integer> getEffectiveAllowedActionsForUser(UserAccount account) {
        HashSet<Integer> result = new HashSet<Integer>();
        if (account.getAccountType() == UserAccountType.Administrator) {
            return ActionManager.getInstance().getAllValidIds();
        }
        result.addAll((Collection)account.getValue((UserField)FIELD_ALLOWED_ACTIONS));
        for (UserGroupInfo group : UserGroupManager.getInstance().getGroupsForUser(account.getID())) {
            if (!group.isActive()) continue;
            if (group.getID().equals((Object)UsersAndGroups.GROUPID_ADMIN)) {
                return ActionManager.getInstance().getAllValidIds();
            }
            result.addAll((Collection)group.getValue((UserGroupField)GROUP_FIELD_ALLOWED_ACTIONS));
        }
        return result;
    }
}

