/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.TicketViewState;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.id.GUID;
import com.inet.search.command.JoinSearchCondition;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserFieldSubViewGrouping
extends SimpleSubViewGrouping {
    private UserField<?> field;

    public UserFieldSubViewGrouping(@Nonnull UserField<?> field) {
        super("ownerid");
        this.field = field;
    }

    @Override
    public String getKey() {
        return this.field.getKey();
    }

    @Override
    public String getDisplayName() {
        return this.field.getSearchTag().getDisplayName();
    }

    @Override
    public List<TicketViewFactory> getSubViews(TicketViewFactory parent, GUID accountID, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendSubViewStates(TicketViewState parentState, TicketViewFactory parentFactory, GUID accountID, @Nonnull Set<Integer> result, @Nullable Set<Integer> unreadResult, IndexSearchEngine<Integer> engine, @Nullable IndexSearchEngine<SlaveInfo> slaveInfoEngine) {
        Map displayNames = this.field.getSearchTag().getMapData();
        while (result.size() > 0 && parentState.size() < 100) {
            UserAccount owner;
            GUID ownerGUID;
            Integer ticketID = result.iterator().next();
            TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketID);
            if (ticket != null && (ownerGUID = ticket.getValue(Tickets.FIELD_OWNER_GUID)) != null && (owner = UserManager.getInstance().getUserAccount(ownerGUID)) != null) {
                Object info2;
                Object fieldValue = owner.getValue(this.field);
                Set users = UserManager.getInstance().getSearchEngine().simpleSearch(new SearchCommand(this.field.getKey(), SearchCondition.SearchTermOperator.Equals, fieldValue));
                Set subResult = engine.simpleSearch(new SearchCommand("ownerid", SearchCondition.SearchTermOperator.IN, (Object)users));
                if (slaveInfoEngine != null) {
                    Set slaveInfos = slaveInfoEngine.simpleSearch(new SearchCommand("aufid", SearchCondition.SearchTermOperator.IN, (Object)subResult));
                    for (Object info2 : slaveInfos) {
                        Integer aufID = ((SlaveInfo)info2).getAufID();
                        if (!result.contains(aufID)) {
                            subResult.remove(aufID);
                            continue;
                        }
                        Integer bunID = ((SlaveInfo)info2).getBunID();
                        if (!subResult.contains(bunID)) continue;
                        subResult.remove(bunID);
                        result.remove(bunID);
                    }
                }
                int totalTicketCount = 0;
                int unreadTicketCount = 0;
                info2 = subResult.iterator();
                while (info2.hasNext()) {
                    Integer aufId = (Integer)info2.next();
                    if (result.remove(aufId)) {
                        ++totalTicketCount;
                    }
                    if (unreadResult == null || !unreadResult.remove(aufId)) continue;
                    ++unreadTicketCount;
                }
                if (totalTicketCount > 0) {
                    final String displayName = (String)displayNames.get(fieldValue);
                    TicketViewState subState = new TicketViewState(parentFactory.getID() + "." + fieldValue, totalTicketCount, unreadTicketCount, parentFactory, parentState){

                        @Override
                        public String getDisplayName() {
                            return displayName;
                        }
                    };
                    parentState.add(subState);
                }
            }
            result.remove(ticketID);
        }
        parentState.sort((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getDisplayName(), b.getDisplayName()));
    }

    @Override
    protected Supplier<SearchExpression> getConditionSupplier(@Nonnull String subID) {
        try {
            Integer value = Integer.valueOf(subID);
            return () -> {
                IndexSearchEngine userEngine = UserManager.getInstance().getSearchEngine();
                SearchCommand ownerCommand = new SearchCommand(this.field.getKey(), SearchCondition.SearchTermOperator.Equals, (Object)value);
                return new JoinSearchCondition("ownerid", userEngine, ownerCommand);
            };
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

