/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.JoinSearchCondition;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class SupervisorSubViewGrouping
extends SimpleSubViewGrouping {
    public static final SupervisorSubViewGrouping INSTANCE = new SupervisorSubViewGrouping();

    private SupervisorSubViewGrouping() {
        super("supervisor");
    }

    @Override
    public String getDisplayName() {
        return Tickets.MSG.getMsg("viewgroup.supervisor", new Object[0]);
    }

    @Override
    public List<TicketViewFactory> getSubViews(TicketViewFactory parent, GUID accountID, Locale locale) {
        List<UserGroupVO> supervisorGroups = UserGroupVOManager.getInstance().getGroupsWhereUserIsSupervisor(accountID);
        if (supervisorGroups.isEmpty()) {
            return null;
        }
        ArrayList<TicketViewFactory> result = new ArrayList<TicketViewFactory>();
        for (UserGroupVO userGroup : supervisorGroups) {
            Integer id = userGroup.getId();
            result.add(new SubView<Integer>(parent, this, id, userGroup.getDisplayValue(), null, id.toString()));
        }
        return result;
    }

    @Override
    public void appendMarker(SearchCommand command) {
        command.addBoostingExpression((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
    }

    @Override
    public void patchSearchCommand(Object id, @Nonnull SearchCommand command, @Nonnull GUID accountID) {
        IndexSearchEngine searchEngine = UserManager.getInstance().getSearchEngine();
        SearchCommand usersCommand = new SearchCommand("groupid", SearchCondition.SearchTermOperator.Equals, id);
        Set users = searchEngine.simpleSearch(usersCommand);
        AndSearchExpression expressions = command.getSearchExpression();
        int pos = expressions.size();
        int i = 0;
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            SearchCondition cond;
            SearchExpression expr = (SearchExpression)it.next();
            if (expr.getType() == SearchExpression.Type.Condition && "ownerid".equals((cond = (SearchCondition)expr).getLeftOperand())) {
                switch (cond.getOperator()) {
                    case StartsWith: {
                        it.remove();
                        pos = i;
                        break;
                    }
                    case IN: {
                        users.retainAll((Collection)cond.getRightOperand());
                        it.remove();
                        pos = i;
                    }
                }
            }
            ++i;
        }
        expressions.add(pos, (Object)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)users));
    }

    @Override
    protected Supplier<SearchExpression> getConditionSupplier(String subID) {
        try {
            Integer value = Integer.valueOf(subID);
            return () -> {
                IndexSearchEngine userEngine = UserManager.getInstance().getSearchEngine();
                SearchCommand groupsCommand = new SearchCommand("groupid", SearchCondition.SearchTermOperator.Equals, (Object)value);
                return new JoinSearchCondition("ownerid", userEngine, groupsCommand);
            };
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

