/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.subview;

import com.inet.helpdesk.HelpDeskServer;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.core.ticketview.subview.SimpleSubViewGrouping;
import com.inet.helpdesk.core.ticketview.subview.SubView;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.permissions.Permission;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResourceSubViewGrouping
extends SimpleSubViewGrouping {
    private static final String DELETED = "deleted";
    private static final String WRITE = "write";
    private static final String READ = "read";
    public static final ResourceSubViewGrouping INSTANCE = new ResourceSubViewGrouping();
    private final Function<GUID, UserGroupInfo> resourceManager;
    private int metaDataVersion;

    ResourceSubViewGrouping() {
        this((GUID resID) -> UserGroupManager.getInstance().getGroup(resID));
    }

    ResourceSubViewGrouping(Function<GUID, UserGroupInfo> resourceManager) {
        super("resourceid");
        this.resourceManager = resourceManager;
    }

    boolean getReadRight(UserAccount userAccount) {
        return SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ});
    }

    @Override
    public List<TicketViewFactory> getSubViews(TicketViewFactory parentView, GUID accountID, Locale locale) {
        Iterator<GUID> it;
        if (parentView instanceof SubResources) {
            return ((SubResources)parentView).getSubResources();
        }
        IndexSearchEngine<Integer> engine = TicketManager.getReader().getSearchEngine();
        SearchTag tag = engine.getTag("resourceid");
        HashMap<Object, SubResources> map = new HashMap<Object, SubResources>();
        ArrayList<TicketViewFactory> views = new ArrayList<TicketViewFactory>();
        UserAccount userAccount = UserManager.getInstance().getUserAccount(accountID);
        boolean readRight = this.getReadRight(userAccount);
        boolean writeRight = SystemPermissionChecker.hasAnyPermission((UserAccount)userAccount, (Permission[])new Permission[]{HdPermissions.TICKET_RESOURCES_READ_WRITE});
        if (readRight) {
            final Iterator valuesIterator = engine.createValuesIterator(tag, true);
            it = new Iterator<GUID>(){

                @Override
                public boolean hasNext() {
                    return valuesIterator.hasNext();
                }

                @Override
                public GUID next() {
                    String value = (String)valuesIterator.next();
                    return value == null ? null : GUID.valueOf((String)value);
                }
            };
        } else {
            it = ResourceSubViewGrouping.getResourceIDs(accountID).iterator();
        }
        while (it.hasNext()) {
            UserGroupInfo userGroupInfo;
            GUID resId = it.next();
            if (resId == null || (userGroupInfo = this.resourceManager.apply(resId)) == null) continue;
            String iconKey = ResourceSubViewGrouping.getIconKey(userGroupInfo, writeRight, accountID);
            String displayName = userGroupInfo.getDisplayName();
            if (displayName == null) continue;
            SubResources view = new SubResources(parentView, resId, displayName, iconKey);
            map.put(resId, view);
        }
        for (Map.Entry entry : new HashMap(map).entrySet()) {
            GUID resId = (GUID)entry.getKey();
            SubResources view = (SubResources)entry.getValue();
            UserGroupInfo res = this.resourceManager.apply(resId);
            GUID parentId = res != null ? res.getParentID() : null;
            if (parentId == null) {
                views.add(view);
                continue;
            }
            SubResources parent = (SubResources)map.get(parentId);
            if (parent == null) {
                String dispalyName;
                UserGroupInfo parentRes = this.resourceManager.apply(parentId);
                String string = dispalyName = parentRes == null ? null : parentRes.getDisplayName();
                if (dispalyName == null) {
                    views.add(view);
                    continue;
                }
                String iconKey = ResourceSubViewGrouping.getIconKey(parentRes, writeRight, accountID);
                parent = new SubResources(parentView, parentId, dispalyName, iconKey);
                if (!readRight) {
                    parent.allIds.clear();
                }
                map.put(parentId, parent);
                views.add(parent);
            }
            parent.addSubResource(resId, view);
        }
        Comparator comp = (a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getDisplayName(), b.getDisplayName());
        views.sort(comp);
        for (TicketViewFactory view : views) {
            List<TicketViewFactory> subViews = ((SubResources)view).getSubResources();
            if (subViews == null) continue;
            subViews.sort(comp);
        }
        return views;
    }

    @Nonnull
    private static String getIconKey(UserGroupInfo res, boolean writeRight, @Nonnull GUID accountID) {
        if (res == null) {
            return DELETED;
        }
        if (!res.isActive()) {
            return DELETED;
        }
        if (writeRight) {
            return WRITE;
        }
        if (HDUsersAndGroups.hasWritePermissionInResource(accountID, res)) {
            return WRITE;
        }
        return READ;
    }

    @Override
    public void patchSearchCommand(Object id, @Nonnull SearchCommand command, @Nonnull GUID accountID) {
        HashSet allIds = new HashSet((HashSet)id);
        AndSearchExpression expressions = command.getSearchExpression();
        Iterator it = expressions.iterator();
        while (it.hasNext()) {
            SearchCondition cond;
            SearchExpression expr = (SearchExpression)it.next();
            if (expr.getType() != SearchExpression.Type.Condition || !"ownerid".equals((cond = (SearchCondition)expr).getLeftOperand())) continue;
            switch (cond.getOperator()) {
                case StartsWith: {
                    it.remove();
                    break;
                }
                case IN: {
                    allIds.retainAll((Collection)cond.getRightOperand());
                }
            }
        }
        expressions.add((SearchExpression)new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, id));
    }

    @Override
    @Nullable
    protected Supplier<SearchExpression> getConditionSupplier(@Nonnull String subID) {
        GUID rootId = GUID.valueOf((String)subID);
        return () -> {
            HashSet<String> resources;
            block6: {
                resources = new HashSet<String>();
                resources.add(rootId.toString());
                UserGroupManager manager = UserGroupManager.getInstance();
                UserGroupInfo root = manager.getGroup(rootId);
                if (root == null || root.getParentID() != null) break block6;
                UserAccount userAccount = UserManager.getInstance().getCurrentUserAccount();
                boolean readRight = this.getReadRight(userAccount);
                if (readRight) {
                    for (UserGroupInfo group : manager.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE)) {
                        if (!rootId.equals((Object)group.getParentID())) continue;
                        resources.add(group.getID().toString());
                    }
                } else {
                    resources.clear();
                    for (UserGroupInfo group : manager.getGroupsForUserIncludingDeactivated(userAccount.getID())) {
                        if (group.getType() != HDUsersAndGroups.RESOURCE) continue;
                        if (rootId.equals((Object)group.getID())) {
                            resources.add(rootId.toString());
                        }
                        if (!rootId.equals((Object)group.getParentID())) continue;
                        resources.add(group.getID().toString());
                    }
                    for (UserGroupInfo group : manager.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE)) {
                        if (group.hasMembers() || !rootId.equals((Object)group.getParentID())) continue;
                        resources.add(group.getID().toString());
                    }
                }
            }
            return new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, resources);
        };
    }

    @Override
    public URL getIconURL(String iconKey, int size) {
        String fileName;
        if (iconKey == null) {
            return HelpDeskServer.class.getResource("images/resources_16.gif");
        }
        switch (iconKey) {
            case "read": {
                fileName = "resources_read";
                break;
            }
            case "write": {
                fileName = "resources";
                break;
            }
            default: {
                fileName = "delete";
            }
        }
        return this.getClass().getResource("/com/inet/helpdesk/images/" + fileName + "_16.gif");
    }

    @Nonnull
    public static HashSet<GUID> getResourceIDs(@Nonnull GUID accountID) {
        HashSet<GUID> resources = new HashSet<GUID>();
        UserGroupManager manager = UserGroupManager.getInstance();
        for (UserGroupInfo group : manager.getGroupsForUserIncludingDeactivated(accountID)) {
            if (group.getType() != HDUsersAndGroups.RESOURCE) continue;
            resources.add(group.getID());
        }
        for (UserGroupInfo group : manager.getGroupsIncludingDeactivated(HDUsersAndGroups.RESOURCE)) {
            if (group.hasMembers() || !resources.contains(group.getParentID())) continue;
            resources.add(group.getID());
        }
        return resources;
    }

    @Override
    public int getMetaDataVersion() {
        return this.metaDataVersion;
    }

    public void incMetaDataVersion() {
        ++this.metaDataVersion;
    }

    private static class SubResources
    extends SubView<GUID> {
        @Nonnull
        private final HashSet<GUID> allIds = new HashSet();
        private List<TicketViewFactory> subViews;

        public SubResources(@Nonnull TicketViewFactory parent, @Nonnull GUID resId, String displayName, String iconKey) {
            super(parent, INSTANCE, resId, displayName, null, iconKey);
            this.allIds.add(resId);
        }

        @Override
        public SubViewGroupingDefinition getSubViewGrouping() {
            return INSTANCE;
        }

        @Override
        public Object getFilterID() {
            return this.allIds;
        }

        private void addSubResource(GUID resId, SubResources view) {
            if (this.subViews == null) {
                this.subViews = new ArrayList<TicketViewFactory>();
            }
            this.subViews.add(view);
            this.allIds.add(resId);
        }

        @Nullable
        public List<TicketViewFactory> getSubResources() {
            return this.subViews;
        }
    }
}

