/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview.standardviews;

import com.inet.helpdesk.core.ticketmanager.fields.FieldVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVO;
import com.inet.helpdesk.core.ticketmanager.fields.usergroup.UserGroupVOManager;
import com.inet.helpdesk.core.ticketview.SubViewGroupingDefinition;
import com.inet.helpdesk.core.ticketview.TicketViewFactory;
import com.inet.helpdesk.ticketview.standardviews.OwnTicketViewDefinition;
import com.inet.helpdesk.ticketview.subview.SupervisorSubViewGrouping;
import com.inet.id.GUID;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SupervisorTicketViewDefinition
implements TicketViewFactory {
    public static final String KEY = "supervisor";

    @Override
    public String getID() {
        return KEY;
    }

    @Override
    public String getDisplayName() {
        return SupervisorSubViewGrouping.INSTANCE.getDisplayName();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getCategoryKey() {
        return KEY;
    }

    @Nullable
    public static AndSearchExpression createSearchExpression(GUID accountID, @Nonnull Locale locale) {
        List<UserGroupVO> supervisorGroups = UserGroupVOManager.getInstance().getGroupsWhereUserIsSupervisor(accountID);
        if (supervisorGroups.isEmpty()) {
            return null;
        }
        Set groupIDs = supervisorGroups.stream().map(FieldVO::getId).collect(Collectors.toSet());
        IndexSearchEngine searchEngine = UserManager.getInstance().getSearchEngine();
        SearchCommand usersCommand = new SearchCommand(locale, "groupid", SearchCondition.SearchTermOperator.IN, groupIDs);
        Set users = searchEngine.simpleSearch(usersCommand);
        AndSearchExpression and = new AndSearchExpression();
        and.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)users));
        and.add((SearchExpression)OwnTicketViewDefinition.NO_WORKFLOW);
        return and;
    }

    @Override
    public SearchCommand createSearchCommand(GUID accountID, Locale locale, IndexSearchEngine<Integer> engine) {
        AndSearchExpression condition = SupervisorTicketViewDefinition.createSearchExpression(accountID, locale);
        if (condition == null) {
            return null;
        }
        return new SearchCommand(locale, new SearchExpression[]{condition});
    }

    @Override
    public SubViewGroupingDefinition getSubViewGrouping() {
        return SupervisorSubViewGrouping.INSTANCE;
    }
}

