/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketview;

import com.inet.helpdesk.core.ticketview.TicketViewManager;
import com.inet.helpdesk.ticketview.TicketViewManagerImpl;
import com.inet.helpdesk.ticketview.subview.MyResourceSubViewGrouping;
import com.inet.helpdesk.ticketview.subview.ResourceSubViewGrouping;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupEventListener;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import java.util.concurrent.ForkJoinPool;

public class TicketViewGroupEventListener
implements UserGroupEventListener {
    public void groupCreated(UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, false);
    }

    public void groupRenamed(String previousGroupName, UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, true);
    }

    public void groupParentChanged(UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, true);
    }

    public void groupDataUpdated(UserGroupInfo groupInfo) {
        this.notifyResourcesViewChanged(false);
    }

    public void groupMembersUpdated(UserGroupInfo groupInfo) {
        this.notifyResourcesViewChanged(true);
    }

    public void groupDeleted(UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, true);
    }

    public void groupDeactivated(UserGroupInfo groupInfo) {
        this.notifyIfResourceChanged(groupInfo, true);
    }

    private void notifyIfResourceChanged(UserGroupInfo groupInfo, boolean metaDataChanged) {
        if (groupInfo.getType() != HDUsersAndGroups.RESOURCE) {
            return;
        }
        this.notifyResourcesViewChanged(metaDataChanged);
    }

    private void notifyResourcesViewChanged(boolean metaDataChanged) {
        if (metaDataChanged) {
            ResourceSubViewGrouping.INSTANCE.incMetaDataVersion();
            MyResourceSubViewGrouping.INSTANCE.incMetaDataVersion();
        }
        ForkJoinPool.commonPool().execute(() -> ((TicketViewManagerImpl)TicketViewManager.getInstance()).notifyAllTreeChanges());
    }
}

