/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.trigger;

import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.data.ServerDataConnectorImpl;
import com.inet.helpdesk.shared.model.DataField;
import com.inet.helpdesk.shared.model.Field;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import srv.automatic.trigger.TriggerHandler;

public class TicketCreationJavaScriptTrigger {
    private static final List<Field> FIELDS_USERDATA_TRIGGER = new ArrayList<Field>(){
        {
            this.add(Field.USERDATA_USERNAME);
            this.add(Field.USERDATA_LASTNAME);
            this.add(Field.USERDATA_FIRSTNAME);
            this.add(Field.USERDATA_COMPUTERNAME);
            this.add(Field.USERDATA_LANGUAGE);
            this.add(Field.USERDATA_EMAIL);
            this.add(Field.USERDATA_TELEPHONE);
            this.add(Field.USERDATA_ROOM);
            this.add(Field.USERDATA_DEPARTMENT);
            this.add(Field.USERDATA_COSTCENTRE);
            this.add(Field.USERDATA_LOCATION);
            this.add(Field.USERDATA_GROUP);
            this.add(Field.USERDATA_USERFIELD1);
            this.add(Field.USERDATA_USERFIELD2);
            this.add(Field.USERDATA_USERFIELD3);
            this.add(Field.USERDATA_USERFIELD4);
            this.add(Field.USERDATA_USERFIELD5);
        }
    };
    private ConnectionFactory conFactory;

    public TicketCreationJavaScriptTrigger(ConnectionFactory conFactory) {
        if (conFactory == null) {
            throw new IllegalArgumentException("conFactory must not be null");
        }
        this.conFactory = conFactory;
    }

    public static boolean isConfigured() {
        return TriggerHandler.getTrigger(4) != null;
    }

    public boolean apply(@Nullable UserAccount ticketOwner, MutableTicketData ticketData, String initialRequestText) throws ServerDataException {
        boolean bl;
        Connection triggerCon = null;
        CallableStatement triggerSt = null;
        ResultSet triggerRs = null;
        try {
            boolean shouldDispatch;
            triggerCon = this.conFactory.getConnection();
            triggerSt = this.conFactory.getCallableStatement("ExecuteNewTrigger", triggerCon);
            String categoryPath = CategoryManager.getInstance().findCategoryPathOrThrow(ticketData.get(Tickets.FIELD_CATEGORY_ID));
            triggerSt.setObject("betreff", (Object)categoryPath);
            triggerSt.setObject(Field.TICKETDATA_CLASSIFICATIONID.getKey(), (Object)ticketData.get(Tickets.FIELD_CLASSIFICATION_ID));
            triggerSt.setObject(Field.TICKETDATA_ITILID.getKey(), (Object)ticketData.get(Tickets.FIELD_ITIL_ID));
            triggerSt.setObject(Field.TICKETDATA_RESOURCEID.getKey(), (Object)this.getResIntID(ticketData.get(Tickets.FIELD_RESOURCE_GUID)));
            triggerSt.setObject(Field.TICKETDATA_PRIORITYID.getKey(), (Object)ticketData.get(Tickets.FIELD_PRIORITY_ID));
            triggerSt.setObject(Field.TICKETDATA_SPECIALFIELD.getKey(), (Object)ticketData.get(Tickets.FIELD_IDENTIFIER));
            triggerSt.setObject(Field.TICKETDATA_TICKETFIELD1.getKey(), (Object)ticketData.get(Tickets.FIELD_CUSTOM_1));
            triggerSt.setObject(Field.TICKETDATA_TICKETFIELD2.getKey(), (Object)ticketData.get(Tickets.FIELD_CUSTOM_2));
            triggerSt.setObject(Field.TICKETDATA_TICKETFIELD3.getKey(), (Object)ticketData.get(Tickets.FIELD_CUSTOM_3));
            triggerSt.setObject(Field.TICKETDATA_TICKETFIELD4.getKey(), (Object)ticketData.get(Tickets.FIELD_CUSTOM_4));
            triggerSt.setObject(Field.TICKETDATA_SUBJECT.getKey(), (Object)ticketData.get(Tickets.FIELD_SUBJECT));
            triggerSt.setObject(Field.TICKETDATA_PREVIEW.getKey(), (Object)initialRequestText);
            if (ticketOwner != null) {
                ArrayList<DataField> data = UserModelConverter.convertUserAccount(ticketOwner).getData();
                for (DataField df : data) {
                    String key;
                    Field field = df.getField();
                    if (field == null || !FIELDS_USERDATA_TRIGGER.contains((Object)field) || (key = field.getKey()) == null || key.length() == 0) continue;
                    Object value = df.getValue(field.getClassType());
                    if (value instanceof String[]) {
                        value = String.join((CharSequence)";", (String[])value);
                    }
                    if (value == null) continue;
                    triggerSt.setObject(key, value);
                }
            }
            triggerRs = triggerSt.executeQuery();
            triggerRs.next();
            String kategorie = (String)triggerRs.getObject(1);
            Object klaIDObject = triggerRs.getObject(2);
            if (klaIDObject != null && !klaIDObject.toString().isEmpty()) {
                int klaID = Integer.parseInt(klaIDObject.toString());
                ticketData.put(Tickets.FIELD_CLASSIFICATION_ID, klaID);
            }
            int itiID = (Integer)triggerRs.getObject(3);
            int resID = 0;
            Object resIDObject = triggerRs.getObject(4);
            if (resIDObject != null && !resIDObject.toString().isEmpty()) {
                resID = Integer.parseInt(resIDObject.toString());
            }
            int priID = (Integer)triggerRs.getObject(5);
            String spezFeld = (String)triggerRs.getObject(6);
            String bunFeld1 = (String)triggerRs.getObject(7);
            String bunFeld2 = (String)triggerRs.getObject(8);
            String bunFeld3 = (String)triggerRs.getObject(9);
            String bunFeld4 = (String)triggerRs.getObject(10);
            String betreff = (String)triggerRs.getObject(11);
            Integer catID = null;
            if (kategorie != null && !kategorie.isEmpty()) {
                catID = CategoryManager.getInstance().findOrCreateCategory(kategorie);
            }
            GUID resUUID = HDUsersAndGroups.getResourceGroupUUID(resID);
            ticketData.put(Tickets.FIELD_RESOURCE_GUID, resUUID);
            ticketData.put(Tickets.FIELD_CATEGORY_ID, catID);
            ticketData.put(Tickets.FIELD_ITIL_ID, itiID);
            ticketData.put(Tickets.FIELD_PRIORITY_ID, priID);
            ticketData.put(Tickets.FIELD_IDENTIFIER, spezFeld);
            ticketData.put(Tickets.FIELD_CUSTOM_1, bunFeld1);
            ticketData.put(Tickets.FIELD_CUSTOM_2, bunFeld2);
            ticketData.put(Tickets.FIELD_CUSTOM_3, bunFeld3);
            ticketData.put(Tickets.FIELD_CUSTOM_4, bunFeld4);
            ticketData.put(Tickets.FIELD_SUBJECT, betreff);
            bl = shouldDispatch = resUUID != null;
        }
        catch (SQLException e) {
            try {
                throw new ServerDataException(e);
            }
            catch (Throwable throwable) {
                ServerDataConnectorImpl.closeAll(triggerCon, triggerSt, triggerRs);
                throw throwable;
            }
        }
        ServerDataConnectorImpl.closeAll(triggerCon, triggerSt, triggerRs);
        return bl;
    }

    @Nullable
    private Integer getResIntID(@Nullable GUID resUUID) {
        if (resUUID == null) {
            return null;
        }
        UserGroupInfo res = UserGroupManager.getInstance().getGroup(resUUID);
        if (res == null) {
            return null;
        }
        return (Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_ID);
    }
}

