/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.error.ErrorCode;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.ticketmanager.search.TicketIdMatcher;
import com.inet.helpdesk.ticketmanager.search.TicketSearchDataCache;
import com.inet.helpdesk.usersandgroups.HelpDeskReindexKeyGenerator;
import com.inet.search.SearchDataCache;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.command.JoinTokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class TicketSearchEngine {
    public static final String SLAVE_INFO_KEY = "aufid";
    private IndexSearchEngine<Integer> searchEngine;
    private TicketSearchDataCache searchDataCache;
    private IndexSearchEngine<SlaveInfo> slaveInfoSearchEngine;

    private String createReindexKey() {
        return HelpDeskReindexKeyGenerator.createReindexKey(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(TicketSearchDataCache cache) throws IOException {
        if (cache == null) {
            throw new IllegalArgumentException("search data cache must not be null");
        }
        if (this.searchDataCache != null) {
            throw new IllegalStateException("search data cache is already set");
        }
        String reindexKey = this.createReindexKey();
        IndexSearchEngine searchEngine = new IndexSearchEngine("ticketsearch", reindexKey, false, Integer.class, false);
        IndexSearchEngine bunIdSearchEngine = new IndexSearchEngine("ticketids", reindexKey, false, SlaveInfo.class, false);
        try {
            this.searchDataCache = cache;
            for (SearchTag tag : cache.getSearchTags()) {
                searchEngine.addTag(tag);
            }
            searchEngine.addTag((SearchTag)new TicketIdMatcher((IndexSearchEngine<Integer>)searchEngine));
            List<String> userFields = Arrays.asList("lastname", "firstname", "email", "location");
            JoinTokenMatcher.addToIndex((IndexSearchEngine)searchEngine, (String)"ownerid", (IndexSearchEngine)UserManager.getInstance().getSearchEngine(), userFields);
            JoinTokenMatcher.addToIndex((IndexSearchEngine)searchEngine, (String)"lasteditorid", (IndexSearchEngine)UserManager.getInstance().getSearchEngine(), userFields);
            bunIdSearchEngine.addTag(new SearchTag(SLAVE_INFO_KEY, SearchDataType.Integer, false, 0, SLAVE_INFO_KEY, false));
            bunIdSearchEngine.setData((SearchDataCache)this.searchDataCache.getSlaveInfoSearchDataCache(), 1);
            searchEngine.setData((SearchDataCache)cache, 4);
        }
        finally {
            TicketSearchEngine ticketSearchEngine = this;
            synchronized (ticketSearchEngine) {
                this.slaveInfoSearchEngine = bunIdSearchEngine;
                this.searchEngine = searchEngine;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnInit() {
        TicketSearchEngine ticketSearchEngine = this;
        synchronized (ticketSearchEngine) {
            while (this.searchEngine == null) {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException ex) {
                    ErrorCode.throwAny((Throwable)ex);
                }
            }
        }
    }

    public IndexSearchEngine<Integer> getSearchEngine() {
        if (this.searchEngine == null) {
            this.waitOnInit();
        }
        return this.searchEngine;
    }

    public IndexSearchEngine<SlaveInfo> getSlaveInfoEngine() {
        if (this.slaveInfoSearchEngine == null) {
            this.waitOnInit();
        }
        return this.slaveInfoSearchEngine;
    }

    public boolean hasTag(String key) {
        return this.getSearchEngine().getTag(key) != null;
    }
}

