/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.search;

import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.TicketSearchFilterOptions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import srv.ServerUtilities;

public class GroupingParameterToSearchCondition
implements TicketSearchFilterOptions.FieldCondition {
    private int field;
    private Object value;

    public GroupingParameterToSearchCondition(int field, Object value) {
        this.field = field;
        this.value = value;
    }

    public int field() {
        return this.field;
    }

    public Object value() {
        return this.value;
    }

    public String toString() {
        return this.field + "=" + this.value;
    }

    private SearchExpression createSearchConditionForGrouping(int groupingType, Object groupingValue) {
        Integer groupingValueInt;
        if (groupingType == -1) {
            return null;
        }
        String groupingValueStr = groupingValue instanceof String ? (String)groupingValue : null;
        Integer n = groupingValueInt = groupingValue instanceof Integer ? (Integer)groupingValue : null;
        if (groupingValueStr == null && groupingValueInt != null) {
            groupingValueStr = String.valueOf(groupingValueInt);
        }
        if (groupingValueInt == null && groupingValueStr != null) {
            try {
                groupingValueInt = Integer.valueOf(groupingValueStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        switch (groupingType) {
            case 0: {
                return new SearchCondition("statusid", SearchCondition.SearchTermOperator.Equals, groupingValue);
            }
            case 1: {
                GUID resourceGroupUUID = HDUsersAndGroups.getResourceGroupUUID(groupingValueInt);
                ArrayList<GUID> ressis = new ArrayList<GUID>();
                ressis.add(resourceGroupUUID);
                UserGroupManager.getInstance().getGroups(HDUsersAndGroups.GROUPTYPEDEF_RESOURCE.getGroupType()).stream().filter(ugi -> ugi.getParentID() != null && ugi.getParentID().equals((Object)resourceGroupUUID)).forEach(sub -> ressis.add(sub.getID()));
                return new SearchCondition("resourceid", SearchCondition.SearchTermOperator.IN, ressis);
            }
            case 2: {
                return new SearchCondition("priorityid", SearchCondition.SearchTermOperator.Equals, groupingValue);
            }
            case 3: {
                return new SearchCondition("classificationid", SearchCondition.SearchTermOperator.Equals, groupingValue);
            }
            case 4: {
                Integer rightOperand = Tickets.FIELD_CATEGORY_ID.getValidOrDefaultValue(groupingValueInt, null);
                return new SearchCondition("categoryid", SearchCondition.SearchTermOperator.Equals, (Object)rightOperand);
            }
            case 5: {
                if (groupingValue == null || groupingValue.equals("-1")) {
                    return new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, null);
                }
                SearchCommand locationSearchCmd = new SearchCommand("location", SearchCondition.SearchTermOperator.Equals, groupingValue);
                Set idsOfUsersInLocation = UserManager.getInstance().getSearchEngine().simpleSearch(locationSearchCmd);
                return new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)idsOfUsersInLocation);
            }
            case 6: {
                int[] nArray;
                if (groupingValue == null || groupingValue.equals("-1")) {
                    return new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, null);
                }
                if (groupingValue instanceof int[]) {
                    nArray = (int[])groupingValue;
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = groupingValueInt;
                }
                int[] groupIds = nArray;
                List groupIdsList = Arrays.stream(groupIds).boxed().collect(Collectors.toList());
                SearchCommand groupSearchCmd = new SearchCommand("groupid", SearchCondition.SearchTermOperator.IN, groupIdsList);
                Set idsOfUsersInGroup = UserManager.getInstance().getSearchEngine().simpleSearch(groupSearchCmd);
                return new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)idsOfUsersInGroup);
            }
            case 7: {
                return new SearchCondition("itilid", SearchCondition.SearchTermOperator.Equals, groupingValue);
            }
            case 13: {
                return new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, groupingValue);
            }
            case 8: {
                Set<Integer> orderIDs = ServerUtilities.getOpenOrderController().getOrderIdsForTypeFreiauswahl(groupingValueStr);
                return new PrefilteredSearchExpression(orderIDs);
            }
            case 9: {
                if (groupingValueStr == null || groupingValueStr.trim().isEmpty()) {
                    return new SearchCondition("lasteditorid", SearchCondition.SearchTermOperator.Equals, null);
                }
                try {
                    GUID guid = GUID.valueOf((String)groupingValueStr);
                    return new SearchCondition("lasteditorid", SearchCondition.SearchTermOperator.Equals, (Object)guid);
                }
                catch (IllegalArgumentException isNotAGUID) {
                    ArrayList additionalExpressions = new ArrayList();
                    SearchResult searchResult = UserManager.getInstance().search(groupingValueStr, additionalExpressions, Collections.emptyList(), 10, null);
                    Iterator iterator = searchResult.getEntries().iterator();
                    if (iterator.hasNext()) {
                        SearchResultEntry entry = (SearchResultEntry)iterator.next();
                        GUID guid = (GUID)entry.getId();
                        return new SearchCondition("lasteditorid", SearchCondition.SearchTermOperator.Equals, (Object)guid);
                    }
                    return new SearchCondition("lasteditorid", SearchCondition.SearchTermOperator.Equals, (Object)".");
                }
            }
        }
        throw new IllegalArgumentException("Unknown type: " + this.field);
    }

    @Override
    public SearchExpression getCondition() {
        return this.createSearchConditionForGrouping(this.field, this.value);
    }
}

