/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.model;

import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketAttributes;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.ticketmanager.internal.IDGenerator;
import com.inet.helpdesk.ticketmanager.model.OperationChangedTicketImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class OperationModelImpl
implements TicketOperationModel {
    private List<OperationChangedTicket> changedTickets = new ArrayList<OperationChangedTicket>();
    private IDGenerator idGenerator;

    public OperationModelImpl(IDGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    @Override
    public List<OperationChangedTicket> getChangedTickets() {
        return this.changedTickets;
    }

    @Override
    public OperationChangedTicket changeExistingTicket(int ticketId) {
        TicketVO vo = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (vo == null) {
            throw new IllegalArgumentException("Ticket does not exist: " + ticketId);
        }
        return this.changeExistingTicket(vo);
    }

    @Override
    public OperationChangedTicket changeExistingTicket(TicketVO vo) {
        Optional<OperationChangedTicket> first = this.changedTickets.stream().filter(t -> !t.isNew() && t.getOldTicket().get().getID() == vo.getID()).findFirst();
        if (first.isPresent()) {
            return first.get();
        }
        OperationChangedTicket ticket = OperationChangedTicketImpl.createForTicket(vo, this);
        this.changedTickets.add(ticket);
        return ticket;
    }

    @Override
    public OperationChangedTicket createNewTicket(MutableTicketData ticketData, MutableTicketAttributes attributes) {
        OperationChangedTicket ticket = OperationChangedTicketImpl.createForNewTicket(ticketData, attributes, this);
        this.changedTickets.add(ticket);
        return ticket;
    }

    public IDGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public String toString() {
        return "ChangedTickets: " + this.changedTickets.toString();
    }
}

