/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager.access;

import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.BundleBehavior;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketActionChecker;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.core.ticketmanager.extension.TicketActionExtensionFactory;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.ticketmanager.TicketReaderImpl;
import com.inet.helpdesk.ticketmanager.access.TicketPermissionCheckerImpl;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldSettings;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.UserField;
import com.inet.usersandgroups.api.UserGroupField;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import srv.mail.Mail;

public class TicketActionCheckerImpl
implements TicketActionChecker {
    private TicketPermissionCheckerImpl ticketPermissionChecker;
    private TicketReaderImpl readDAO = null;
    private static final ConfigValue<BundleBehavior> BUNDLE_BEHAVIOR_VALUE = new ConfigValue(HDConfigKeys.BUNDLE_BEHAVIOR);

    public TicketActionCheckerImpl(TicketReaderImpl readDAO, TicketPermissionCheckerImpl permissionChecker) {
        this.readDAO = readDAO;
        this.ticketPermissionChecker = permissionChecker;
    }

    @Override
    public List<ActionVO> getAllPossibleActionsForTicket(int ticketid) {
        TicketPermissionContext ticketPermissionInfo = this.ticketPermissionChecker.getTicketPermissionInfo(ticketid);
        if (ticketPermissionInfo == null) {
            return null;
        }
        TicketVO ticket = this.readDAO.getTicket(ticketid, ticketPermissionInfo);
        ArrayList<ActionVO> possibleActions = new ArrayList<ActionVO>();
        List actions = ActionManager.getInstance().getAll(true);
        HDLogger.debug("Actions available " + actions.size());
        List extensionFactories = ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class);
        for (TicketActionExtensionFactory ticketActionExtensionFactory : extensionFactories) {
            List<ActionVO> result = ticketActionExtensionFactory.additionalActionsForTicket(ticket);
            actions.addAll(result);
        }
        UserRole userrole = this.determineUserRole(ticket, ticketPermissionInfo);
        for (ActionVO actionVO : actions) {
            if (this.checkAction(actionVO, ticket, ticketPermissionInfo) == null) {
                HDLogger.debug("Action Add: " + actionVO.getDisplayValue() + " internal: " + actionVO.isInternal() + " hidden: " + actionVO.isHidden() + " deleted: " + actionVO.isDeleted());
                possibleActions.add(actionVO);
                continue;
            }
            HDLogger.debug("Action not available: " + actionVO.getDisplayValue() + " " + userrole);
        }
        return possibleActions;
    }

    public ActionCheckError checkAction(ActionVO action, int ticketid, TicketPermissionContext ticketPermissionInfo) {
        TicketVO ticket = this.readDAO.getTicket(ticketid, ticketPermissionInfo);
        if (ticket == null) {
            throw new IllegalArgumentException("Ticket does not exists: " + ticketid);
        }
        return this.checkAction(action, ticket, ticketPermissionInfo);
    }

    private ActionCheckError createTicketSettingMismatchError(String messageKey, Object ... params) {
        return ActionCheckError.createForTicketSettingMismatch(Tickets.MSG.getMsg(messageKey, params));
    }

    private ActionCheckError createAccessDeniedError(String messageKey, Object ... params) {
        return ActionCheckError.createForAccessDenied(Tickets.MSG.getMsg(messageKey, params));
    }

    private ActionCheckError createAccessDeniedErrorActionNotForUser(String actionName) {
        return this.createAccessDeniedError("actionchecker.actionNotForEnduser", actionName);
    }

    private ActionCheckError createAccessDeniedErrorNotModifyInquiry(Integer ticketid) {
        return this.createAccessDeniedError("actionchecker.notModifyInquiry", ticketid);
    }

    private ActionCheckError createIllegalTicketStateError(String messageKey, Object ... params) {
        return ActionCheckError.createForIllegalTicketState(Tickets.MSG.getMsg(messageKey, params));
    }

    private ActionCheckError createIllegalTicketStateErrorForTicketNotOpen(Integer ticketid) {
        return this.createIllegalTicketStateError("actionchecker.ticketNotOpen", ticketid);
    }

    private ActionCheckError createIllegalTicketStateErrorTicketMustNotBeSlave(String actionName, Integer ticketid) {
        return this.createIllegalTicketStateError("actionchecker.ticketMustNotBeSlave", actionName, ticketid);
    }

    @Override
    public ActionCheckError checkAction(ActionVO action, @Nonnull TicketVO ticket, TicketPermissionContext ticketPermissionInfo) {
        int ticketid = ticket.getID();
        if (action == null) {
            return ActionCheckError.createForIllegalArgument(Tickets.MSG.getMsg("error.actionNotSpecified", new Object[0]));
        }
        if (ticketPermissionInfo == null) {
            return ActionCheckError.createForIllegalArgument(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{ticketid}));
        }
        if (UserManager.getInstance().getCurrentUserAccount() == null) {
            return ActionCheckError.createForNotLoggedIn("Login required");
        }
        String actionName = action.getDisplayValue();
        if (action.isDeleted()) {
            return this.createTicketSettingMismatchError("actionchecker.actionIsDeleted", actionName);
        }
        String result = null;
        List extensionFactories = ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class);
        for (TicketActionExtensionFactory ticketActionExtensionFactory : extensionFactories) {
            result = ticketActionExtensionFactory.checkActionPreconditions(ticket, action, ticketPermissionInfo);
            if (result == null) continue;
            return ActionCheckError.createForIllegalTicketState(result);
        }
        if (!this.checkCurrentUserHasPermissionToExecuteAction(action.getId())) {
            return this.createAccessDeniedError("actionchecker.userHasNoPermissionForAction", actionName);
        }
        UserRole userrole = this.determineUserRole(ticket, ticketPermissionInfo);
        if (userrole == UserRole.none) {
            return this.createAccessDeniedError("actionchecker.ticketNoWriteAccess", ticketid);
        }
        block0 : switch (action.getId()) {
            case 4: {
                switch (userrole) {
                    case privileged: {
                        break block0;
                    }
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case -6: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!this.checkTicketIsClosed(ticket) || ServerOptions.isOptionSet(32)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                }
                break;
            }
            case -21: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!this.checkTicketIsClosed(ticket) || ServerOptions.isOptionSet(32)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                }
                break;
            }
            case -14: {
                switch (userrole) {
                    case privileged: {
                        break block0;
                    }
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case 5: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!ticket.isInquiry()) {
                            return this.createIllegalTicketStateError("actionchecker.ticketNotAnInquiry", ticketid);
                        }
                        if (this.ticketPermissionChecker.isDispatcher()) break block0;
                        return this.createAccessDeniedError("actionchecker.authorizeAsDispatcher", ticketid);
                    }
                    case dispatcher: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 1: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 2: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateError("actionchecker.slavesCanNotBeClosedOrDeleted", new Object[0]);
                    }
                    case dispatcher: {
                        if (!Status.isClosedOrDeletedStatus(ticket.getStatusID())) break block0;
                        return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                    }
                    case enduser: {
                        if (Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                        }
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateError("actionchecker.slavesCanNotBeClosedOrDeleted", new Object[0]);
                        }
                        if (!ticket.isMasterInBundle()) break block0;
                        return this.createAccessDeniedError("actionchecker.endusersNotCloseTicketInBundles", new Object[0]);
                    }
                }
                break;
            }
            case -10: {
                GUID resourceID;
                switch (userrole) {
                    case supporter: {
                        if (this.checkTicketIsClosed(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        resourceID = ticket.getResourceID();
                        if (resourceID != null) {
                            if (this.ticketPermissionChecker.checkCanChangeOwnerInTicket(ticketid)) break block0;
                            return this.createTicketSettingMismatchError("actionchecker.noUserChangeInResource", ticketid);
                        }
                        return this.createIllegalTicketStateError("actionchecker.noResourceForTicket", ticketid);
                    }
                    case privileged: 
                    case dispatcher: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -31: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -1: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -17: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                        }
                        if (userrole != UserRole.privileged) break block0;
                        break;
                    }
                    case dispatcher: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -5: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    default: {
                        return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
                    }
                }
            }
            case -22: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!Status.isClosedOrDeletedStatus(ticket.getStatusID()) || ServerOptions.isOptionSet(32)) break block0;
                        return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -7: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        ConfigValue mail_host = new ConfigValue(ConfigKey.MAIL_SMTPHOST);
                        if (mail_host.get() != null && !((String)mail_host.get()).trim().isEmpty()) break block0;
                        return this.createTicketSettingMismatchError("actionchecker.noSmtpHostConfigured", new Object[0]);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -23: 
            case -11: 
            case -9: {
                switch (userrole) {
                    case privileged: {
                        break block0;
                    }
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case -13: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (ticket.isMasterInBundle()) break block0;
                        return this.createIllegalTicketStateError("actionchecker.ticketNotMaster", ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 6: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    default: {
                        return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
                    }
                }
            }
            case -15: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (this.checkTicketIsClosed(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -28: 
            case -27: 
            case -26: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -12: {
                if (Status.isDeletedStatus(ticket.getStatusID())) {
                    return this.createAccessDeniedError("actionchecker.ticketAlreadyDeleted", ticketid);
                }
                switch (userrole) {
                    case dispatcher: 
                    case supporter: {
                        if (!ticketPermissionInfo.isTicketOwner()) {
                            return this.createAccessDeniedError("actionchecker.onlyEnduserComment", ticketid);
                        }
                    }
                    case privileged: 
                    case enduser: {
                        if (!Status.isClosedStatus(ticket.getStatusID())) break block0;
                        if (ticket.getStatusID() >= 360 && ticket.getStatusID() <= 364) {
                            return this.createIllegalTicketStateError("actionchecker.noReactivateOnClosedTicket", ticketid);
                        }
                        if (ticket.getStatusID() >= 365 && ticket.getStatusID() <= 369 && !this.ticketPermissionChecker.isDispatcher()) {
                            return this.createAccessDeniedError("actionchecker.reactivateOnClosedTicketAsDispatcher", ticketid);
                        }
                        if (!TicketActionCheckerImpl.isReactivationTimeExpired(ticket, System.currentTimeMillis())) break block0;
                        return this.createIllegalTicketStateError("actionchecker.noCommentOnClosedTicketAnymore", ticketid);
                    }
                }
                break;
            }
            case 7: {
                switch (userrole) {
                    case supporter: {
                        UserGroupInfo res;
                        GUID resID = ticket.getResourceID();
                        if (resID != null && (res = UserGroupManager.getInstance().getGroup(ticket.getResourceID())) != null && !ResourceFieldSettings.isSet((Integer)res.getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS), 1)) {
                            return this.createTicketSettingMismatchError("actionchecker.resourceDeleteTicketDisabledInConfig", new Object[0]);
                        }
                        if ((ticket.getStatusID() >= 365 && ticket.getStatusID() <= 369 || ticket.isInquiry()) && !this.ticketPermissionChecker.isDispatcher()) {
                            return this.createAccessDeniedError("actionchecker.reactivateOnClosedTicketAsDispatcher", ticketid);
                        }
                    }
                    case privileged: {
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateError("actionchecker.slavesCanNotBeClosedOrDeleted", new Object[0]);
                        }
                    }
                    case dispatcher: {
                        if (Status.isDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyDeleted", ticketid);
                        }
                        if (ticket.getStatusID() < 360 || ticket.getStatusID() > 364) break block0;
                        return this.createIllegalTicketStateError("actionchecker.noReactivateOnClosedTicket", ticketid);
                    }
                    case enduser: {
                        if (Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketid);
                        }
                        if (ticket.isSlaveInBundle()) {
                            return this.createIllegalTicketStateError("actionchecker.slavesCanNotBeClosedOrDeleted", new Object[0]);
                        }
                        if (ticket.isMasterInBundle()) {
                            return this.createIllegalTicketStateError("actionchecker.endusersNotCloseOrDeleteTicketInBundles", new Object[0]);
                        }
                        if (ticket.getStatusID() < 360 || ticket.getStatusID() > 369) break block0;
                        return this.createAccessDeniedError("actionchecker.reactivateOnClosedTicketAsDispatcher", ticketid);
                    }
                }
                break;
            }
            case 8: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 3: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (this.checkTicketIsClosed(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -19: {
                break;
            }
            case -18: {
                break;
            }
            case -2: {
                switch (userrole) {
                    case supporter: 
                    case enduser: {
                        if (ticket.getStatusID() >= 365 && ticket.getStatusID() <= 369 && !this.ticketPermissionChecker.isDispatcher()) {
                            return this.createAccessDeniedError("actionchecker.reactivateOnClosedTicketAsDispatcher", ticketid);
                        }
                    }
                    case privileged: 
                    case dispatcher: {
                        if (!Status.isClosedOrDeletedStatus(ticket.getStatusID())) {
                            return this.createIllegalTicketStateError("actionchecker.ticketMustBeClosedOrDeleted", ticketid);
                        }
                        if (ticket.getStatusID() < 360 || ticket.getStatusID() > 364) break block0;
                        return this.createIllegalTicketStateError("actionchecker.noReactivateOnClosedTicket", ticketid);
                    }
                }
                break;
            }
            case -30: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -16: {
                GUID resourceID;
                switch (userrole) {
                    case privileged: {
                        UserGroupInfo ressourceGroup;
                        Integer resSettingsBitMask;
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        resourceID = ticket.getResourceID();
                        if (resourceID == null || ResourceFieldSettings.isSet(resSettingsBitMask = (Integer)(ressourceGroup = UserGroupManager.getInstance().getGroup(resourceID)).getValue((UserGroupField)HDUsersAndGroups.RES_FIELD_SETTINGS), 8) || ResourceFieldSettings.isSet(resSettingsBitMask, 40) || ResourceFieldSettings.isSet(resSettingsBitMask, 16) || ResourceFieldSettings.isSet(resSettingsBitMask, 48)) break block0;
                        return this.createTicketSettingMismatchError("actionchecker.noStopuhrInResource", ressourceGroup.getDisplayName(), ticketid);
                    }
                    default: {
                        return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
                    }
                }
            }
            case -25: {
                if (ticket.isSlaveInBundle()) {
                    return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                }
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (ticket.getValue(Tickets.FIELD_WIEDERVORLAGEDATE) == null && ticket.getValue(Tickets.FIELD_TERMINVEREINBARUNG) == null) {
                            return this.createIllegalTicketStateError("actionchecker.terminEntfernenOnlyIfTermin", ticketid);
                        }
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                    default: {
                        return this.createAccessDeniedError("actionchecker.ticketNoWriteAccess", ticketid);
                    }
                }
            }
            case 10: {
                if (ticket.isSlaveInBundle()) {
                    return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                }
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -29: {
                switch (userrole) {
                    case privileged: 
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        if (!this.checkTicketIsClosed(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case 9: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -24: {
                switch (userrole) {
                    case privileged: {
                        break block0;
                    }
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case -3: {
                switch (userrole) {
                    case privileged: {
                        if (ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case dispatcher: {
                        return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -8: {
                switch (userrole) {
                    default: 
                }
                return this.createAccessDeniedError("actionchecker.onlyPrivilegedExecuteAction", ticketid);
            }
            case -20: {
                if (ticket.isSlaveInBundle()) {
                    return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                }
                switch (userrole) {
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        if (this.checkTicketIsOpen(ticket)) break block0;
                        return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
                break;
            }
            case -33: {
                switch (userrole) {
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                    case privileged: 
                    case dispatcher: 
                    case supporter: {
                        break block0;
                    }
                }
                break;
            }
            default: {
                switch (userrole) {
                    case privileged: 
                    case dispatcher: {
                        if (action.getId() >= 0 && ticket.isInquiry()) {
                            return this.createAccessDeniedErrorNotModifyInquiry(ticketid);
                        }
                    }
                    case supporter: {
                        if (!this.checkTicketIsOpen(ticket)) {
                            return this.createIllegalTicketStateErrorForTicketNotOpen(ticketid);
                        }
                        if (!ticket.isSlaveInBundle()) break block0;
                        int folgeStatus = action.getStatusID();
                        if (!action.isInternal() && (folgeStatus > 100 || folgeStatus == -100) && folgeStatus < 300 && folgeStatus != 150) break block0;
                        return this.createIllegalTicketStateErrorTicketMustNotBeSlave(actionName, ticketid);
                    }
                    case enduser: {
                        return this.createAccessDeniedErrorActionNotForUser(actionName);
                    }
                }
            }
        }
        return null;
    }

    private UserRole determineUserRole(TicketVO ticket, TicketPermissionContext ticketPermissionInfo) {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account != null && Objects.equals(UserManager.PRIVILEGED_ACCOUNT_ID, account.getID())) {
            return UserRole.privileged;
        }
        if (ticket.isInquiry() && ticketPermissionInfo.hasDispatcherAccessToTicket()) {
            return UserRole.dispatcher;
        }
        if (ticketPermissionInfo.getSupporterPermissions() == TicketPermissionContext.SupporterPermission.READWRITE) {
            return UserRole.supporter;
        }
        if (ticketPermissionInfo.isTicketOwner()) {
            return UserRole.enduser;
        }
        return UserRole.none;
    }

    @Override
    public ActionCheckError checkAction(ActionVO action, int ticketid) {
        return this.checkAction(action, ticketid, this.ticketPermissionChecker.getTicketPermissionInfo(ticketid));
    }

    private boolean checkTicketIsClosed(TicketVO ticket) {
        return Status.isClosedOrDeletedStatus(ticket.getStatusID());
    }

    private boolean checkTicketIsOpen(TicketVO ticket) {
        return Status.isOpenStatus(ticket.getStatusID());
    }

    private boolean checkSupporterWriteAccess(TicketPermissionContext ticketPermissionInfo) {
        return ticketPermissionInfo.getSupporterPermissions() == TicketPermissionContext.SupporterPermission.READWRITE;
    }

    @Override
    public ActionCheckError checkAktionBuendeln(int masterid, List<Integer> slaveTicketIDs) {
        return this.checkAktionBuendeln(masterid, slaveTicketIDs, this.ticketPermissionChecker.getTicketPermissionInfo(masterid));
    }

    public ActionCheckError checkAktionBuendeln(int masterid, List<Integer> slaveTicketIDs, TicketPermissionContext ticketPermissionInfo) throws IllegalArgumentException {
        if (ticketPermissionInfo == null) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{masterid}));
        }
        if (slaveTicketIDs == null) {
            throw new IllegalArgumentException("list of ticket IDs must not be null");
        }
        if (slaveTicketIDs.contains(null)) {
            throw new IllegalArgumentException("list of ticket IDs must not contain null");
        }
        if (slaveTicketIDs.isEmpty()) {
            throw new IllegalArgumentException("list of ticket IDs must not be empty");
        }
        if (slaveTicketIDs.contains(masterid)) {
            throw new IllegalArgumentException(String.format("tickets can not be bundled with themself, ticketID=\"%d\".", masterid));
        }
        ActionCheckError error = this.checkAction((ActionVO)ActionManager.getInstance().get(-1), masterid);
        if (error != null) {
            return error;
        }
        ArrayList<TicketVO> masterTicket = new ArrayList<TicketVO>();
        masterTicket.add(TicketManager.getReader().getTicket(masterid));
        for (Integer slaveid : slaveTicketIDs) {
            ItilVO itil;
            error = this.checkAction((ActionVO)ActionManager.getInstance().get(-1), slaveid);
            if (error != null) {
                return error;
            }
            TicketVO slaveticket = this.readDAO.getTicket(slaveid, this.ticketPermissionChecker.getTicketPermissionInfo(slaveid));
            masterTicket.add(slaveticket);
            if (slaveticket.getWorkflowID() != null) {
                return this.createIllegalTicketStateError("actionchecker.cannotBundleWorkflowTicketAsSlave", slaveid);
            }
            if (slaveticket.getValue(Tickets.FIELD_ITIL_ID) == null || (itil = (ItilVO)ItilManager.getInstance().get(slaveticket.getValue(Tickets.FIELD_ITIL_ID))) == null || !itil.isMasterType()) continue;
            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyItilMaster", slaveid);
        }
        BundleBehavior bundleBehavior = (BundleBehavior)((Object)BUNDLE_BEHAVIOR_VALUE.get());
        switch (bundleBehavior) {
            case sameEmailDomainOnly: {
                ArrayList<String[]> allEmails = new ArrayList<String[]>();
                boolean allSameUser = true;
                GUID initialUserGuid = null;
                boolean alreadySetInitialUserGuid = false;
                for (TicketVO s : masterTicket) {
                    GUID o = s.getOwnerID();
                    if (!alreadySetInitialUserGuid) {
                        initialUserGuid = o;
                        alreadySetInitialUserGuid = true;
                    } else if (initialUserGuid != null && o == null || initialUserGuid == null && o != null || initialUserGuid != null && !initialUserGuid.equals((Object)o)) {
                        allSameUser = false;
                    }
                    String email = o == null ? null : (String)UserManager.getInstance().getUserAccount(o).getValue((UserField)UsersAndGroups.FIELD_EMAIL);
                    String[] addresses = Mail.convertToAddressArray(email);
                    allEmails.add(addresses);
                }
                if (allSameUser) {
                    return null;
                }
                String[] masterEmails = (String[])allEmails.get(0);
                boolean sameDomainFound = false;
                for (String emailToTry : masterEmails) {
                    String domainPartToTry = emailToTry.substring(emailToTry.lastIndexOf(64));
                    boolean foundThisDomainInAllUsers = true;
                    for (String[] userEmails : allEmails) {
                        boolean foundForThisUser = false;
                        for (String userEmail : userEmails) {
                            if (!userEmail.endsWith(domainPartToTry)) continue;
                            foundForThisUser = true;
                            break;
                        }
                        if (foundForThisUser) continue;
                        foundThisDomainInAllUsers = false;
                        break;
                    }
                    if (!foundThisDomainInAllUsers) continue;
                    sameDomainFound = true;
                    break;
                }
                if (sameDomainFound) break;
                return this.createIllegalTicketStateError("actionchecker.bundleNotSameDomain", new Object[0]);
            }
            case sameLocationOnly: {
                Integer loc = null;
                boolean alreadySetInitialLocation = false;
                for (TicketVO s : masterTicket) {
                    GUID o = s.getOwnerID();
                    if (!alreadySetInitialLocation) {
                        loc = o == null ? null : (Integer)UserManager.getInstance().getUserAccount(o).getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                        alreadySetInitialLocation = true;
                        continue;
                    }
                    Integer l = o == null ? null : (Integer)UserManager.getInstance().getUserAccount(o).getValue((UserField)HDUsersAndGroups.FIELD_LOCATION_ID);
                    if (Objects.equals(loc, l)) continue;
                    return this.createIllegalTicketStateError("actionchecker.bundleNotSameLocation", new Object[0]);
                }
                break;
            }
            case sameOwnerOnly: {
                GUID owner = null;
                boolean alreadySetInitialOwner = false;
                for (TicketVO s : masterTicket) {
                    GUID o = s.getOwnerID();
                    if (!alreadySetInitialOwner) {
                        owner = o;
                        alreadySetInitialOwner = true;
                        continue;
                    }
                    if (Objects.equals(owner, o)) continue;
                    return this.createIllegalTicketStateError("actionchecker.bundleNotSameOwner", new Object[0]);
                }
                break;
            }
        }
        return null;
    }

    @Override
    public ActionCheckError checkAktionEditReastepText(int reaid) {
        return this.checkAktionEditReastepText(reaid, null);
    }

    public ActionCheckError checkAktionEditReastepText(int reaid, TicketPermissionContext context) throws IllegalArgumentException {
        ReaStepVO reaVo = TicketManager.getReaderForSystem().getReaStep(reaid);
        if (reaVo == null) {
            throw new IllegalArgumentException("ReaStep does not exists: " + reaid);
        }
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(reaVo.getBunID());
        return this.checkAction((ActionVO)ActionManager.getInstance().get(-22), ticket.getID());
    }

    @Override
    public ActionCheckError checkAktionUpdateTicketData(int ticketId) {
        return this.checkAktionUpdateTicketData(ticketId, null);
    }

    @Override
    public ActionCheckError checkAktionUpdateTicketData(int ticketId, MutableTicketData fields) {
        TicketVO ticket = this.readDAO.getTicket(ticketId, this.ticketPermissionChecker.getTicketPermissionInfo(ticketId));
        return this.checkAktionUpdateTicketData(ticket, fields);
    }

    @Override
    public ActionCheckError checkAktionUpdateTicketData(TicketVO ticket, MutableTicketData fields) {
        int ticketId = ticket.getID();
        TicketPermissionContext ticketPermissionInfo = this.ticketPermissionChecker.getTicketPermissionInfo(ticket);
        if (ticketPermissionInfo == null) {
            throw new IllegalArgumentException(Tickets.MSG.getMsg("error.ticketDoesNotExist", new Object[]{ticketId}));
        }
        if (!this.checkSupporterWriteAccess(ticketPermissionInfo) && !ticketPermissionInfo.isDispatcher()) {
            return this.createAccessDeniedError("actionchecker.ticketNoWriteAccess", ticketId);
        }
        if (Status.isClosedOrDeletedStatus(ticket.getStatusID()) && !HDUsersAndGroups.isPrivilegedUser(UserManager.getInstance().getCurrentUserAccountID())) {
            return this.createIllegalTicketStateError("actionchecker.ticketAlreadyClosedOrDeleted", ticketId);
        }
        if (ticket.isSlaveInBundle()) {
            return this.createIllegalTicketStateError("actionchecker.updateTicketDataNotForSlave", ticketId);
        }
        if (fields == null) {
            return null;
        }
        ActionCheckError msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_PRIORITY_ID, 3, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_ITIL_ID, -15, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_DEADLINE, -17, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CATEGORY_ID, -26, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_OWNER_GUID, -10, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CLASSIFICATION_ID, -28, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_IDENTIFIER, -27, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_SUBJECT, -31, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_TARGET_TIME, -30, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CUSTOM_1, -29, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CUSTOM_2, -29, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CUSTOM_3, -29, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CUSTOM_4, -29, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CUSTOM_5, -29, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CUSTOM_6, -29, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        msg = this.checkIfFieldIsChangedAndNotAllowed(ticket, fields, Tickets.FIELD_CUSTOM_7, -29, ticketPermissionInfo);
        if (msg != null) {
            return msg;
        }
        return null;
    }

    private ActionCheckError checkIfFieldIsChangedAndNotAllowed(TicketVO ticket, MutableTicketData fields, TicketField<?> fieldToChange, int requiredActionId, TicketPermissionContext permissionInfo) {
        if (fields.containsKey(fieldToChange)) {
            ActionVO action = (ActionVO)ActionManager.getInstance().get(requiredActionId);
            ActionCheckError msg = TicketManager.getTicketActionChecker().checkAction(action, ticket, permissionInfo);
            if (msg != null) {
                return ActionCheckError.createForGivenCode(Tickets.MSG.getMsg("actionchecker.cannotChangeFieldValue", new Object[0]) + " " + msg.getErrorMessage(), msg.getErrorCode());
            }
        }
        return null;
    }

    @Override
    public ActionVO getActionByUniqueID(String uniqueID, int ticketId) {
        List actions = ActionManager.getInstance().getAll(false);
        for (ActionVO actionVO : actions) {
            if (!actionVO.getUniqueID().equals(uniqueID)) continue;
            return actionVO;
        }
        TicketVO ticket = TicketManager.getReaderForSystem().getTicket(ticketId);
        if (ticket == null) {
            return null;
        }
        for (TicketActionExtensionFactory ticketActionExtensionFactory : ServerPluginManager.getInstance().get(TicketActionExtensionFactory.class)) {
            List<ActionVO> result = ticketActionExtensionFactory.additionalActionsForTicket(ticket);
            for (ActionVO actionVO : result) {
                if (!actionVO.getUniqueID().equals(uniqueID)) continue;
                return actionVO;
            }
        }
        return null;
    }

    @Override
    public boolean checkCurrentUserHasPermissionToExecuteAction(int actionId) {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        if (account == null || !account.isActive()) {
            HDLogger.debug("ActionChecker: Account is not active");
            return false;
        }
        if (account.getAccountType() == UserAccountType.Administrator) {
            return true;
        }
        if (((Set)account.getValue((UserField)HDUsersAndGroups.FIELD_ALLOWED_ACTIONS)).contains(actionId)) {
            return true;
        }
        for (UserGroupInfo group : UserGroupManager.getInstance().getGroupsForUser(account.getID())) {
            HDLogger.debug("ActionChecker: check group:" + group.getDisplayName() + " " + group.getValue((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS));
            if (!group.isActive()) continue;
            if (group.getID().equals((Object)UsersAndGroups.GROUPID_ADMIN)) {
                return true;
            }
            if (!((Set)group.getValue((UserGroupField)HDUsersAndGroups.GROUP_FIELD_ALLOWED_ACTIONS)).contains(actionId)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReactivationTimeExpired(TicketVO ticket, long timeToCompare) {
        int days;
        ConfigValue ticket_react_time = new ConfigValue(HDConfigKeys.DEFAULT_TICKET_REACTIVATION_TIME);
        Long closeDate = ticket.getAttribute(Tickets.ATTRIBUTE_CLOSE_DATE);
        return ticket_react_time.get() != null && closeDate != null && (days = (int)((timeToCompare - closeDate) / 86400000L)) > (Integer)ticket_react_time.get();
    }

    @Override
    public Set<Integer> getEffectiveAllowedActionsForCurrentUser() {
        UserAccount account = UserManager.getInstance().getCurrentUserAccount();
        return HDUsersAndGroups.getEffectiveAllowedActionsForUser(account);
    }

    public ActionCheckError checkCreateNewTicket(@Nullable ExtensionArguments extensionArgs) {
        if (extensionArgs != null && extensionArgs.containsExtArg(ExtensionArguments.EXTARG_EMAIL_DATA)) {
            return null;
        }
        if (!this.checkCurrentUserHasPermissionToExecuteAction(4)) {
            return ActionCheckError.createForAccessDenied(Tickets.MSG.getMsg("actionchecker.createTicketNotAllowed", new Object[0]));
        }
        return null;
    }

    private static enum UserRole {
        none,
        enduser,
        dispatcher,
        supporter,
        privileged;

    }
}

