/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerOptions;
import com.inet.helpdesk.core.model.general.Sorting;
import com.inet.helpdesk.core.ticketmanager.PluggableTicketSearchTag;
import com.inet.helpdesk.core.ticketmanager.ReaStepEmailAddresses;
import com.inet.helpdesk.core.ticketmanager.SlaveInfo;
import com.inet.helpdesk.core.ticketmanager.TicketEmailSenderInformation;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.resource.ResourceManager;
import com.inet.helpdesk.core.ticketmanager.model.BundleStepsFilter;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSlaveForEnduser;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ReaStepEmailUsersVO;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.TextSearchParameters;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.TicketSearchFilterOptions;
import com.inet.helpdesk.core.ticketmanager.model.tickets.SearchTagTicketTags;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketAttribute;
import com.inet.helpdesk.core.ticketmanager.model.tickets.TicketField;
import com.inet.helpdesk.shared.model.general.ContextType;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.internal.CachedTicketSorter;
import com.inet.helpdesk.ticketmanager.internal.ReaStepEmailUsersCreator;
import com.inet.helpdesk.ticketmanager.search.SearchTagBundleSlave;
import com.inet.helpdesk.ticketmanager.search.SearchTagWorkflowSlave;
import com.inet.helpdesk.ticketmanager.search.TicketSearchDataCache;
import com.inet.helpdesk.ticketmanager.search.TicketSearchEngine;
import com.inet.id.GUID;
import com.inet.plugin.ServerPluginManager;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.OrSearchExpression;
import com.inet.search.command.PrefilteredSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SubtractSearchExpression;
import com.inet.search.index.IndexSearchEngine;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class TicketReaderImpl {
    private final TicketReadDAO readDAO;
    private final TicketSearchDataCache searchDataCache;
    private final TicketSearchEngine searchEngine;

    public TicketReaderImpl(TicketReadDAO readDAO, TicketSearchDataCache searchDataCache, TicketSearchEngine searchEngine) {
        if (readDAO == null) {
            throw new IllegalArgumentException("DAO must not be null");
        }
        if (searchDataCache == null) {
            throw new IllegalArgumentException("search data cache must not be null");
        }
        if (searchEngine == null) {
            throw new IllegalArgumentException("search engine must not be null");
        }
        this.readDAO = readDAO;
        this.searchDataCache = searchDataCache;
        this.searchEngine = searchEngine;
    }

    public void init() {
        ServerPluginManager spm = ServerPluginManager.getInstance();
        List ticketAttributes = spm.get(TicketAttribute.class);
        List ticketFields = spm.get(TicketField.class);
        List pluggableTicketSearchTags = spm.get(PluggableTicketSearchTag.class);
        List ticketTags = spm.get(SearchTagTicketTags.TicketTag.class);
        this.searchDataCache.init(this.readDAO, ticketAttributes, ticketFields, pluggableTicketSearchTags, ticketTags);
    }

    public IndexSearchEngine<Integer> getSearchEngine() {
        return this.searchEngine.getSearchEngine();
    }

    public IndexSearchEngine<SlaveInfo> getSlaveInfoEngine() {
        return this.searchEngine.getSlaveInfoEngine();
    }

    public TicketVO getTicket(int ticketId, TicketPermissionContext context) {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketId);
        if (ticket == null) {
            return null;
        }
        this.throwIfContextIsNull(context);
        if (context.getSupporterPermissions() == TicketPermissionContext.SupporterPermission.NONE && ticket.isSlaveInBundle()) {
            TicketVOSingle master = this.readDAO.getTicket(ticket.getBundleID());
            if (master == null) {
                HDLogger.error(String.format("Master ticket %d of slave ticket %d does not exists!", ticket.getBundleID(), ticket.getID()));
                return null;
            }
            return TicketVOSlaveForEnduser.create(ticket, master);
        }
        return ticket;
    }

    private void throwIfContextIsNull(TicketPermissionContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null!");
        }
    }

    public ReaStepVO getReaStep(int reaStepID) {
        ReaStepVO reaStep = this.readDAO.getReaStep(reaStepID);
        return reaStep;
    }

    public ReaStepTextVO getReaStepText(int reaStepId) {
        ReaStepTextVO reaStepText = this.readDAO.getReaStepText(reaStepId);
        return reaStepText;
    }

    public List<ReaStepVO> getReaStepsForTicket(int ticketId, TicketPermissionContext context, BundleStepsFilter stepsFilter) {
        TicketVO ticket = this.getTicket(ticketId, context);
        if (ticket == null) {
            throw new IllegalArgumentException("Ticket does not exist: " + ticketId);
        }
        if (context.hasEnduserAccessToTicket()) {
            if (ticket.isUnbundled()) {
                return this.sortByID(this.filterStepsNotVisibleForEnduser(this.readDAO.getReaStepsForTicket(ticketId)));
            }
        } else if (ticket.isUnbundled() || stepsFilter == BundleStepsFilter.WITHOUT_BUNDLE_STEPS || ticket.isSlaveInBundle()) {
            return this.sortByID(this.readDAO.getReaStepsForTicket(ticketId));
        }
        List<ReaStepVO> stepsFromBundle = this.loadReaStepsFromBundle(ticket, context);
        if (context.hasEnduserAccessToTicket()) {
            return this.sortByID(this.filterStepsNotVisibleForEnduser(stepsFromBundle));
        }
        return this.sortByID(stepsFromBundle);
    }

    private List<ReaStepVO> sortByID(List<ReaStepVO> reaStepList) {
        Collections.sort(reaStepList, (o1, o2) -> Integer.valueOf(o2.getID()).compareTo(o1.getID()));
        return reaStepList;
    }

    private List<ReaStepVO> loadReaStepsFromBundle(TicketVO ticket, TicketPermissionContext context) {
        AtomicInteger idOfBundlingStep = new AtomicInteger(0);
        ArrayList<ReaStepVO> stepsFromBundle = new ArrayList<ReaStepVO>();
        List<TicketVOSingle> ticketsInBundle = this.readDAO.getTicketsInBundle(ticket.getBundleID(), true);
        for (TicketVOSingle ticketInBundle : ticketsInBundle) {
            List<ReaStepVO> reaStepsForTicket = this.readDAO.getReaStepsForTicket(ticketInBundle.getID());
            stepsFromBundle.addAll(reaStepsForTicket);
            if (ticketInBundle.getID() != ticket.getID() || !ticket.isSlaveInBundle()) continue;
            this.sortByID(reaStepsForTicket);
            Optional<ReaStepVO> first = reaStepsForTicket.stream().filter(step -> step.getActionID() == -1).findFirst();
            if (!first.isPresent()) continue;
            idOfBundlingStep.set(first.get().getID());
        }
        stepsFromBundle.removeIf(reaStep -> {
            if (reaStep.getOrgBunID() == ticket.getID()) {
                return false;
            }
            if (reaStep.getBunID() != ticket.getBundleID()) {
                return true;
            }
            if (context.hasEnduserAccessToTicket()) {
                if (!reaStep.isBundleVisible()) {
                    return true;
                }
                return reaStep.getID() < idOfBundlingStep.get();
            }
            return false;
        });
        return stepsFromBundle;
    }

    private List<ReaStepVO> filterStepsNotVisibleForEnduser(List<ReaStepVO> reaStepsForTicket) {
        ActionManager actionManager = ActionManager.getInstance();
        reaStepsForTicket.removeIf(step -> ((ActionVO)actionManager.get(step.getActionID())).isHidden());
        return reaStepsForTicket;
    }

    public List<TicketVOSingle> getTicketsInBundle(int bundleID, boolean includeMasterTicket) {
        return new ArrayList<TicketVOSingle>(this.readDAO.getTicketsInBundle(bundleID, includeMasterTicket));
    }

    public List<TicketVO> getTickets(Collection<Integer> ticketIds, boolean enduser) {
        ArrayList<TicketVO> result = new ArrayList<TicketVO>();
        for (TicketVOSingle ticket : this.readDAO.getTickets(ticketIds)) {
            if (enduser && ticket.isSlaveInBundle()) {
                TicketVOSingle master = this.readDAO.getTicket(ticket.getBundleID());
                if (master == null) {
                    HDLogger.error(String.format("Ticket %d is a slave ticket, but the master ticket of the bundle %d cannot be found.", ticket.getID(), ticket.getBundleID()));
                    continue;
                }
                result.add(TicketVOSlaveForEnduser.create(ticket, master));
                continue;
            }
            result.add(ticket);
        }
        return result;
    }

    @Deprecated
    public List<ReaStepEmailAddresses> getReaStepEmailAddresses(int ticketId) {
        return this.readDAO.getAllReaStepEmailAddresses(ticketId);
    }

    public ReaStepEmailUsersVO getReaStepEmailUsers(int stepID) {
        return ReaStepEmailUsersCreator.getReaStepEmailUsers(this.readDAO, stepID);
    }

    public List<TicketVO> findAllTicketsForUserGroups(List<Integer> groupIds, int numberOfTickets) {
        SearchCommand searchCmd = new SearchCommand("groupid", SearchCondition.SearchTermOperator.IN, groupIds);
        Set idsOfUsersInGroups = UserManager.getInstance().getSearchEngine().simpleSearch(searchCmd);
        SearchCommand command = new SearchCommand("ownerid", SearchCondition.SearchTermOperator.IN, (Object)idsOfUsersInGroups);
        command.setResultLimit(numberOfTickets);
        Set ticketIDs = this.getSearchEngine().simpleSearch(command);
        return this.getTickets(ticketIDs, true);
    }

    public List<TicketVO> findAllTicketsOwnedByUser(UserAccount user, int numberOfTickets) {
        if (user == null) {
            throw new IllegalArgumentException("User is null!");
        }
        AndSearchExpression searchExpression = new AndSearchExpression();
        searchExpression.add((SearchExpression)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.Equals, (Object)user.getID().toString()));
        searchExpression.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.GT, (Object)-200));
        searchExpression.add((SearchExpression)new SearchCondition("workflowslave", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagWorkflowSlave.valueAsInt(false)));
        SearchCommand command = new SearchCommand(new SearchExpression[]{searchExpression});
        command.setResultLimit(numberOfTickets);
        Set searchResult = this.getSearchEngine().simpleSearch(command);
        List<Integer> allTicketsOwnedByUser = searchResult.stream().limit(numberOfTickets).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        return this.getTickets(allTicketsOwnedByUser, true);
    }

    @Deprecated
    public List<TicketVO> findAllTicketsVisibleForUser(TicketSearchFilterOptions options, @Nullable Sorting sorting, ContextType context) {
        List<Integer> list = this.searchTicketsForUser(options);
        List<TicketVO> tickets = this.getTickets(list, context == ContextType.enduser);
        this.sortCachedTickets(tickets, sorting);
        return tickets;
    }

    public List<Integer> searchTicketsForUser(TicketSearchFilterOptions options) {
        return this.searchTicketsForUser(options, null);
    }

    public List<Integer> searchTicketsForUser(TicketSearchFilterOptions options, @Nullable TextSearchParameters params) {
        int limit;
        SearchCommand searchCommand = this.createSearchCommandFromOptions(options);
        if (params != null) {
            this.addTextSearchToCommand(searchCommand, params);
        }
        if ((limit = options.getNumOfTickets()) != -1) {
            searchCommand.setResultLimit(limit);
        }
        Set searchResult = this.getSearchEngine().simpleSearch(searchCommand);
        if (limit != -1) {
            return searchResult.stream().limit(limit).collect(Collectors.toList());
        }
        return new ArrayList<Integer>(searchResult);
    }

    private SearchCommand createSearchCommandFromOptions(TicketSearchFilterOptions options) {
        if (options == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        UserAccount currentAccount = UserManager.getInstance().getCurrentUserAccount();
        if (currentAccount == null) {
            throw new IllegalArgumentException("No user is logged in.");
        }
        AndSearchExpression searchExpression = new AndSearchExpression();
        GUID[] requestedResources = ResourceManager.getInstance().getResourceUUIDs(currentAccount, !options.isOnlyOwnResources());
        searchExpression.addAll(options.getTicketsToFind().getConditions(requestedResources));
        for (TicketSearchFilterOptions.FieldCondition cond : options.getFieldConditions()) {
            SearchExpression firstCondition = cond.getCondition();
            if (firstCondition == null) continue;
            searchExpression.add(firstCondition);
        }
        if (options.isTicketsBundled()) {
            searchExpression.add((SearchExpression)new SearchCondition("bundleslave", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagBundleSlave.FALSE));
        }
        if (!options.isShowWorkflowSlaves()) {
            searchExpression.add((SearchExpression)new SearchCondition("workflowslave", SearchCondition.SearchTermOperator.Equals, (Object)SearchTagWorkflowSlave.valueAsInt(false)));
        }
        if (options.getFrom() != null || options.getTo() != null) {
            OrSearchExpression orExpression = new OrSearchExpression();
            AndSearchExpression andInquiryDateExpression = new AndSearchExpression();
            if (options.getFrom() != null) {
                andInquiryDateExpression.add((SearchExpression)new SearchCondition("inquirydate", SearchCondition.SearchTermOperator.GE, (Object)options.getFrom()));
            }
            if (options.getTo() != null) {
                andInquiryDateExpression.add((SearchExpression)new SearchCondition("inquirydate", SearchCondition.SearchTermOperator.LE, (Object)options.getTo()));
            }
            orExpression.add((Object)andInquiryDateExpression);
            AndSearchExpression andEditedDateExpression = new AndSearchExpression();
            if (options.getFrom() != null) {
                andEditedDateExpression.add((SearchExpression)new SearchCondition("lastchanged", SearchCondition.SearchTermOperator.GE, (Object)options.getFrom()));
            }
            if (options.getTo() != null) {
                andEditedDateExpression.add((SearchExpression)new SearchCondition("lastchanged", SearchCondition.SearchTermOperator.LE, (Object)options.getTo()));
            }
            orExpression.add((Object)andEditedDateExpression);
            searchExpression.add((SearchExpression)orExpression);
        }
        int limit = options.getNumOfTickets();
        if (searchExpression.isEmpty()) {
            searchExpression.add((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        }
        if (options.isHideWiedervorlageTicketsAsConfigured() && ServerOptions.isOptionSet(0x20000000)) {
            searchExpression.add((SearchExpression)new SubtractSearchExpression((SearchExpression)new SearchCondition("statusid", SearchCondition.SearchTermOperator.Equals, (Object)150)));
        }
        SearchCommand command = new SearchCommand(new SearchExpression[]{searchExpression});
        if (limit != -1) {
            command.setResultLimit(limit);
        }
        return command;
    }

    private void addTextSearchToCommand(SearchCommand command, TextSearchParameters params) {
        String searchText = params.getSearchText();
        AndSearchExpression searchExpression = command.getSearchExpression();
        if (searchText != null) {
            searchText = this.removePlaceholders(searchText);
            OrSearchExpression orExpression = new OrSearchExpression();
            searchExpression.add((SearchExpression)orExpression);
            if (params.isSearchInTicketID()) {
                try {
                    int maybeTicketId = Integer.parseInt(searchText.trim());
                    orExpression.add((Object)new PrefilteredSearchExpression(Collections.singleton(maybeTicketId)));
                }
                catch (NumberFormatException maybeTicketId) {
                    // empty catch block
                }
            }
            if (params.isSearchInReaStepText()) {
                orExpression.add((Object)new SearchCondition("reasteptext", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isSearchInEmailAddress()) {
                SearchCommand emailSarchCmd = new SearchCommand("email", SearchCondition.SearchTermOperator.Contains, (Object)searchText);
                Set idsOfUsersWithEmailAddress = UserManager.getInstance().getSearchEngine().simpleSearch(emailSarchCmd);
                orExpression.add((Object)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)idsOfUsersWithEmailAddress));
            }
            if (params.isSearchInNachname()) {
                SearchCommand lastNameSarchCmd = new SearchCommand("lastname", SearchCondition.SearchTermOperator.Contains, (Object)searchText);
                Set idsOfUsersWithLastName = UserManager.getInstance().getSearchEngine().simpleSearch(lastNameSarchCmd);
                orExpression.add((Object)new SearchCondition("ownerid", SearchCondition.SearchTermOperator.IN, (Object)idsOfUsersWithLastName));
            }
            if (params.isSearchInRequest()) {
                orExpression.add((Object)new SearchCondition("reasteptext", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isSearchInSubject()) {
                orExpression.add((Object)new SearchCondition("subject", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isSpezFeld()) {
                orExpression.add((Object)new SearchCondition("identifier", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isBunFeld1()) {
                orExpression.add((Object)new SearchCondition("custom1", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isBunFeld2()) {
                orExpression.add((Object)new SearchCondition("custom2", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isBunFeld3()) {
                orExpression.add((Object)new SearchCondition("custom3", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isBunFeld4()) {
                orExpression.add((Object)new SearchCondition("custom4", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isBunFeld5()) {
                orExpression.add((Object)new SearchCondition("custom5", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isBunFeld6()) {
                orExpression.add((Object)new SearchCondition("custom6", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
            if (params.isBunFeld7()) {
                orExpression.add((Object)new SearchCondition("custom7", SearchCondition.SearchTermOperator.Contains, (Object)searchText));
            }
        }
    }

    private String removePlaceholders(String searchText) {
        return searchText.replace('*', ' ');
    }

    private void sortCachedTickets(List<TicketVO> tickets, @Nullable Sorting sorting) {
        if (sorting != null) {
            CachedTicketSorter sorter = new CachedTicketSorter(sorting);
            Collections.sort(tickets, sorter.getComparator());
        }
    }

    public int getIndexCount() {
        return this.getSearchEngine().getIndexCountOfIDs(Tickets.ATTRIBUTE_INQUIRY_DATE.getSearchTag());
    }

    public int getBunIdForTicketId(int ticketId) {
        return this.readDAO.getTicket(ticketId).getBundleID();
    }

    public List<TicketEmailSenderInformation> getSenderInformationForTicket(int ticketID) throws ServerDataException {
        return this.readDAO.getSenderInformationForTicket(ticketID);
    }
}

