/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.ticketmanager;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.error.HDErrors;
import com.inet.helpdesk.core.error.HelpDeskErrorCodes;
import com.inet.helpdesk.core.error.SQLExceptionWithErrorCode;
import com.inet.helpdesk.core.ticketmanager.ExtensionArguments;
import com.inet.helpdesk.core.ticketmanager.TicketManipulator;
import com.inet.helpdesk.core.ticketmanager.TicketManipulatorBackdoor;
import com.inet.helpdesk.core.ticketmanager.TicketPermissionChecker;
import com.inet.helpdesk.core.ticketmanager.extension.ExtensionUtils;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionManager;
import com.inet.helpdesk.core.ticketmanager.fields.action.ActionVO;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilManager;
import com.inet.helpdesk.core.ticketmanager.fields.itil.ItilVO;
import com.inet.helpdesk.core.ticketmanager.model.ActionCheckError;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepData;
import com.inet.helpdesk.core.ticketmanager.model.MutableReaStepText;
import com.inet.helpdesk.core.ticketmanager.model.MutableTicketData;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepTextVO;
import com.inet.helpdesk.core.ticketmanager.model.ReaStepVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketPermissionContext;
import com.inet.helpdesk.core.ticketmanager.model.TicketVO;
import com.inet.helpdesk.core.ticketmanager.model.TicketVOSingle;
import com.inet.helpdesk.core.ticketmanager.model.Tickets;
import com.inet.helpdesk.core.ticketmanager.model.argcontainers.ProcessingTime;
import com.inet.helpdesk.core.ticketmanager.model.events.domain.ChangedTicketVO;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationChangedTicket;
import com.inet.helpdesk.core.ticketmanager.model.operation.OperationNewReaStep;
import com.inet.helpdesk.core.ticketmanager.model.operation.TicketOperationModel;
import com.inet.helpdesk.core.utils.DatabaseTransactionUtils;
import com.inet.helpdesk.core.utils.SubListTaskExecutor;
import com.inet.helpdesk.logging.TicketEventLog;
import com.inet.helpdesk.shared.model.Status;
import com.inet.helpdesk.ticketmanager.TicketManipulatorInternal;
import com.inet.helpdesk.ticketmanager.TicketManipulatorSync;
import com.inet.helpdesk.ticketmanager.access.TicketActionCheckerImpl;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAO;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOCacheCleaner;
import com.inet.helpdesk.ticketmanager.dao.TicketReadDAOImpl;
import com.inet.helpdesk.ticketmanager.dao.TicketWriteDAO;
import com.inet.helpdesk.ticketmanager.internal.IDGenerator;
import com.inet.helpdesk.ticketmanager.internal.IndexUpdateAndEvents;
import com.inet.helpdesk.ticketmanager.internal.TicketChangeCollector;
import com.inet.helpdesk.ticketmanager.internal.TicketPreconditionChecks;
import com.inet.helpdesk.ticketmanager.model.OperationChangedReaStepImpl;
import com.inet.helpdesk.ticketmanager.model.OperationModelImpl;
import com.inet.helpdesk.ticketmanager.search.TicketDataForIndexingVO;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.id.GUID;
import com.inet.thread.ServerLock;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.Closeable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TicketManipulatorImpl
implements TicketManipulator,
TicketManipulatorBackdoor {
    private static final ConfigValue<Integer> DEFAULT_EMAIL_SEND_CLOSE_TIME = new ConfigValue(HDConfigKeys.DEFAULT_EMAIL_SEND_CLOSE_TIME);
    private static final int MAX_REA_STEP_COUNT_BEFORE_DOING_SPECIAL_HANDLING_OF_TICKET_DELETION = 1000;
    private final TicketManipulatorInternal manipulator;
    private TicketPermissionChecker permissionChecker;
    private TicketActionCheckerImpl actionChecker;
    private final TicketReadDAO readDAO;
    private final TicketWriteDAO writeDAO;
    private final IndexUpdateAndEvents indexUpdateAndEvents;
    private final IDGenerator idGenerator;
    private final ThreadLocal<Set<Integer>> ticketsBeingManipulatedByCurrentThread = new ThreadLocal<Set<Integer>>(){

        @Override
        protected Set<Integer> initialValue() {
            return new HashSet<Integer>();
        }
    };
    private final ThreadLocal<Boolean> ticketOperationNesting = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public TicketManipulatorImpl(@Nonnull TicketManipulatorInternal manipulator, TicketPermissionChecker permissionChecker, TicketActionCheckerImpl actionChecker, TicketReadDAO readDao, TicketWriteDAO writeDAO, IndexUpdateAndEvents indexUpdateAndEvent, IDGenerator idGenerator) {
        this.manipulator = manipulator;
        this.permissionChecker = permissionChecker;
        this.actionChecker = actionChecker;
        this.readDAO = readDao;
        this.writeDAO = writeDAO;
        this.indexUpdateAndEvents = indexUpdateAndEvent;
        this.idGenerator = idGenerator;
        indexUpdateAndEvent.registerListener(event -> {
            for (ChangedTicketVO changedTicket : event.getChangedTickets()) {
                int newStatusID;
                int oldStatusID;
                TicketVO oldData = changedTicket.getOldTicket();
                TicketVO newData = changedTicket.getNewTicket();
                if (oldData == null || newData == null || (oldStatusID = oldData.getStatusID()) == (newStatusID = newData.getStatusID()) || !Status.isClosedStatus(newStatusID)) continue;
                int itilID = newData.getItilID();
                ItilVO itil = (ItilVO)ItilManager.getInstance().get(itilID);
                if (itil == null) {
                    HDLogger.error("ITIL does not exists: " + itilID + " No ITIL slaves will be closed.");
                    continue;
                }
                if (!itil.isCloseSubOrders()) continue;
                UserAccountScope scope = UserAccountScope.createPrivileged();
                try {
                    this.closeItilSlaves(changedTicket.getTicketID());
                }
                finally {
                    if (scope == null) continue;
                    scope.close();
                }
            }
        });
    }

    @Override
    public void updateAttachmentFlag(int ticketID) {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        TicketPreconditionChecks.throwIfTicketDoesNotExists(ticket, ticketID);
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticket);){
            this.swingClientHackUpdateAttachmentFlag(ticketID);
        }
    }

    @Override
    public boolean updateReaStepTextWithoutCheckingServerOptions(int stepID, ReaStepTextVO text) {
        if (text == null) {
            throw new IllegalArgumentException("ReaStep's text must not be null.");
        }
        ReaStepVO reaStep = this.readDAO.getReaStep(stepID);
        TicketPreconditionChecks.throwIfReaStepDoesNotExists(reaStep, stepID);
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(reaStep.getBunID());){
            TicketVO ticket = this.getOrgTicketForReaStepOrThrow(stepID);
            boolean initialStep = stepID == ticket.getInitialReaStepID();
            boolean bl = this.updateReaStepTextWithoutCheckingServerOptions(ticket.getID(), stepID, text, initialStep);
            return bl;
        }
    }

    private boolean updateReaStepTextWithoutCheckingServerOptions(int ticketID, int stepID, ReaStepTextVO text, boolean initialStep) {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        TicketChangeCollector changeCollector = TicketChangeCollector.start(this.readDAO, ticket, false);
        boolean updated = this.writeDAO.updateReaStepText(stepID, text, initialStep, ticketID);
        if (updated) {
            changeCollector.markUpdatedReaStep(ticketID, stepID);
            this.writeDAO.getCacheCleaner().clearReaStep(stepID);
            this.writeDAO.getCacheCleaner().clearReaStepText(stepID);
            this.indexUpdateAndEvents.handleTicketChangeCollectorResult(changeCollector.collectChanges(), true);
        }
        return updated;
    }

    private TicketVO getOrgTicketForReaStepOrThrow(int stepID) {
        ReaStepVO reaStep = this.readDAO.getReaStep(stepID);
        TicketPreconditionChecks.throwIfReaStepDoesNotExists(reaStep, stepID);
        int ticketID = reaStep.getOrgBunID();
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        if (ticket == null) {
            throw new IllegalArgumentException(String.format("ReaStep with ID \"%d\" belongs to ticket with ID \"%d\", which does not exist.", stepID, ticketID));
        }
        return ticket;
    }

    @Override
    public TicketVO createTicket(ReaStepTextVO ticketText, MutableTicketData ticketData, @Nullable String emailEingang, @Nullable ExtensionArguments extensionArgs) {
        try (ServerLock lock = TicketManipulatorSync.getTicketCreationLock();){
            ActionCheckError err = this.actionChecker.checkCreateNewTicket(extensionArgs);
            if (err != null) {
                throw HDErrors.createExceptionForCode(err);
            }
            boolean isDispatcher = this.permissionChecker.isDispatcher();
            TicketOperationModel operationModel = this.doTicketOperation(model -> this.manipulator.createTicket(isDispatcher, emailEingang, ticketData, ticketText, extensionArgs, (TicketOperationModel)model));
            OperationChangedTicket changedTicket = operationModel.getChangedTickets().get(0);
            TicketVOSingle ticketVOSingle = this.readDAO.getTicket(changedTicket.getTicketId());
            return ticketVOSingle;
        }
    }

    @Override
    public int applyAction(int ticketID, MutableReaStepData reaStepData, ReaStepTextVO text, ActionVO action, ExtensionArguments extensionArgs) {
        if (action == null) {
            throw new NullPointerException("Action cannot be null!");
        }
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        TicketPreconditionChecks.throwIfTicketDoesNotExists(ticket, ticketID);
        if (ticket.isSlaveInBundle() && action.getId() == -2) {
            HDLogger.warn("Reactivating a slave " + ticketID + " means we instead reactivate the master " + ticket.getBundleID());
            return this.applyAction(ticket.getBundleID(), reaStepData, text, action, extensionArgs);
        }
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticket);){
            int bundleID = ticket.getBundleID();
            ticket = this.readDAO.getTicket(ticketID);
            if (bundleID != ticket.getBundleID()) {
                lock.close();
                HDLogger.warn("Ticket was changed in the meantime: " + ticketID);
                int n = this.applyAction(ticketID, reaStepData, text, action, extensionArgs);
                return n;
            }
            TicketOperationModel operationModel = this.doTicketOperation((model, operationTicket) -> this.manipulator.applyAction_withChecks((OperationChangedTicket)operationTicket, action, reaStepData, text, extensionArgs), ticket);
            int n = this.firstStepFirstAddedReaId(operationModel);
            return n;
        }
    }

    private int firstStepFirstAddedReaId(TicketOperationModel operationModel) {
        if (operationModel.getChangedTickets().isEmpty()) {
            return 0;
        }
        for (OperationChangedTicket operationChangedTicket : operationModel.getChangedTickets()) {
            if (operationChangedTicket.getAddedReaSteps().isEmpty()) continue;
            return operationChangedTicket.getAddedReaSteps().get(0).getReaStepId();
        }
        return 0;
    }

    @Override
    public void updateTicketData(int ticketID, MutableTicketData ticketData) {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        TicketPreconditionChecks.throwIfTicketDoesNotExists(ticket, ticketID);
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticket);){
            this.doTicketOperation((model, operationTicket) -> this.manipulator.updateTicketData_withChecks((OperationChangedTicket)operationTicket, ticketData), ticket);
        }
    }

    @Override
    public int escalateTicket(int ticketID, GUID targetResourceID, ReaStepTextVO text, boolean changeTicketStatus) {
        ExtensionArguments extensionArgs = ExtensionArguments.create();
        extensionArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, ExtensionArguments.ResourceActionExtensionData.forEscalationOfActiveTicket(targetResourceID, changeTicketStatus));
        ActionVO action = TicketManipulatorImpl.getAction(8);
        return this.applyAction(ticketID, new MutableReaStepData(), text, action, extensionArgs);
    }

    private TicketPermissionContext checkDispatcherORSupporterWriteAccess(int ticketID) {
        TicketPermissionContext ticketPermissionInfo = this.permissionChecker.getTicketPermissionInfo(ticketID);
        if (ticketPermissionInfo != null) {
            if (ticketPermissionInfo.getSupporterPermissions() != TicketPermissionContext.SupporterPermission.READWRITE && !ticketPermissionInfo.hasDispatcherAccessToTicket()) {
                throw HDErrors.createExceptionForCode(ActionCheckError.createForAccessDenied("You do not have the permission to edit the ticket."));
            }
        } else {
            throw new IllegalArgumentException("Ticket does not exists: " + ticketID);
        }
        return ticketPermissionInfo;
    }

    @Override
    public int updateReaStepText(int stepID, ReaStepTextVO text, ExtensionArguments extensionArgs) {
        ReaStepVO reaStep = this.readDAO.getReaStep(stepID);
        TicketPreconditionChecks.throwIfReaStepDoesNotExists(reaStep, stepID);
        if (extensionArgs == null) {
            extensionArgs = ExtensionArguments.create();
        }
        extensionArgs.put(ExtensionArguments.EXTARG_CHANGED_REA_STEP, ExtensionArguments.EditReastepTextActionExtensionData.create(stepID, text));
        return this.applyAction(reaStep.getOrgBunID(), new MutableReaStepData(), text, TicketManipulatorImpl.getAction(-22), extensionArgs);
    }

    @Override
    public boolean changeTicketStatusToRead(int ticketID) {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        TicketPreconditionChecks.throwIfTicketDoesNotExists(ticket, ticketID);
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticket);){
            this.checkDispatcherORSupporterWriteAccess(ticketID);
            TicketOperationModel operationModel = this.doTicketOperation((model, operationTicket) -> this.changeTicketStatusIfCurrentMatches((OperationChangedTicket)operationTicket, 103, Arrays.asList(100, 101)), ticket);
            OperationChangedTicket changedTicket = operationModel.getChangedTickets().get(0);
            boolean bl = changedTicket.getOldTicket().get().getStatusID() != this.readDAO.getTicket(changedTicket.getTicketId()).getStatusID();
            return bl;
        }
    }

    @Override
    public boolean changeTicketStatusToUnread(int ticketID) {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        TicketPreconditionChecks.throwIfTicketDoesNotExists(ticket, ticketID);
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticket);){
            this.checkDispatcherORSupporterWriteAccess(ticketID);
            TicketOperationModel operationModel = this.doTicketOperation((model, operationTicket) -> this.changeTicketStatusIfCurrentMatches((OperationChangedTicket)operationTicket, 100, Arrays.asList(103, 101)), ticket);
            OperationChangedTicket changedTicket = operationModel.getChangedTickets().get(0);
            boolean bl = changedTicket.getOldTicket().get().getStatusID() != this.readDAO.getTicket(changedTicket.getTicketId()).getStatusID();
            return bl;
        }
    }

    @Override
    public int bundleTickets(int masterTicketID, List<Integer> slaveTicketIDs) {
        if (slaveTicketIDs == null || slaveTicketIDs.contains(null)) {
            throw new IllegalArgumentException("slaves cannot be or contain null!");
        }
        ArrayList<Integer> ticketsToLock = new ArrayList<Integer>(slaveTicketIDs);
        ticketsToLock.add(masterTicketID);
        return TicketManipulatorSync.doOperationOwningAllMontors(ticketsToLock, () -> {
            TicketPermissionContext ticketPermissionInfo = this.permissionChecker.getTicketPermissionInfo(masterTicketID);
            ActionCheckError errormsg = this.actionChecker.checkAktionBuendeln(masterTicketID, slaveTicketIDs, ticketPermissionInfo);
            if (errormsg != null) {
                throw HDErrors.createExceptionForCode(errormsg);
            }
            TicketOperationModel operationModel = this.doTicketOperation((model, operationTicket) -> this.manipulator.bundleTickets((OperationChangedTicket)operationTicket, slaveTicketIDs, ticketPermissionInfo, (TicketOperationModel)model), this.readDAO.getTicket(masterTicketID));
            return this.firstStepFirstAddedReaId(operationModel);
        });
    }

    @Override
    public int unbundleTickets(int bundleID, List<Integer> idsOfTicketsToUnbundle) {
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(bundleID);){
            TicketPermissionContext ticketPermissionInfo = this.permissionChecker.getTicketPermissionInfo(bundleID);
            ActionCheckError errormsg = this.actionChecker.checkAction(TicketManipulatorImpl.getAction(-13), bundleID, ticketPermissionInfo);
            if (errormsg != null) {
                throw HDErrors.createExceptionForCode(errormsg);
            }
            TicketOperationModel operationModel = this.doTicketOperation((model, operationTicket) -> this.manipulator.unbundleTickets((OperationChangedTicket)operationTicket, idsOfTicketsToUnbundle, ticketPermissionInfo, (TicketOperationModel)model), this.readDAO.getTicket(bundleID));
            int n = this.firstStepFirstAddedReaId(operationModel);
            return n;
        }
    }

    @Override
    public int closeTicket(int ticketID, ReaStepTextVO text, ExtensionArguments extensionArgs) {
        return this.applyAction(ticketID, new MutableReaStepData(), text, TicketManipulatorImpl.getAction(2), extensionArgs);
    }

    private void closeItilSlaves(int ticketID) {
        List<Integer> itilSlaveIDs = this.readDAO.getITILSlaves(ticketID);
        for (int slaveID : itilSlaveIDs) {
            MutableReaStepData reaStepData = new MutableReaStepData();
            ProcessingTime processingTime = ProcessingTime.of(System.currentTimeMillis());
            reaStepData.put(ReaStepVO.FIELD_PROCESSING_TIME, processingTime);
            reaStepData.put(ReaStepVO.FIELD_DESC, "ITIL Slave #" + ticketID);
            this.applyAction(slaveID, reaStepData, ReaStepTextVO.empty(), TicketManipulatorImpl.getAction(2), ExtensionArguments.create());
        }
    }

    @Override
    public int deleteTicket(int ticketID, ReaStepTextVO text, ExtensionArguments extensionArgs) {
        return this.applyAction(ticketID, new MutableReaStepData(), text, TicketManipulatorImpl.getAction(7), extensionArgs);
    }

    @Override
    public int reactivateTicket(int ticketID) {
        return this.applyAction(ticketID, new MutableReaStepData(), ReaStepTextVO.empty(), TicketManipulatorImpl.getAction(-2), ExtensionArguments.create());
    }

    @Override
    public <V> V updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(int ticketID, Callable<V> operation) throws SQLException {
        return this.swingClientHackUpdateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(ticketID, false, operation, false);
    }

    @Override
    public <V> V updateTicketWithFieldChangeReaStepsAndUpdateSearchIndexAfterwardsAndSendEvent(int ticketID, Callable<V> operation) throws SQLException {
        return this.swingClientHackUpdateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(ticketID, true, operation, true);
    }

    @Override
    public <V> V updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(int ticketID, boolean updateTicketText, Callable<V> operation) throws SQLException {
        return this.swingClientHackUpdateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(ticketID, false, operation, updateTicketText);
    }

    @Override
    public <V> V updateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(int ticketID, Callable<V> operation, boolean onlyReadUnreadChange) throws SQLException {
        return this.swingClientHackUpdateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(ticketID, true, operation, false, onlyReadUnreadChange);
    }

    @Override
    public void notifyNewTicketCreatedUpdateSearchIndexAfterwardsAndSendEvent(int newTicketId) {
        HDLogger.debug("[SwingAdapt] Create Ticket in TicketManager:" + newTicketId);
        this.writeDAO.insertEmptyTicketDetailsIfMissingAndClearInCache(newTicketId);
        TicketVOSingle ticket = this.readDAO.getTicket(newTicketId);
        Collection<ReaStepTextVO> reaStepTexts = this.readDAO.getReaStepTextsForTicket(newTicketId).values();
        this.indexUpdateAndEvents.ticketCreated(new TicketDataForIndexingVO(ticket, reaStepTexts));
        ChangedTicketVO changedTicket = new ChangedTicketVO(null, ticket, null);
        this.indexUpdateAndEvents.dispatchEvent(Collections.singletonList(changedTicket));
    }

    @Override
    public int addComment(int ticketID, ReaStepTextVO text, ExtensionArguments extensionArgs) {
        return this.applyAction(ticketID, new MutableReaStepData(), text, TicketManipulatorImpl.getAction(-12), extensionArgs);
    }

    private static ActionVO getAction(int aktID) {
        return (ActionVO)ActionManager.getInstance().get(aktID);
    }

    private TicketOperationModel doTicketOperation(BiConsumer<TicketOperationModel, OperationChangedTicket> operations, TicketVO ticketToUpdate) {
        this.swingClientHackCheckWeAreNotInBackdoorBlock(ticketToUpdate.getID());
        OperationModelImpl model = new OperationModelImpl(this.idGenerator);
        OperationChangedTicket ticket = model.changeExistingTicket(ticketToUpdate.getID());
        this._doTicketOperation(() -> operations.accept(model, ticket), model);
        return model;
    }

    private TicketOperationModel doTicketOperation(Consumer<TicketOperationModel> operations) {
        OperationModelImpl model = new OperationModelImpl(this.idGenerator);
        this._doTicketOperation(() -> operations.accept(model), model);
        return model;
    }

    private TicketOperationModel _doTicketOperation(Runnable businessOperation, OperationModelImpl model) {
        TicketOperationModel ticketOperationModel;
        block9: {
            Closeable nestingProtection = this.checkNestingTicketOperation();
            try {
                TicketChangeCollector changeCollector = this.writeDAO.inTransaction(() -> {
                    businessOperation.run();
                    return this.persistChangesFromModel(model);
                });
                ticketOperationModel = this.afterTicketChangesWerePersisted(model, changeCollector);
                if (nestingProtection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (nestingProtection != null) {
                        try {
                            nestingProtection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
                catch (Throwable th) {
                    this.restorePossibleNewUsedTicketID(model);
                    throw th;
                }
            }
            nestingProtection.close();
        }
        return ticketOperationModel;
    }

    private void restorePossibleNewUsedTicketID(OperationModelImpl model) {
        List<OperationChangedTicket> changedTickets = model.getChangedTickets();
        for (int i = changedTickets.size() - 1; i >= 0; --i) {
            OperationChangedTicket ticket = changedTickets.get(i);
            if (!ticket.isNew()) continue;
            this.idGenerator.transactionFailed(ticket.getTicketId());
        }
    }

    private TicketOperationModel afterTicketChangesWerePersisted(OperationModelImpl model, TicketChangeCollector changeCollector) {
        for (OperationChangedTicket changedTicket : model.getChangedTickets()) {
            this.clearCacheFor(changedTicket);
        }
        for (OperationChangedTicket changedTicket : model.getChangedTickets()) {
            changedTicket.getAfterWriteOperations().forEach(action -> {
                try {
                    action.run();
                }
                catch (Throwable error) {
                    HDLogger.error("Error while performing operation on:" + model.toString());
                    HDLogger.error(error);
                }
            });
        }
        this.indexUpdateAndEvents.handleTicketChangeCollectorResult(changeCollector.collectChanges(), true);
        return model;
    }

    private TicketChangeCollector persistChangesFromModel(OperationModelImpl model) {
        TicketChangeCollector changeCollector = TicketChangeCollector.start(this.readDAO, false);
        try {
            DatabaseTransactionUtils.executeWithToleranceOfTransientExceptions(() -> {
                model.getChangedTickets().stream().filter(oct -> !oct.isNew()).forEach(oct -> changeCollector.collectChangedTicket(oct.getTicketId()));
                for (OperationChangedTicket changedTicket : model.getChangedTickets()) {
                    this.processNewOrChangedTicketFieldsAndAttributes(changeCollector, changedTicket);
                    this.processAddedReaSteps(changeCollector, changedTicket);
                    this.processUpdatedReaSteps(changeCollector, changedTicket);
                }
                return null;
            });
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return changeCollector;
    }

    private void clearCacheFor(OperationChangedTicket changedTicket) {
        if (changedTicket.isNew()) {
            return;
        }
        this.writeDAO.getCacheCleaner().clearTicket(changedTicket.getTicketId());
        if (!changedTicket.getAddedReaSteps().isEmpty()) {
            this.writeDAO.getCacheCleaner().clearListOfReaSteps(changedTicket.getTicketId());
        }
        for (OperationChangedReaStep changedStep : changedTicket.getChangedReaSteps()) {
            OperationChangedReaStepImpl impl;
            this.writeDAO.getCacheCleaner().clearReaStep(changedStep.getReaStepId());
            if (changedStep.getText() != null) {
                this.writeDAO.getCacheCleaner().clearReaStepText(changedStep.getReaStepId());
            }
            if ((impl = (OperationChangedReaStepImpl)changedStep).getBunId() == null) continue;
            this.writeDAO.getCacheCleaner().clearListOfReaSteps(impl.getBunId());
        }
    }

    private void processUpdatedReaSteps(TicketChangeCollector changeCollector, OperationChangedTicket changedTicket) {
        for (OperationChangedReaStep updatedStep : changedTicket.getChangedReaSteps()) {
            OperationChangedReaStepImpl impl;
            changeCollector.markUpdatedReaStep(changedTicket.getTicketId(), updatedStep.getReaStepId());
            boolean initialStep = this.isInitialReaStep(updatedStep.getReaStepId(), changedTicket);
            if (updatedStep.getText() != null) {
                this.writeDAO.updateReaStepText(updatedStep.getReaStepId(), updatedStep.getText().toVO(), initialStep, changedTicket.getTicketId());
            }
            if ((impl = (OperationChangedReaStepImpl)updatedStep).getBunId() == null) continue;
            this.writeDAO.updateReaStepBunId(updatedStep.getReaStepId(), impl.getBunId(), changedTicket.getTicketId());
        }
    }

    private void processAddedReaSteps(TicketChangeCollector changeCollector, OperationChangedTicket changedTicket) {
        for (OperationNewReaStep addedStep : changedTicket.getAddedReaSteps()) {
            int reaId = addedStep.getReaStepId();
            boolean initialStep = this.isInitialReaStep(reaId, changedTicket);
            this.writeDAO.addReaStep(reaId, addedStep.getAttributes(), addedStep.getFields(), addedStep.getText() == null ? null : addedStep.getText().toVO(), initialStep);
            changeCollector.markAddedReaStep(changedTicket.getTicketId(), reaId);
        }
    }

    private int processNewOrChangedTicketFieldsAndAttributes(TicketChangeCollector changeCollector, OperationChangedTicket changedTicket) {
        int ticketID = changedTicket.getTicketId();
        if (changedTicket.isNew()) {
            OperationNewReaStep anfrageReaStep = changedTicket.getAddedReaSteps().get(0);
            if (anfrageReaStep == null) {
                throw new IllegalArgumentException("There must be a reaStep when creating a ticket");
            }
            MutableReaStepText text = anfrageReaStep.getText();
            ticketID = this.writeDAO.createTicket(ticketID, changedTicket.getNewTicketAttributes(), changedTicket.getNewTicketData(), text);
            changeCollector.collectNewCreatedTicket(ticketID);
        } else {
            ticketID = changedTicket.getOldTicket().get().getID();
            changedTicket.createFieldChangeReaStepsIfNeeded();
            this.writeDAO.updateTicketData(ticketID, changedTicket.getNewTicketAttributes(), changedTicket.getNewTicketData());
        }
        return ticketID;
    }

    private boolean isInitialReaStep(int stepID, OperationChangedTicket ticket) {
        return stepID == ticket.getAttributeValue(Tickets.ATTRIBUTE_INITIAL_REA_STEP_ID);
    }

    public void moveAllTicketsFromDeletedResources(List<Integer> deletedResourceIDs, int targetResID) {
        if (deletedResourceIDs == null) {
            throw new IllegalArgumentException("list with IDs of deleted resources must not be null");
        }
        if (deletedResourceIDs.isEmpty()) {
            throw new IllegalArgumentException("list with IDs of deleted resources must not be empty");
        }
        if (deletedResourceIDs.contains(null)) {
            throw new IllegalArgumentException("list with IDs of deleted resources must not contain null elements");
        }
        if (deletedResourceIDs.contains(targetResID)) {
            throw new IllegalArgumentException("list with IDs of deleted resources must not contain ID of specified target resource");
        }
        UserGroupInfo targetResource = HDUsersAndGroups.getResource(targetResID);
        if (targetResource == null) {
            throw new IllegalArgumentException(String.format("Resource with ID \"%d\" does not exist.", targetResID));
        }
        for (int resID : deletedResourceIDs) {
            ServerLock lock;
            TicketVOSingle ticket;
            TicketReadDAOImpl.TicketsInResource ticketsInResource = this.readDAO.listTicketsInResource(resID);
            Map<Integer, List<Integer>> ticketIdToSlaveTicketIDs = ticketsInResource.getTicketIdToSlaveTicketIDs();
            for (int ticketID : ticketIdToSlaveTicketIDs.keySet()) {
                ticket = this.readDAO.getTicket(ticketID);
                lock = TicketManipulatorSync.getTicketLock(ticket);
                try {
                    this.doTicketOperation((model, operationTicket) -> {
                        if (ticket.isInquiry()) {
                            operationTicket.getNewTicketData().put(Tickets.FIELD_RESOURCE_GUID, HDUsersAndGroups.getResourceGroupUUID(targetResID));
                            operationTicket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_LAST_CHANGED, System.currentTimeMillis());
                        } else {
                            List slaveTicketIDs = (List)ticketIdToSlaveTicketIDs.get(ticketID);
                            ExtensionArguments extensionArgs = ExtensionArguments.create();
                            extensionArgs.put(ExtensionArguments.EXTARG_RESOURCE_ACTION_EXTENSION_DATA, ExtensionArguments.ResourceActionExtensionData.forEscalationOfActivAndInactivTicketsWithoutChangingStatus(targetResource.getID(), slaveTicketIDs));
                            ActionVO action = (ActionVO)ActionManager.getInstance().get(8);
                            this.manipulator.applyAction(new TicketPermissionContext(false, TicketPermissionContext.SupporterPermission.NONE), (OperationChangedTicket)operationTicket, new MutableReaStepData(), ReaStepTextVO.empty(), action, extensionArgs);
                        }
                    }, ticket);
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
            for (int ticketID : ticketsInResource.getIDsOfSlaveTicketsWithMastersInOtherResources()) {
                ticket = this.readDAO.getTicket(ticketID);
                lock = TicketManipulatorSync.getTicketLock(ticket);
                try {
                    this.doTicketOperation((model, ct) -> ExtensionUtils.escalateTicketSilently(ct, targetResource, System.currentTimeMillis()), ticket);
                }
                finally {
                    if (lock == null) continue;
                    lock.close();
                }
            }
        }
    }

    public void applyActionAnlageLoeschen(int ticketID, ReaStepTextVO stepText, String stepDescription) {
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        TicketPreconditionChecks.throwIfTicketDoesNotExists(ticket, ((TicketVO)ticket).getID());
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticket);){
            this.doTicketOperation((model, operationTicket) -> {
                MutableReaStepData stepData = new MutableReaStepData();
                stepData.put(ReaStepVO.FIELD_DESC, stepDescription);
                ActionVO action = (ActionVO)ActionManager.getInstance().get(-6);
                this.manipulator.applyAction(new TicketPermissionContext(false, TicketPermissionContext.SupporterPermission.NONE), (OperationChangedTicket)operationTicket, stepData, stepText, action, ExtensionArguments.create());
            }, ticket);
        }
    }

    public void closeAutoFinishableTickets(long currentTimeMillis) {
        int requiredIdleDays = Math.max(1, (Integer)DEFAULT_EMAIL_SEND_CLOSE_TIME.get());
        List<Integer> autoFinishableTicketIDs = this.readDAO.listAutoFinishableTickets(currentTimeMillis, requiredIdleDays);
        TicketPermissionContext permissionContext = new TicketPermissionContext(false, TicketPermissionContext.SupporterPermission.READWRITE);
        ReaStepTextVO text = ReaStepTextVO.of(Tickets.MSG.getMsg(Tickets.serverLocale(), "text.autoTicketClose", new Object[0]), false);
        TicketManipulatorSync.doOperationOwningAllMontors(autoFinishableTicketIDs, () -> {
            Iterator iterator = autoFinishableTicketIDs.iterator();
            while (iterator.hasNext()) {
                int ticketID = (Integer)iterator.next();
                this.doTicketOperation((model, ticket) -> this.manipulator.closeTicket(permissionContext, (OperationChangedTicket)ticket, text, ExtensionArguments.create(), (TicketOperationModel)model), this.readDAO.getTicket(ticketID));
            }
            return null;
        });
    }

    private Closeable checkNestingTicketOperation() {
        if (this.ticketOperationNesting.get().booleanValue()) {
            throw new IllegalStateException("No nested calls of TicketOperations are allowed. Change the ChangedTicket of the already started operation by usinf methode from TicketSubOperations.");
        }
        this.ticketOperationNesting.set(true);
        return () -> this.ticketOperationNesting.set(false);
    }

    private void swingClientHackCheckWeAreNotInBackdoorBlock(int ticketID) {
        if (this.ticketsBeingManipulatedByCurrentThread.get().contains(ticketID)) {
            throw new IllegalStateException("Critical: cannot use normal methods of TicketManipulator inside an update-backdoor block. You must use the normal API outside such a block and only external changes of the database must be inside.");
        }
    }

    private <V> V swingClientHackUpdateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(int ticketID, boolean addFieldChangeReaSteps, Callable<V> operation, boolean updateReaStepTexts) throws SQLException {
        return this.swingClientHackUpdateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(ticketID, addFieldChangeReaSteps, operation, updateReaStepTexts, false);
    }

    private <V> V swingClientHackUpdateTicketAndUpdateSearchIndexAfterwardsAndSendEvent(int ticketID, boolean addFieldChangeReaSteps, Callable<V> operation, boolean updateReaStepTexts, boolean onlyReadUnreadChange) throws SQLException {
        if (ticketID <= 0) {
            throw new IllegalArgumentException("Must specify the ticketID being modified. For DatabaseCommands, use UpdateCommandConstants.META_UPDATE_PARAMETER_TICKETID to set the ticketID as parameter for the statement on client side.");
        }
        if (this.ticketsBeingManipulatedByCurrentThread.get().contains(ticketID)) {
            try {
                return operation.call();
            }
            catch (Exception e) {
                throw new SQLExceptionWithErrorCode(e, HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
            }
        }
        this.ticketsBeingManipulatedByCurrentThread.get().add(ticketID);
        HDLogger.debug("[SwingAdapt] Update Ticket in TicketManager:" + ticketID);
        try {
            V v;
            block20: {
                ServerLock lock = this.swingClientHackGetMonitorAllowMoreIfNoOtherIsBlocked(ticketID);
                try {
                    TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
                    TicketChangeCollector changeCollector = TicketChangeCollector.start(this.readDAO, ticket, updateReaStepTexts);
                    V operationResult = operation.call();
                    changeCollector.markThatAllReaStepsMayBeAffected(ticketID);
                    ((TicketReadDAOCacheCleaner)((Object)this.readDAO)).clearTicket(ticketID);
                    ((TicketReadDAOCacheCleaner)((Object)this.readDAO)).clearListOfReaSteps(ticketID);
                    if (!onlyReadUnreadChange) {
                        this.writeDAO.updateLastChanged(ticketID, System.currentTimeMillis());
                    }
                    if (Status.isClosedOrDeletedStatus(ticket.getStatusID()) != Status.isClosedOrDeletedStatus(this.readDAO.getTicket(ticketID).getStatusID())) {
                        this.writeDAO.updateCloseDate(ticketID, Status.isClosedOrDeletedStatus(ticket.getStatusID()) ? null : Long.valueOf(System.currentTimeMillis()));
                    }
                    this.writeDAO.getCacheCleaner().clearTicket(ticketID);
                    if (addFieldChangeReaSteps) {
                        OperationModelImpl modelJustForFieldChangeReaSteps = new OperationModelImpl(this.idGenerator);
                        OperationChangedTicket opTicket_not_fully_usable = modelJustForFieldChangeReaSteps.changeExistingTicket(ticket);
                        opTicket_not_fully_usable.createFieldChangeReaStepsIfNeeded();
                        for (OperationNewReaStep addedStep : opTicket_not_fully_usable.getAddedReaSteps()) {
                            this.writeDAO.addReaStep(addedStep.getReaStepId(), addedStep.getAttributes(), addedStep.getFields(), addedStep.getText() == null ? null : addedStep.getText().toVO(), false);
                            this.writeDAO.getCacheCleaner().clearListOfReaSteps(ticketID);
                            this.writeDAO.getCacheCleaner().clearTicket(ticketID);
                        }
                    }
                    TicketChangeCollector.TicketChangeCollectorResult changeCollectorResult = changeCollector.collectChanges();
                    this.indexUpdateAndEvents.handleTicketChangeCollectorResult(changeCollectorResult, true);
                    v = operationResult;
                    if (lock == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new SQLExceptionWithErrorCode(e, HelpDeskErrorCodes.SQL_EXECUTION_ERROR);
                    }
                }
                lock.close();
            }
            return v;
        }
        finally {
            this.ticketsBeingManipulatedByCurrentThread.get().remove(ticketID);
        }
    }

    private void swingClientHackUpdateAttachmentFlag(int ticketID) {
        int masterTicketID;
        TicketVOSingle masterTicket;
        TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
        if (ticket == null) {
            return;
        }
        TicketChangeCollector changeCollector = null;
        if (!this.ticketsBeingManipulatedByCurrentThread.get().contains(ticketID)) {
            changeCollector = TicketChangeCollector.start(this.readDAO, ticket, false);
        }
        this.updateAttachmentFlagForBundle(ticket.getBundleID());
        long lastModified = System.currentTimeMillis();
        this.writeDAO.updateLastChanged(ticketID, lastModified);
        this.writeDAO.getCacheCleaner().clearTicket(ticketID);
        if (ticket.isSlaveInBundle() && (masterTicket = this.readDAO.getTicket(masterTicketID = ticket.getBundleID())) != null) {
            this.writeDAO.updateLastChanged(masterTicketID, lastModified);
            this.writeDAO.getCacheCleaner().clearTicket(masterTicketID);
        }
        if (changeCollector != null) {
            this.indexUpdateAndEvents.handleTicketChangeCollectorResult(changeCollector.collectChanges(), true);
        }
    }

    private ServerLock swingClientHackGetMonitorAllowMoreIfNoOtherIsBlocked(int ticketID) {
        if (this.ticketsBeingManipulatedByCurrentThread.get().stream().anyMatch(id -> id != ticketID)) {
            long timeout = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < timeout) {
                ServerLock serverLock = TicketManipulatorSync.tryTicketLock(ticketID);
                if (serverLock != null) {
                    return serverLock;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
            throw new IllegalStateException("Possible deadlock detected. The current opertion is terminated, because some other user or task is currently operating on the ticket. Please run the operation again. The current ticket is #" + ticketID + " Already edited tickets are: " + this.ticketsBeingManipulatedByCurrentThread.get().toString());
        }
        return TicketManipulatorSync.getTicketLock(ticketID);
    }

    private void updateAttachmentFlagForBundle(int bundleID) {
        for (int ticketID : this.readDAO.getTicketIDsForBundleID(bundleID)) {
            this.writeDAO.updateAttachmentFlagForTicketAndClearCache(ticketID);
        }
    }

    public void deleteForeverAllTicketsMarkedAsDeleted() {
        List<Integer> bunleTicketIDs = this.readDAO.findTicketBundlesMarkedAsDeleted();
        for (int bunID : bunleTicketIDs) {
            this.deleteTicketForever(bunID);
        }
    }

    public void deleteTicketsForeverByDate(long lastModified) {
        List<Integer> bunleTicketIDs = this.readDAO.findTicketBundlesByDate(lastModified);
        for (int bunID : bunleTicketIDs) {
            this.deleteTicketForever(bunID);
        }
    }

    public void deleteTicketsForeverByID(int fromID, int toID) {
        List<Integer> bunleTicketIDs = this.readDAO.findTicketBundlesInRangeOfTicketIDs(fromID, toID);
        for (int bunID : bunleTicketIDs) {
            this.deleteTicketForever(bunID);
        }
    }

    public void deleteTicketForever(int ticketID) {
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticketID);){
            TicketVOSingle ticket = this.readDAO.getTicket(ticketID);
            if (ticket == null) {
                boolean hasDeletedTicketData = this.writeDAO.deleteTicketsOfSingleBundleForeverAndClearInCache(ticketID);
                if (hasDeletedTicketData) {
                    HDLogger.debug("Ticket with probably corrupted data has been deleted: " + ticketID);
                    TicketEventLog.FullyDeleted.log(UserManager.getRecoveryEnabledInstance().getCurrentUserAccount(), ticketID);
                } else {
                    HDLogger.warn("Ticket to be deleted could not be found, probably is already deleted: " + ticketID);
                }
                return;
            }
            if (ticket.isSlaveInBundle()) {
                throw new IllegalArgumentException("Slave tickets of bundles cannot be deleted separately, you must delete the whole bundle. Given ID=" + ticketID);
            }
            int reaStepCount = this.readDAO.getReaStepCountForTicket(ticketID);
            if (reaStepCount > 1000) {
                this.deleteMonsterTicketForever(ticket);
                return;
            }
            TicketChangeCollector changeCollector = TicketChangeCollector.start(this.readDAO, ticket, true);
            this.writeDAO.deleteTicketsOfSingleBundleForeverAndClearInCache(ticketID);
            this.indexUpdateAndEvents.handleTicketChangeCollectorResult(changeCollector.collectChanges(), true);
            TicketEventLog.FullyDeleted.log(UserManager.getRecoveryEnabledInstance().getCurrentUserAccount(), ticketID);
        }
    }

    private void deleteMonsterTicketForever(final TicketVO ticket) {
        try (ServerLock lock = TicketManipulatorSync.getTicketLock(ticket);){
            try {
                int ticketID = ticket.getID();
                List<Integer> reaStepIDsForTicket = this.readDAO.getReaStepIDsForTicket(ticketID);
                new SubListTaskExecutor().executeForEachSubList(reaStepIDsForTicket, 1000, new SubListTaskExecutor.SubListExecutionTask<Integer>(){

                    @Override
                    public void execute(List<Integer> sublist) {
                        List<ReaStepTextVO> reaStepTexts = TicketManipulatorImpl.this.readDAO.getReaStepTexts(sublist);
                        ArrayList<TicketDataForIndexingVO.TicketDataForIndexingVOPair> dataForIndexing = new ArrayList<TicketDataForIndexingVO.TicketDataForIndexingVOPair>();
                        TicketDataForIndexingVO oldData = new TicketDataForIndexingVO(ticket, reaStepTexts);
                        TicketDataForIndexingVO newData = new TicketDataForIndexingVO(ticket, new ArrayList<ReaStepTextVO>());
                        dataForIndexing.add(new TicketDataForIndexingVO.TicketDataForIndexingVOPair(oldData, newData));
                        ArrayList<ChangedTicketVO> dataForEvent = new ArrayList<ChangedTicketVO>();
                        TicketChangeCollector.TicketChangeCollectorResult change = new TicketChangeCollector.TicketChangeCollectorResult(dataForIndexing, dataForEvent);
                        TicketManipulatorImpl.this.indexUpdateAndEvents.handleTicketChangeCollectorResult(change, false);
                    }
                });
                TicketChangeCollector changeCollector = TicketChangeCollector.start(this.readDAO, ticket, false);
                this.writeDAO.deleteTicketsOfSingleBundleForeverAndClearInCache(ticketID);
                this.indexUpdateAndEvents.handleTicketChangeCollectorResult(changeCollector.collectChanges(), true);
                TicketEventLog.FullyDeleted.log(UserManager.getRecoveryEnabledInstance().getCurrentUserAccount(), ticketID);
            }
            catch (Exception e) {
                HDLogger.error(e);
            }
        }
    }

    private boolean changeTicketStatusIfCurrentMatches(@Nonnull OperationChangedTicket ticket, int targetStatus, List<Integer> requiredStatusesToMatchBeforeChange) {
        if (requiredStatusesToMatchBeforeChange.contains(ticket.getOldTicket().get().getStatusID())) {
            ticket.getNewTicketAttributes().put(Tickets.ATTRIBUTE_STATUS_ID, targetStatus);
            return true;
        }
        return false;
    }

    @Override
    public TicketManipulatorBackdoor.IDGeneratorBackdoor getIDGenerator() {
        return this.idGenerator;
    }
}

