/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SqlUtilities {
    public static final int TYPE_SQL_SERVER = 2;
    public static final int TYPE_ORACLE = 3;
    public static final int TYPE_MYSQL = 4;
    public static final int ORACLE_MAX_PARAMS = 1000;
    public static final int ALL_MAX_PARAMS = 10000;
    private int dbTyp;

    public SqlUtilities(int databaseType) {
        this.dbTyp = databaseType;
    }

    public void addLike(StringBuilder buffer, String fieldName, String sqlText, boolean prefixAnd) {
        if (prefixAnd) {
            buffer.append(" AND ");
        }
        if (this.dbTyp == 3) {
            if (sqlText.length() == 0) {
                buffer.append(fieldName).append(" is null ");
            } else if (!sqlText.equals("*")) {
                buffer.append("LOWER(").append(fieldName).append(") LIKE LOWER('");
                this.appendSqlString(buffer, sqlText, true);
                buffer.append("') ");
            }
        } else if (sqlText.length() == 0) {
            buffer.append("(").append(fieldName).append(" LIKE '' OR ").append(fieldName).append(" is null) ");
        } else {
            buffer.append(fieldName).append(" LIKE '");
            this.appendSqlString(buffer, sqlText, true);
            buffer.append("' ");
        }
    }

    public void appendSqlString(StringBuilder buffer, String pattern, boolean replaceWildCards) {
        block7: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '\\': {
                    if (this.dbTyp == 4) {
                        buffer.append("\\\\");
                        continue block7;
                    }
                    buffer.append(ch);
                    continue block7;
                }
                case '\'': {
                    buffer.append("''");
                    continue block7;
                }
                case '[': {
                    if (this.dbTyp == 2) {
                        buffer.append("[[]");
                        continue block7;
                    }
                    buffer.append(ch);
                    continue block7;
                }
                case '*': {
                    if (replaceWildCards) {
                        buffer.append('%');
                        continue block7;
                    }
                    buffer.append(ch);
                    continue block7;
                }
                case '?': {
                    if (replaceWildCards) {
                        buffer.append("_");
                        continue block7;
                    }
                    buffer.append(ch);
                    continue block7;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
    }

    public List<String> getInSQL(int[] ids) {
        ArrayList<String> result = new ArrayList<String>();
        if (ids != null && ids.length > 0) {
            int max;
            int n = max = this.dbTyp == 3 ? 1000 : 10000;
            if (ids.length <= max) {
                result.add(this.getInSQLImpl(ids));
            } else {
                for (int i = 0; i < ids.length; i += max) {
                    int endIndex = Math.min(i + max, ids.length);
                    result.add(this.getInSQLImpl(Arrays.copyOfRange(ids, i, endIndex)));
                }
            }
        }
        return result;
    }

    private String getInSQLImpl(int[] ids) {
        StringBuilder sb = new StringBuilder(" IN(");
        for (int i = 0; i < ids.length; ++i) {
            sb.append(ids[i]).append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }
}

