/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.rpc;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.shared.util.SqlUtilities;
import java.util.Arrays;

@JsonData
public class QueryParameter {
    private String key;
    private String[] values;
    private boolean isNumeric;

    private QueryParameter() {
    }

    public QueryParameter(String key, String ... values) {
        this.key = key;
        this.values = values;
    }

    public QueryParameter(String key, boolean isNumeric, String ... values) {
        this(key, values);
        this.isNumeric = isNumeric;
    }

    public QueryParameter(String key, Integer ... values) {
        this.key = key;
        this.isNumeric = true;
        if (values != null && values.length > 0) {
            this.values = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.values[i] = values[i].toString();
            }
        }
    }

    public String getKey() {
        return this.key;
    }

    public String[] getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QueryParameter)) {
            return false;
        }
        QueryParameter other = (QueryParameter)obj;
        if (this.key != null ? !this.key.equals(other.key) : other.key != null) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public static String convertToWherePart(SqlUtilities sqlUtils, QueryParameter ... params) {
        if (params == null || params.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (QueryParameter param : params) {
            if (param.getKey() == null || param.getValues() == null || param.getValues().length == 0) continue;
            b.append(" AND ");
            String[] values = param.getValues();
            if (param.isNumeric()) {
                b.append(param.getKey());
                if (values.length == 1) {
                    boolean nullableBecauseUser;
                    boolean bl = nullableBecauseUser = param.getKey().equalsIgnoreCase("BgrId") || param.getKey().equalsIgnoreCase("GebId") || param.getKey().equalsIgnoreCase("BetID");
                    if (nullableBecauseUser && ("-1".equals(values[0]) || values[0] == null || "0".equals(values[0]) && param.getKey().equalsIgnoreCase("BetID"))) {
                        b.append(" is null");
                        continue;
                    }
                    b.append('=').append((Object)values[0]);
                    continue;
                }
                b.append(" IN (");
                boolean appendComma = false;
                for (String value : values) {
                    if (appendComma) {
                        b.append(',');
                    } else {
                        appendComma = true;
                    }
                    b.append((Object)value);
                }
                b.append(')');
                continue;
            }
            if (values.length > 1) {
                b.append('(');
            }
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                if (i > 0) {
                    b.append(" OR ");
                }
                b.append(param.getKey());
                if (value != null) {
                    b.append(" like '");
                    if (sqlUtils == null) {
                        b.append((Object)value);
                    } else {
                        sqlUtils.appendSqlString(b, value.toString(), false);
                    }
                    b.append('\'');
                    continue;
                }
                b.append(" is null");
            }
            if (values.length <= 1) continue;
            b.append(')');
        }
        return b.toString();
    }

    public String toString() {
        return this.getKey() + "=" + Arrays.toString(this.getValues());
    }
}

