/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.shared.rpc;

import com.inet.annotations.JsonData;
import com.inet.helpdesk.shared.rpc.RPCUtils;
import com.inet.lib.json.Json;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

@JsonData
public class Packet {
    public static final String COMMAND_ERROR = "error";
    private String cmd;
    private String json;
    private transient Map<Object, Map<String, String>> extraFields;

    private Packet() {
    }

    public Packet(String cmd, Object data) {
        this.cmd = cmd;
        this.json = RPCUtils.toJson(data);
    }

    public Packet(Throwable th) {
        this(COMMAND_ERROR, th.toString());
    }

    public String getCmd() {
        return this.cmd;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public boolean isError() {
        return COMMAND_ERROR.equals(this.getCmd());
    }

    public <T> T getData(Class<T> clazz) {
        this.extraFields = new HashMap<Object, Map<String, String>>();
        return RPCUtils.fromJson(this.json, clazz, this.extraFields);
    }

    public Object getData(Type clazz) {
        this.extraFields = new HashMap<Object, Map<String, String>>();
        return new Json().fromJson(this.json, clazz, this.extraFields);
    }

    public <T> T getExtraData(Object obj, String fieldName, Class<T> clazz) {
        Map<String, String> fields = this.extraFields.get(obj);
        if (fields == null) {
            return null;
        }
        String jsonData = fields.get(fieldName);
        if (jsonData == null) {
            return null;
        }
        return RPCUtils.fromJson(jsonData, clazz);
    }
}

