/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets.rpc.handler;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataConnector;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.permissions.HdPermissionsMapper;
import com.inet.helpdesk.core.servlets.rpc.AbstractPacketHandler;
import com.inet.helpdesk.core.ticketmanager.TicketManager;
import com.inet.helpdesk.shared.model.user.CurrentUserResponse;
import com.inet.helpdesk.shared.model.user.User;
import com.inet.helpdesk.shared.util.UtilityFunctions;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.helpdesk.usersandgroups.UserModelConverter;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class CurrentUserHandler
extends AbstractPacketHandler<Void, CurrentUserResponse> {
    private ConnectionFactory connectionfactory;

    public CurrentUserHandler(ConnectionFactory connectionfactory) {
        this.connectionfactory = connectionfactory;
    }

    @Override
    public String getCommand() {
        return "getCurrentUser";
    }

    @Override
    protected CurrentUserResponse handle(HttpServletRequest request, Void input) {
        try {
            UserAccount account = UserManager.getInstance().getCurrentUserAccount();
            if (account == null) {
                HDLogger.error(new ServerDataException(new IllegalStateException("No current user")));
                return null;
            }
            User userInfo = UserModelConverter.convertUserAccount(account);
            HdPermissionsMapper hdPermissionsMapper = new HdPermissionsMapper(account);
            int rechte = hdPermissionsMapper.userPermissions();
            boolean isDispatcher = hdPermissionsMapper.isDispatcher();
            CurrentUserResponse response = new CurrentUserResponse();
            response.setDispatcher(isDispatcher);
            response.setUser(userInfo);
            response.setPermissions(rechte);
            response.setAllowedActions(TicketManager.getTicketActionChecker().getEffectiveAllowedActionsForCurrentUser());
            this.loadUserProperties(HDUsersAndGroups.getUserID(account), response);
            return response;
        }
        catch (Exception e) {
            HDLogger.error(e);
            return null;
        }
    }

    private void loadUserProperties(int userId, CurrentUserResponse response) {
        try (Connection connection = this.connectionfactory.getConnection();
             Statement stmt = connection.createStatement();){
            try (ResultSet rs = stmt.executeQuery(String.format("select Properties, Aenderung from tblUser where UsrID = %d", userId));){
                if (rs.next()) {
                    ServerDataConnector serverDataConnector = (ServerDataConnector)ServerPluginManager.getInstance().getSingleInstance(ServerDataConnector.class);
                    Properties viewProperties = serverDataConnector.getDefaultUserViewProperties();
                    Properties userProperties = UtilityFunctions.loadConfigProperties(rs.getBytes("Properties"));
                    if (userProperties != null) {
                        for (Map.Entry<Object, Object> entry : userProperties.entrySet()) {
                            if (entry.getValue() == null) continue;
                            viewProperties.put(entry.getKey(), entry.getValue());
                        }
                    }
                    response.setProperties(UtilityFunctions.getEncodedBytesFromProperties(viewProperties));
                    response.setLastModified(rs.getTimestamp("Aenderung"));
                    return;
                }
            }
            throw new IllegalStateException(String.format("User with ID %d does not exist", userId));
        }
        catch (ServerDataException e) {
            HDLogger.error(e);
        }
        catch (IOException e) {
            HDLogger.error(e);
        }
        catch (SQLException e) {
            HDLogger.error(e);
        }
    }
}

