/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.servlets.konnekterproxy;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.ServerInitializerStatus;
import com.inet.http.PluginServlet;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import srv.KonnektorPort;

public class KonnekterProxy
extends HttpServlet
implements PluginServlet {
    private final ServerInitializerStatus status;
    private int port = -1;
    private ArrayList<Socket> sockets = new ArrayList();

    public KonnekterProxy(ServerInitializerStatus status) {
        this.status = status;
    }

    @Nonnull
    public String getPathSpec() {
        return "/konnekter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="The socket is internally used to connect to the local server itself.")
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Socket socket;
        Object currentVeto;
        String initMsg = null;
        if (this.status != null && (currentVeto = this.status.getCurrentVeto()) != null) {
            initMsg = currentVeto.getMessage();
        }
        if (initMsg != null) {
            currentVeto = this.sockets;
            synchronized (currentVeto) {
                Iterator<Socket> iterator = this.sockets.iterator();
                while (iterator.hasNext()) {
                    Socket s = iterator.next();
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    iterator.remove();
                }
            }
            return;
        }
        if (this.port == -1) {
            this.port = KonnektorPort.get();
        }
        ArrayList<Socket> iterator = this.sockets;
        synchronized (iterator) {
            socket = this.sockets.size() > 0 ? this.sockets.remove(0) : null;
        }
        if (socket == null) {
            try {
                socket = new Socket("localhost", this.port);
            }
            catch (IOException ex) {
                HDLogger.error("Connect to proxy on port " + this.port + " is failing.");
                throw ex;
            }
        }
        ServletInputStream in = req.getInputStream();
        BufferedInputStream bufIn = new BufferedInputStream((InputStream)in, 4096);
        bufIn.mark(4096);
        try {
            this.transferData(req, resp, socket, bufIn);
        }
        catch (IOException ioEx) {
            socket.close();
            try {
                bufIn.reset();
            }
            catch (IOException innerIOE) {
                throw ioEx;
            }
            socket = new Socket("localhost", this.port);
            this.transferData(req, resp, socket, bufIn);
        }
        ArrayList<Socket> arrayList = this.sockets;
        synchronized (arrayList) {
            this.sockets.add(socket);
        }
    }

    private void transferData(HttpServletRequest req, HttpServletResponse resp, Socket socket, InputStream in) throws IOException {
        OutputStream out = socket.getOutputStream();
        this.transferData(in, out, req);
        out = resp.getOutputStream();
        in = socket.getInputStream();
        this.transferData(in, out, req);
    }

    private void transferData(InputStream in, OutputStream out, HttpServletRequest req) throws IOException {
        int count;
        byte[] puffer = new byte[4096];
        boolean lastPacket = false;
        boolean isPacketStart = true;
        boolean lowByteRead = false;
        boolean isLogin = false;
        byte lo = 0;
        byte hi = 0;
        int packetSize = 0;
        int sizeRead = 0;
        while ((count = in.read(puffer)) > 0) {
            out.write(puffer, 0, count);
            sizeRead += count;
            int nextPacketIdx = 0;
            while (isPacketStart || sizeRead > packetSize) {
                if (isPacketStart) {
                    if (!lowByteRead && sizeRead == 1) {
                        lo = puffer[nextPacketIdx];
                        lowByteRead = true;
                        break;
                    }
                    if (lowByteRead) {
                        hi = puffer[nextPacketIdx];
                        lowByteRead = false;
                    } else {
                        lo = puffer[nextPacketIdx];
                        hi = puffer[nextPacketIdx + 1];
                    }
                    packetSize = (lo & 0xFF) + (hi << 8);
                    lastPacket = (packetSize & 0x8000) == 0;
                    isLogin = (packetSize & 0x4000) != 0;
                    packetSize &= 0x3FFF;
                    isPacketStart = false;
                    continue;
                }
                nextPacketIdx = packetSize - (sizeRead - count);
                isPacketStart = true;
                if ((sizeRead -= packetSize) != 0) continue;
                packetSize = 0;
                break;
            }
            if (sizeRead == packetSize) {
                sizeRead = 0;
                packetSize = 0;
                isPacketStart = true;
            }
            if (!lastPacket || sizeRead != packetSize) continue;
        }
        out.flush();
        if (isLogin) {
            String remoteHost = req.getRemoteHost();
            if (remoteHost == null) {
                remoteHost = "unknown host";
            }
            int length = remoteHost.length();
            int idx = 2;
            puffer[idx++] = (byte)length;
            puffer[idx++] = (byte)(length >> 8);
            puffer[idx++] = (byte)(length >> 16);
            puffer[idx++] = (byte)(length >> 24);
            for (int i = 0; i < length; ++i) {
                char c = remoteHost.charAt(i);
                puffer[idx++] = (byte)c;
                puffer[idx++] = (byte)(c >> 8);
            }
            length = idx;
            idx = 0;
            puffer[idx++] = (byte)length;
            puffer[idx++] = (byte)(length >> 8);
            out.write(puffer, 0, length);
            out.flush();
        }
    }
}

