/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.userfunctions;

import com.inet.helpdesk.config.UserImportConfigInfo;
import com.inet.helpdesk.config.UserImportConfigInfoMap;
import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.data.DataImportConnector;
import com.inet.helpdesk.core.data.LocalizationBundle;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.TranslationTextConnector;
import com.inet.helpdesk.core.model.general.Localization;
import com.inet.helpdesk.core.model.ticket.TableColumnDatabaseFieldModificationProvider;
import com.inet.helpdesk.core.ticketmanager.fields.category.CategoryManager;
import com.inet.helpdesk.usersandgroups.groups.fields.ResourceFieldWorkingHours;
import com.inet.lib.util.LocaleUtils;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.formula.UserDefinedFunction;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import srv.controller.ticket.timeline.ResourceTimelineManager;
import srv.controller.ticket.timeline.ResultCalculator;

public class ReportingUtilitiesFunctions
implements UserDefinedFunction {
    private LocalizationBundle localization;
    private TranslationTextConnector connectionFactory;

    private void init() {
        if (this.localization == null) {
            this.connectionFactory = (TranslationTextConnector)ServerPluginManager.getInstance().getSingleInstance(TranslationTextConnector.class);
            this.localization = (LocalizationBundle)ServerPluginManager.getInstance().getSingleInstance(LocalizationBundle.class);
        }
    }

    public String getUtf8String(byte[] data) {
        String result = "";
        try {
            result = new String(data, "UTF-8");
        }
        catch (Exception ex) {
            HDLogger.error(ex);
        }
        return result;
    }

    public String getUserImportName(String key) {
        DataImportConnector dataImportConnector = (DataImportConnector)ServerPluginManager.getInstance().getSingleInstance(DataImportConnector.class);
        UserImportConfigInfoMap uicim = dataImportConnector.getUserImports();
        if (uicim != null) {
            for (Map.Entry entry : uicim.entrySet()) {
                if (!key.equals(((UserImportConfigInfo)entry.getValue()).getUid())) continue;
                return ((UserImportConfigInfo)entry.getValue()).getName();
            }
        }
        return key;
    }

    public String getTranslation(String fieldKey, String languageKey) {
        this.init();
        Localization instance = this.localization.getInstance(LocaleUtils.valueOf((String)languageKey), this.connectionFactory);
        return instance.getTranslation("helpdesk", fieldKey);
    }

    public String getValueModification(String fieldKey, String value) {
        List extensions = ServerPluginManager.getInstance().get(TableColumnDatabaseFieldModificationProvider.class);
        for (TableColumnDatabaseFieldModificationProvider extension : extensions) {
            if (!extension.providesFor(null, fieldKey)) continue;
            return extension.getDisplayStringFor(value);
        }
        return value;
    }

    public boolean isAttachmentPluginAvailable() {
        return ServerPluginManager.getInstance().isPluginLoaded("attachments");
    }

    public String getCategoryPath(int categoryID) {
        try {
            return CategoryManager.getInstance().findCategoryPathOrThrow(categoryID);
        }
        catch (ServerDataException e) {
            HDLogger.error(e);
            return e.toString();
        }
    }

    public Integer[] getIdsForSearchPath(String searchPath, boolean subs) {
        String searchValue = searchPath.toUpperCase();
        List categories = CategoryManager.getInstance().getAll(false);
        List result = categories.stream().filter(c -> this.wildcardEqualsWithSubs(searchValue, c.getPath().toUpperCase(), subs)).collect(Collectors.toList());
        int[] ids = result.stream().mapToInt(c -> c.getId()).toArray();
        Integer[] values = new Integer[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            values[i] = ids[i];
        }
        return values;
    }

    protected boolean wildcardEqualsWithSubs(String searchPath, String categoryPath, boolean subs) {
        if (this.containsWildcards(searchPath)) {
            String[] categoryParts = categoryPath.split("\\\\");
            String[] searchParts = searchPath.split("\\\\");
            if (searchParts.length > categoryParts.length || !subs && searchParts.length != categoryParts.length) {
                return false;
            }
            for (int i = 0; i < searchParts.length; ++i) {
                if (this.comparePathPart(searchParts[i], categoryParts[i])) continue;
                return false;
            }
            return true;
        }
        if (searchPath.equals(categoryPath)) {
            return true;
        }
        if (subs) {
            return categoryPath.startsWith(searchPath + "\\");
        }
        return false;
    }

    private boolean comparePathPart(String searchPart, String categoryPart) {
        if (this.containsWildcards(searchPart)) {
            searchPart = searchPart.replace("?", ".");
            searchPart = searchPart.replace("*", "[0-9A-Z \\n\\r\\t]");
            Pattern pattern = Pattern.compile(searchPart, 2);
            Matcher matcher = pattern.matcher(categoryPart);
            boolean find = matcher.find();
            return find;
        }
        return searchPart.equals(categoryPart);
    }

    private boolean containsWildcards(String text) {
        return text.indexOf(42) > -1 || text.indexOf(63) > -1;
    }

    public int calcWorkingHours(int resource, Object startOfPeriod, Object endOfPeriod) {
        ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
        SecondCalculater sc = new SecondCalculater();
        rtm.calculateWorkingTime(resource, (Timestamp)startOfPeriod, (Timestamp)endOfPeriod, sc);
        return sc.getResult();
    }

    public double calcWorkingDays(int resource, Object startOfPeriod, Object endOfPeriod) {
        ResourceTimelineManager rtm = ResourceTimelineManager.getInstance();
        DayCalculater dc = new DayCalculater();
        rtm.calculateWorkingTime(resource, (Timestamp)startOfPeriod, (Timestamp)endOfPeriod, dc);
        return dc.getResult();
    }

    /*
     * Exception decompiling
     */
    public Integer[] calculateTicketTimes(int ticketID, int resource, int replacementForDispatch, Timestamp startPeriod, Timestamp endPeriod) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class DayCalculater
    implements ResultCalculator {
        private double periodDays = 0.0;

        private DayCalculater() {
        }

        @Override
        public void addDayPart(ResourceFieldWorkingHours.HourRange dayRange, LocalDateTime ldtStart, LocalDateTime ldtEnd) {
            this.periodDays += this.calcDayParts(dayRange, ldtStart, ldtEnd);
        }

        @Override
        public void addDay(ResourceFieldWorkingHours.HourRange dayRange) {
            this.periodDays += 1.0;
        }

        private double getResult() {
            return this.periodDays;
        }

        private double calcDayParts(ResourceFieldWorkingHours.HourRange dayRange, LocalDateTime ldtStart, LocalDateTime ldtEnd) {
            long minutesOfWorkingDay = Duration.between(dayRange.getStart(), dayRange.getEnd()).toMinutes();
            long minutesForTicket = 0L;
            if (ldtStart != null) {
                LocalTime ltStart = ldtStart.toLocalTime();
                if (ltStart.isBefore(dayRange.getEnd())) {
                    if (ltStart.isBefore(dayRange.getStart())) {
                        ltStart = dayRange.getStart();
                    }
                    LocalTime ltEnd = dayRange.getEnd();
                    if (ldtStart.toLocalDate().equals(ldtEnd.toLocalDate())) {
                        LocalTime ltTicketEnd = ldtEnd.toLocalTime();
                        if (ltTicketEnd.isBefore(ltStart)) {
                            return 0.0;
                        }
                        if (ltTicketEnd.isBefore(ltEnd)) {
                            ltEnd = ltTicketEnd;
                        }
                    }
                    minutesForTicket = Duration.between(ltStart, ltEnd).toMinutes();
                }
            } else {
                LocalTime ltTicketEnd = ldtEnd.toLocalTime();
                if (ltTicketEnd.isAfter(dayRange.getEnd())) {
                    return 1.0;
                }
                if (ltTicketEnd.isAfter(dayRange.getStart())) {
                    minutesForTicket = Duration.between(dayRange.getStart(), ltTicketEnd).toMinutes();
                }
            }
            return (double)minutesForTicket / (double)minutesOfWorkingDay;
        }
    }

    private class SecondCalculater
    implements ResultCalculator {
        private long periodSeconds = 0L;

        private SecondCalculater() {
        }

        @Override
        public void addDayPart(ResourceFieldWorkingHours.HourRange dayRange, LocalDateTime ldtStart, LocalDateTime ldtEnd) {
            this.periodSeconds += this.calcDayParts(dayRange, ldtStart, ldtEnd);
        }

        @Override
        public void addDay(ResourceFieldWorkingHours.HourRange dayRange) {
            this.periodSeconds += Duration.between(dayRange.getStart(), dayRange.getEnd()).getSeconds();
        }

        private int getResult() {
            return (int)this.periodSeconds;
        }

        private long calcDayParts(ResourceFieldWorkingHours.HourRange dayRange, LocalDateTime ldtStart, LocalDateTime ldtEnd) {
            if (ldtStart != null) {
                LocalTime ltStart = ldtStart.toLocalTime();
                if (ltStart.isBefore(dayRange.getEnd())) {
                    if (ltStart.isBefore(dayRange.getStart())) {
                        ltStart = dayRange.getStart();
                    }
                    LocalTime ltEnd = dayRange.getEnd();
                    if (ldtStart.toLocalDate().equals(ldtEnd.toLocalDate())) {
                        LocalTime ltTicketEnd = ldtEnd.toLocalTime();
                        if (ltTicketEnd.isBefore(ltStart)) {
                            return 0L;
                        }
                        if (ltTicketEnd.isBefore(ltEnd)) {
                            ltEnd = ltTicketEnd;
                        }
                    }
                    return Duration.between(ltStart, ltEnd).getSeconds();
                }
            } else {
                LocalTime ltTicketEnd = ldtEnd.toLocalTime();
                if (ltTicketEnd.isAfter(dayRange.getEnd())) {
                    return Duration.between(dayRange.getStart(), dayRange.getEnd()).getSeconds();
                }
                if (ltTicketEnd.isAfter(dayRange.getStart())) {
                    return Duration.between(dayRange.getStart(), ltTicketEnd).getSeconds();
                }
            }
            return 0L;
        }
    }

    private class ProcessingPeriod {
        TicketPeriodTypes periodType;
        private Timestamp start;
        private Timestamp end;

        private ProcessingPeriod(TicketPeriodTypes periodType, Timestamp start, Timestamp end) {
            this.periodType = periodType;
            this.start = start;
            this.end = end;
        }
    }

    private class TicketProcessingData {
        private Timestamp startTime;
        private Timestamp inquiryTime;
        private Timestamp authorization;
        private Timestamp finished;
        private ArrayList<ProcessingPeriod> calculationPeriods = new ArrayList();

        private TicketProcessingData() {
        }

        private ProcessingPeriod addPeriod(ProcessingPeriod processingPeriod) {
            this.calculationPeriods.add(processingPeriod);
            return processingPeriod;
        }
    }

    public static enum TicketPeriodTypes {
        workFlowWaiting,
        dispatchWaitingForAnswer,
        processWaitingForAnswer,
        processInternal,
        processStopwatch,
        processWaitingForFinish,
        dispatchReactionNeeded,
        processReactionNeeded,
        processFollowup,
        finished;

    }
}

