/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.plugins.reporting.server.userfunctions;

import com.inet.helpdesk.core.HDLogger;
import com.inet.helpdesk.core.permissions.HdPermissions;
import com.inet.helpdesk.shared.LicenceInfo;
import com.inet.helpdesk.usersandgroups.HDUsersAndGroups;
import com.inet.http.servlet.SessionStore;
import com.inet.id.GUID;
import com.inet.permissions.AccessDeniedException;
import com.inet.permissions.Permission;
import com.inet.permissions.PermissionCheckScope;
import com.inet.permissions.SystemPermissionChecker;
import com.inet.report.formula.UserDefinedFunction;
import com.inet.search.SearchResult;
import com.inet.search.command.SearchCondition;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;

public class ReportRestrictionFunctions
implements UserDefinedFunction {
    private static final int USER_COUNT_LICENSE = 0;
    private static final int NAMED_USER_LICENSE = 1;
    private static final int NAMED_USER_LICENSE_ERROR = 2;

    public boolean hasAccessToUserManager() {
        return SystemPermissionChecker.checkAccess((Permission)UsersAndGroups.PERMISSION_USERS_AND_GROUPS_MANAGER);
    }

    public boolean hasAccessToOptions() {
        return SystemPermissionChecker.checkAccess((Permission)HdPermissions.OPTIONS);
    }

    public boolean hasAccessToInventory() {
        return SystemPermissionChecker.checkAccess((Permission)HdPermissions.INVENTORY_READ);
    }

    public boolean hasAccessToReports() {
        return SystemPermissionChecker.checkAccess((Permission)HdPermissions.REPORTS);
    }

    public boolean hasWriteAccessToInventory() {
        return SystemPermissionChecker.checkAccess((Permission)HdPermissions.INVENTORY_READ_WRITE);
    }

    public boolean isCurrentUser(int usrID) throws AccessDeniedException {
        UserManager um = UserManager.getInstance();
        GUID accountID = um.getCurrentUserAccountID();
        if (accountID == null) {
            HDLogger.error("User Login required for id check!");
            throw new AccessDeniedException();
        }
        return usrID == HDUsersAndGroups.getUserID(accountID);
    }

    public boolean userHasPermission(int userID, String permissionKey) throws IllegalArgumentException {
        UserAccount ua = HDUsersAndGroups.getUserAccount(userID);
        if (ua == null) {
            throw new IllegalArgumentException("Invalid user ID " + userID);
        }
        PermissionCheckScope checkScope = new PermissionCheckScope(ua);
        Permission p = Permission.valueOf((String)permissionKey);
        return SystemPermissionChecker.hasAnyPermission((PermissionCheckScope)checkScope, (Permission[])new Permission[]{p});
    }

    public String getServerURL() {
        try {
            int position;
            HttpServletRequest req = SessionStore.getHttpServletRequest();
            String url = req.getRequestURL().toString();
            if (url.indexOf(63) > 0) {
                url = url.substring(0, url.indexOf(63));
            }
            if ((position = url.indexOf("/rpc/")) > -1) {
                url = url.substring(0, position + 1);
            }
            return url;
        }
        catch (Exception ex) {
            HDLogger.error(ex);
            return "";
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isSupervisorOf(int userId) throws IllegalArgumentException, AccessDeniedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean hasReadAccessToTickets(int[] tickets) throws AccessDeniedException {
        if (tickets == null) {
            return false;
        }
        for (int id : tickets) {
            if (this.hasReadAccessToTicket(id)) continue;
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public boolean hasReadAccessToTicket(int ticketId) throws AccessDeniedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 8 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Boolean[] getNamedUserPermissionsFlags() {
        Permission[] permissions = HdPermissions.getSortedPermissions();
        List<Permission> namedPermissions = Arrays.asList(HdPermissions.getNamedUserLicensePermissions());
        Boolean[] values = new Boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            values[i] = namedPermissions.contains(permissions[i]) ? Boolean.TRUE : Boolean.FALSE;
        }
        return values;
    }

    public String[] getUserPermissionsNames() {
        Permission[] permissions = HdPermissions.getSortedPermissions();
        String[] names = new String[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            names[i] = permissions[i].getDisplayName();
        }
        return names;
    }

    public String[] getUserPermissionsKeys() {
        Permission[] permissions = HdPermissions.getSortedPermissions();
        String[] keys = new String[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            keys[i] = permissions[i].getKey();
        }
        return keys;
    }

    public int getNamedUserLicenseInfo() {
        LicenceInfo licInf = LicenceInfo.getInstance();
        if (licInf.isNamedUserLicence()) {
            if (licInf.getNamedUserLicenceCount() < licInf.getNamedUserCount()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public Boolean[] getUserHasPermissions(int userId, String[] permissionKeys) throws IllegalArgumentException {
        UserAccount ua = HDUsersAndGroups.getUserAccount(userId);
        if (ua == null) {
            throw new IllegalArgumentException("Invalid user ID " + userId);
        }
        Boolean[] result = new Boolean[permissionKeys.length];
        try {
            PermissionCheckScope checkScope = new PermissionCheckScope(ua);
            for (int i = 0; i < permissionKeys.length; ++i) {
                Permission p = Permission.valueOf((String)permissionKeys[i]);
                result[i] = SystemPermissionChecker.hasAnyPermission((PermissionCheckScope)checkScope, (Permission[])new Permission[]{p});
            }
        }
        catch (IllegalArgumentException ec) {
            HDLogger.error(ec);
        }
        return result;
    }

    public Integer[] getAllUsersWithPermissions() {
        ArrayList<SearchCondition> additionalExpressions = new ArrayList<SearchCondition>();
        additionalExpressions.add(new SearchCondition("permissions", SearchCondition.SearchTermOperator.StartsWith, (Object)""));
        UserGroupManager groupManager = UserGroupManager.getInstance();
        SearchResult groupResult = groupManager.search("", additionalExpressions, new ArrayList(), Integer.MAX_VALUE, null);
        Stream<Integer> groupIdStream = groupResult.getEntries().stream().map(e -> groupManager.getGroup((GUID)e.getId())).flatMap(g -> g.getMemberIDs().stream()).map(HDUsersAndGroups::getUserID);
        SearchResult result = UserManager.getInstance().search("", additionalExpressions, new ArrayList(), Integer.MAX_VALUE, null);
        Stream<Integer> individualStream = result.getEntries().stream().map(e -> HDUsersAndGroups.getUserID((GUID)e.getId()));
        Set supporters = groupManager.getGroups(HDUsersAndGroups.RESOURCE);
        supporters.addAll(groupManager.getGroups(UsersAndGroups.GROUPTYPE_ADMIN));
        Stream<Integer> supportersUserIdStream = supporters.stream().map(UserGroupInfo::getMemberIDs).flatMap(Collection::stream).map(HDUsersAndGroups::getUserID);
        Stream<Integer> allIds = Stream.concat(Stream.concat(groupIdStream, individualStream), supportersUserIdStream);
        return (Integer[])allIds.distinct().toArray(Integer[]::new);
    }
}

