/*
 * Decompiled with CFR 0.152.
 */
package com.inet.helpdesk.data.valueprovider;

import com.inet.config.ConfigValue;
import com.inet.helpdesk.config.Freifeld;
import com.inet.helpdesk.config.FreifeldSetting;
import com.inet.helpdesk.config.FreifeldSettingList;
import com.inet.helpdesk.config.FreifeldType;
import com.inet.helpdesk.config.HDConfigKeys;
import com.inet.helpdesk.core.data.ConnectionFactory;
import com.inet.helpdesk.core.data.ServerDataException;
import com.inet.helpdesk.core.data.ServerValuesConnector;
import com.inet.helpdesk.core.model.general.Entry;
import com.inet.helpdesk.data.ServerDataConnectorImpl;
import com.inet.helpdesk.shared.model.Field;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.api.user.UserAccount;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.SuppressFBWarnings;

public class QueryValueProvider
implements ServerValuesConnector.ValueProvider {
    private static final ConfigValue<FreifeldSettingList> FREIFELDER = new ConfigValue(HDConfigKeys.FREIFELDER);
    private static final Object[][] ALIAS_TO_FIELD = new Object[][]{{Freifeld.auftrag1, Field.TICKETDATA_TICKETFIELD1}, {Freifeld.auftrag2, Field.TICKETDATA_TICKETFIELD2}, {Freifeld.auftrag3, Field.TICKETDATA_TICKETFIELD3}, {Freifeld.auftrag4, Field.TICKETDATA_TICKETFIELD4}, {Freifeld.auftrag5, Field.TICKETDATA_TICKETFIELD5}, {Freifeld.auftrag6, Field.TICKETDATA_TICKETFIELD6}, {Freifeld.auftrag7, Field.TICKETDATA_TICKETFIELD7}, {Freifeld.kennung, Field.TICKETDATA_SPECIALFIELD}, {Freifeld.benutzer1, Field.USERDATA_USERFIELD1}, {Freifeld.benutzer2, Field.USERDATA_USERFIELD2}, {Freifeld.benutzer3, Field.USERDATA_USERFIELD3}, {Freifeld.benutzer4, Field.USERDATA_USERFIELD4}, {Freifeld.benutzer5, Field.USERDATA_USERFIELD5}, {Freifeld.abteilung, Field.USERDATA_DEPARTMENT}};
    private final String db;
    private final String command;
    private final boolean allowCustom;
    private final boolean allowMulti;
    private final String fieldKey;
    private int myId;

    public QueryValueProvider(String db, String command, boolean allowCustom, boolean allowMulti, String fieldKey) {
        String fieldKeyToSet = fieldKey;
        for (Object[] keyToField : ALIAS_TO_FIELD) {
            if (!((Freifeld)((Object)keyToField[0])).name().equals(fieldKey)) continue;
            fieldKeyToSet = ((Field)((Object)keyToField[1])).name();
            break;
        }
        this.fieldKey = fieldKeyToSet;
        this.db = db;
        this.command = command;
        this.allowCustom = allowCustom;
        this.allowMulti = allowMulti;
    }

    @Override
    public String getFieldKey() {
        return this.fieldKey;
    }

    @Override
    public void notifyRegisteredId(int yourId) {
        this.myId = yourId;
    }

    @Override
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="internally created statement")
    public ArrayList<Entry> getData(UserAccount account, boolean emptyValue) throws ServerDataException {
        ConnectionFactory factory = (ConnectionFactory)ServerPluginManager.getInstance().getSingleInstance(ConnectionFactory.class);
        Connection con = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<Entry> result = new ArrayList<Entry>();
        if (emptyValue && !this.allowMulti) {
            result.add(new Entry(this.myId, "".hashCode(), "", ""));
        }
        try {
            con = factory.getConnection(this.db);
            Object query = factory.getCommand(this.command);
            if (!(query instanceof String)) {
                ArrayList<Entry> arrayList = null;
                return arrayList;
            }
            pst = con.prepareStatement(query.toString());
            rs = pst.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                if (StringFunctions.isEmpty((String)key)) continue;
                Entry res = new Entry(this.myId, key.hashCode(), key, key);
                result.add(res);
            }
            ServerDataConnectorImpl.closeAll(con, pst, rs);
        }
        catch (SQLException e) {
            throw new ServerDataException(e);
        }
        finally {
            ServerDataConnectorImpl.closeAll(con, pst, rs);
        }
        return result;
    }

    @Override
    public boolean allowMultipleValues() {
        return this.allowMulti;
    }

    @Override
    public boolean allowCustomValues() {
        return this.allowCustom && !this.allowMulti;
    }

    public static List<ServerValuesConnector.ValueProvider> getQueryValueProviders() {
        ArrayList<ServerValuesConnector.ValueProvider> result = new ArrayList<ServerValuesConnector.ValueProvider>();
        FreifeldSettingList list = (FreifeldSettingList)FREIFELDER.get();
        for (int i = 0; i < ALIAS_TO_FIELD.length; ++i) {
            Object[] valueToField = ALIAS_TO_FIELD[i];
            Freifeld value = (Freifeld)((Object)valueToField[0]);
            FreifeldSetting setting = list.stream().filter(s -> s.getFreifeld() == value).findFirst().orElse(null);
            if (setting == null) continue;
            String db = setting.getDatabase();
            String command = setting.getQueryName();
            boolean allowCustom = setting.getFreifeldType() == FreifeldType.Editable;
            boolean allowMulti = setting.getFreifeldType() == FreifeldType.Multi;
            Field field = (Field)((Object)valueToField[1]);
            String fieldKey = field.name();
            result.add(new QueryValueProvider(db, command, allowCustom, allowMulti, fieldKey));
        }
        return result;
    }

    @Override
    public boolean hasData(UserAccount account) throws ServerDataException {
        return true;
    }

    @Override
    public Entry getDefaultValue(UserAccount account) {
        return new Entry(this.myId, "".hashCode(), "", "");
    }
}

